/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.WMS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.StreamingRenderer;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.AbstractGetMapProducer;
import org.vfny.geoserver.wms.responses.MaxErrorEnforcer;
import org.vfny.geoserver.wms.responses.RenderExceptionStrategy;
import org.w3c.dom.Document;

class SVGBatikMapProducer
extends AbstractGetMapProducer
implements GetMapProducer {
    StreamingRenderer renderer;
    private WMS wmsConfig;

    public SVGBatikMapProducer(String mimeType, String[] outputFormats, WMS wms) {
        super(mimeType, outputFormats);
        this.wmsConfig = wms;
    }

    public void abort(GeoServer gs) {
        if (this.renderer != null) {
            this.renderer.stopRendering();
        }
    }

    public void produceMap() throws WmsException {
        this.renderer = new StreamingRenderer();
        HashMap<String, Comparable<Boolean>> rendererParams = new HashMap<String, Comparable<Boolean>>();
        rendererParams.put("optimizedDataLoadingEnabled", Boolean.TRUE);
        rendererParams.put("optimizeFTSRendering", Boolean.FALSE);
        rendererParams.put("vectorRenderingEnabled", Boolean.TRUE);
        rendererParams.put("renderingBuffer", new Integer(this.mapContext.getBuffer()));
        if (DefaultWebMapService.isLineWidthOptimizationEnabled()) {
            rendererParams.put("lineWidthOptimization", Boolean.valueOf(true));
        }
        if (DefaultWebMapService.isAdvancedProjectionHandlingEnabled()) {
            rendererParams.put("advancedProjectionHandling", Boolean.valueOf(true));
        }
        this.renderer.setRendererHints(rendererParams);
        this.renderer.setContext((MapContext)this.mapContext);
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        try {
            try {
                MapContext map = this.renderer.getContext();
                double width = -1.0;
                double height = -1.0;
                if (map instanceof WMSMapContext) {
                    WMSMapContext wmsMap = (WMSMapContext)map;
                    width = wmsMap.getMapWidth();
                    height = wmsMap.getMapHeight();
                } else {
                    ReferencedEnvelope area = map.getAreaOfInterest();
                    if (area.getHeight() > 0.0 && area.getWidth() > 0.0) {
                        if (area.getHeight() >= area.getWidth()) {
                            height = 600.0;
                            width = height * (area.getWidth() / area.getHeight());
                        } else {
                            width = 800.0;
                            height = width * (area.getHeight() / area.getWidth());
                        }
                    }
                }
                if (height == -1.0 || width == -1.0) {
                    throw new IOException("Could not determine map dimensions");
                }
                SVGGeneratorContext context = this.setupContext();
                SVGGraphics2D g = new SVGGraphics2D(context, true);
                g.setSVGCanvasSize(new Dimension((int)width, (int)height));
                if (this.wmsConfig.isSvgAntiAlias()) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                int maxErrors = this.wmsConfig.getMaxRenderingErrors();
                MaxErrorEnforcer errorChecker = new MaxErrorEnforcer((GTRenderer)this.renderer, maxErrors);
                RenderExceptionStrategy nonIgnorableExceptionListener = new RenderExceptionStrategy((GTRenderer)this.renderer);
                this.renderer.addRenderListener((RenderListener)nonIgnorableExceptionListener);
                this.renderer.paint((Graphics2D)g, new Rectangle(g.getSVGCanvasSize()), this.getRenderingArea(), this.getRenderingTransform());
                if (errorChecker.exceedsMaxErrors()) {
                    throw new WmsException("More than " + maxErrors + " rendering errors occurred, bailing out.", "internalError", errorChecker.getLastException());
                }
                if (nonIgnorableExceptionListener.exceptionOccurred()) {
                    Exception renderError = nonIgnorableExceptionListener.getException();
                    throw new WmsException("Rendering process failed", "internalError", renderError);
                }
                OutputFormat format = new OutputFormat();
                XMLSerializer serializer = new XMLSerializer((Writer)new OutputStreamWriter(out, "UTF-8"), format);
                g.stream((Writer)new OutputStreamWriter(out, "UTF-8"));
            }
            catch (ParserConfigurationException e) {
                throw new WmsException("Unexpected exception", "internalError", e);
            }
        }
        finally {
            this.renderer = null;
        }
    }

    private SVGGeneratorContext setupContext() throws FactoryConfigurationError, ParserConfigurationException {
        Document document = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        String svgNamespaceURI = "http://www.w3.org/2000/svg";
        document = db.getDOMImplementation().createDocument(svgNamespaceURI, "svg", null);
        return SVGGeneratorContext.createDefault((Document)document);
    }
}

