/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.CoordinateSequence;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import org.geotools.gml.producer.CoordinateWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class KMLCoordinateWriter
extends CoordinateWriter {
    private AttributesImpl atts;
    private static final double DECIMAL_MIN = Math.pow(10.0, -3.0);
    private static final double DECIMAL_MAX = Math.pow(10.0, 7.0);
    private static final String coordinateDelimiter = ",";
    private static final String tupleDelimiter = " ";
    private final StringBuffer coordBuff = new StringBuffer();
    private char[] buff = new char[200];
    private final double scale;
    private final NumberFormat coordFormatter = NumberFormat.getInstance(Locale.US);
    private final FieldPosition zero = new FieldPosition(0);
    private final int D;

    public KMLCoordinateWriter(int numDecimals, boolean isDummyZEnabled) {
        super(numDecimals, isDummyZEnabled);
        this.atts = new AttributesImpl();
        this.scale = Math.pow(10.0, numDecimals);
        this.D = 3;
    }

    public void writeCoordinates(CoordinateSequence c, ContentHandler output) throws SAXException {
        output.startElement("", "coordinates", "coordinates", this.atts);
        int coordCount = c.size();
        int coordSeqDimension = c.getDimension();
        int i = 0;
        int n = coordCount;
        while (i < n) {
            double x = c.getOrdinate(i, 0);
            double y = c.getOrdinate(i, 1);
            this.coordBuff.setLength(0);
            this.formatDecimal(x, this.coordBuff);
            this.coordBuff.append(coordinateDelimiter);
            this.formatDecimal(y, this.coordBuff);
            if (coordSeqDimension > 2 && !Double.isNaN(c.getOrdinate(i, 2))) {
                this.coordBuff.append(coordinateDelimiter);
                this.formatDecimal(c.getOrdinate(i, 2), this.coordBuff);
            }
            if (i + 1 < coordCount) {
                this.coordBuff.append(tupleDelimiter);
            }
            if (this.coordBuff.length() > this.buff.length) {
                this.buff = new char[this.coordBuff.length()];
            }
            this.coordBuff.getChars(0, this.coordBuff.length(), this.buff, 0);
            output.characters(this.buff, 0, this.coordBuff.length());
            ++i;
        }
        output.endElement(null, "coordinates", "coordinates");
    }

    private void formatDecimal(double x, StringBuffer sb) {
        if (Math.abs(x) >= DECIMAL_MIN && x < DECIMAL_MAX) {
            long lx = (long)(x = Math.floor(x * this.scale + 0.5) / this.scale);
            if ((double)lx == x) {
                sb.append(lx);
            } else {
                sb.append(x);
            }
        } else {
            this.coordFormatter.format(x, this.coordBuff, this.zero);
        }
    }
}

