/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import org.geoserver.kml.KMLTransformer;
import org.geoserver.kml.KMZMapOutputFormat;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.map.AbstractMapResponse;
import org.geoserver.wms.map.PNGMapResponse;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geoserver.wms.map.XMLTransformerMap;
import org.geotools.map.MapLayer;
import org.geotools.xml.transform.TransformerBase;
import org.springframework.util.Assert;

public class KMZMapResponse
extends AbstractMapResponse {
    private WMS wms;

    public KMZMapResponse(WMS wms) {
        super(KMZMap.class, KMZMapOutputFormat.OUTPUT_FORMATS);
        this.wms = wms;
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        Assert.isInstanceOf(XMLTransformerMap.class, (Object)value);
        XMLTransformerMap map = (XMLTransformerMap)value;
        try {
            KMLTransformer transformer = (KMLTransformer)map.getTransformer();
            WMSMapContext mapContext = (WMSMapContext)((Object)map.getTransformerSubject());
            ZipOutputStream zip = new ZipOutputStream(output);
            ZipEntry entry = new ZipEntry("wms.kml");
            zip.putNextEntry(entry);
            try {
                transformer.transform((Object)mapContext, zip);
                zip.closeEntry();
            }
            catch (TransformerException e) {
                throw (IOException)new IOException().initCause(e);
            }
            RenderedImageMapOutputFormat pngProducer = new RenderedImageMapOutputFormat("image/png", this.wms);
            PNGMapResponse pngEncoder = new PNGMapResponse(this.wms);
            ZipEntry images = new ZipEntry("images/");
            zip.putNextEntry(images);
            int i = 0;
            while (i < mapContext.getLayerCount()) {
                RenderedImageMap imageMap;
                MapLayer mapLayer = mapContext.getLayer(i);
                WMSMapContext subContext = new WMSMapContext();
                subContext.addLayer(mapLayer);
                subContext.setRequest(mapContext.getRequest());
                subContext.setMapHeight(mapContext.getMapHeight());
                subContext.setMapWidth(mapContext.getMapWidth());
                subContext.setAreaOfInterest(mapContext.getAreaOfInterest());
                subContext.setBgColor(mapContext.getBgColor());
                subContext.setBuffer(mapContext.getBuffer());
                subContext.setContactInformation(mapContext.getContactInformation());
                subContext.setKeywords(mapContext.getKeywords());
                subContext.setAbstract(mapContext.getAbstract());
                subContext.setTransparent(true);
                try {
                    imageMap = pngProducer.produceMap(subContext);
                }
                finally {
                    subContext.dispose();
                }
                entry = new ZipEntry("images/layer_" + i + ".png");
                zip.putNextEntry(entry);
                pngEncoder.write(imageMap, zip, operation);
                zip.closeEntry();
                ++i;
            }
            zip.closeEntry();
            zip.finish();
            zip.flush();
        }
        finally {
            map.dispose();
        }
    }

    public static class KMZMap
    extends XMLTransformerMap {
        public KMZMap(WMSMapContext mapContext, TransformerBase transformer, String mimeType) {
            super(mapContext, transformer, (Object)mapContext, mimeType);
        }
    }
}

