/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.kvp;

import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

class PALFileLoader {
    protected static final Logger LOGGER = Logging.getLogger((String)"it.geosolutions.inversecolormap.PALFileLoader");
    protected int mapsize;
    protected IndexColorModel indexColorModel;

    public PALFileLoader(String filePath) {
        this(new File(filePath));
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PALFileLoader(File file) {
        if (!file.exists() | !file.canRead()) {
            throw new IllegalArgumentException("The provided file cannot be read.");
        }
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                boolean loadNext = false;
                String temp = reader.readLine().trim();
                if (temp.equalsIgnoreCase("JASC-PAL")) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Found header in palette file");
                    }
                    loadNext = true;
                }
                if (loadNext && (temp = reader.readLine().trim()).equalsIgnoreCase("0100")) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Found version in palette file");
                    }
                    loadNext = true;
                }
                if (loadNext) {
                    temp = reader.readLine().trim();
                }
                this.mapsize = Integer.parseInt(temp);
                if (this.mapsize > 256 || this.mapsize <= 0) {
                    throw new IllegalArgumentException("The provided number of colors is invalid");
                }
                byte[][] colorMap = new byte[3][this.mapsize < 256 ? this.mapsize + 1 : this.mapsize];
                int i = 0;
                while (i < this.mapsize) {
                    temp = reader.readLine().trim();
                    if (temp.startsWith("#")) {
                        temp = "0x" + temp.substring(1);
                    }
                    if (temp.startsWith("0x") || temp.startsWith("0X")) {
                        Color color = Color.decode(temp);
                        colorMap[0][i] = (byte)color.getRed();
                        colorMap[1][i] = (byte)color.getGreen();
                        colorMap[2][i] = (byte)color.getBlue();
                    } else {
                        StringTokenizer tokenizer = new StringTokenizer(temp, " ", false);
                        int numComponents = 0;
                        while (tokenizer.hasMoreTokens()) {
                            if (numComponents >= 3) {
                                throw new IllegalArgumentException("The number of components in one the color is greater than 3!");
                            }
                            colorMap[numComponents++][i] = (byte)Integer.parseInt(tokenizer.nextToken());
                        }
                        if (numComponents != 3) {
                            throw new IllegalArgumentException("The number of components in one the color is invalid!");
                        }
                    }
                    ++i;
                }
                this.indexColorModel = this.mapsize < 256 ? new IndexColorModel(8, this.mapsize + 1, colorMap[0], colorMap[1], colorMap[2], this.mapsize) : new IndexColorModel(8, this.mapsize, colorMap[0], colorMap[1], colorMap[2]);
                return;
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {
                    LOGGER.log(Level.INFO, e2.getLocalizedMessage(), e2);
                }
                return;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e3) {
                    LOGGER.log(Level.INFO, e3.getLocalizedMessage(), e3);
                }
                return;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                if (reader == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    reader.close();
                    return;
                }
                catch (IOException e4) {
                    LOGGER.log(Level.INFO, e4.getLocalizedMessage(), e4);
                }
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public IndexColorModel getIndexColorModel() {
        return this.indexColorModel;
    }

    public int getMapsize() {
        return this.mapsize;
    }
}

