/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.RasterCleaner;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.QuickTileCache;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.image.crop.GTCropDescriptor;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetatileMapOutputFormat
implements GetMapOutputFormat {
    private static final RenderingHints NO_CACHE_HINTS = new RenderingHints(JAI.KEY_TILE_CACHE, null);
    private static final Logger LOGGER = Logging.getLogger(MetatileMapOutputFormat.class);
    public static final double EPS = 1.0E-6;
    private static QuickTileCache tileCache;
    private GetMapRequest request;
    private RenderedImageMapOutputFormat delegate;

    public MetatileMapOutputFormat(GetMapRequest request, RenderedImageMapOutputFormat delegate) {
        if (tileCache == null) {
            tileCache = (QuickTileCache)GeoServerExtensions.bean((String)"metaTileCache");
        }
        this.request = request;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebMap produceMap(WMSMapContext mapContext) throws ServiceException, IOException {
        QuickTileCache.MetaTileKey key;
        QuickTileCache.MetaTileKey metaTileKey = key = tileCache.getMetaTileKey(this.request);
        synchronized (metaTileKey) {
            RenderedImage tile = tileCache.getTile(key, this.request);
            List<GridCoverage2D> renderedCoverages = null;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Looked for meta tile " + key.metaTileCoords.x + ", " + key.metaTileCoords.y + "in cache: " + (tile != null ? "hit!" : "miss"));
            }
            if (tile == null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Building meta tile " + key.metaTileCoords.x + ", " + key.metaTileCoords.y);
                }
                mapContext.setAreaOfInterest(key.getMetaTileEnvelope());
                mapContext.setMapWidth(key.getTileSize() * key.getMetaFactor());
                mapContext.setMapHeight(key.getTileSize() * key.getMetaFactor());
                mapContext.setTileSize(key.getTileSize());
                RenderedImageMap metaTileMap = this.delegate.produceMap(mapContext);
                RenderedImage metaTile = metaTileMap.getImage();
                RenderedImage[] tiles = this.split(key, metaTile, mapContext);
                tileCache.storeTiles(key, tiles);
                tile = tileCache.getTile(key, this.request, tiles);
                renderedCoverages = metaTileMap.getRenderedCoverages();
            }
            RenderedImageMap tileMap = new RenderedImageMap(mapContext, tile, this.getMimeType());
            tileMap.setRenderedCoverages(renderedCoverages);
            return tileMap;
        }
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return this.delegate.getOutputFormatNames();
    }

    @Override
    public String getMimeType() {
        return this.delegate.getMimeType();
    }

    public static boolean isRequestTiled(GetMapRequest request, GetMapOutputFormat delegate) {
        boolean tiled = request.isTiled();
        Point2D tilesOrigin = request.getTilesOrigin();
        int width = request.getWidth();
        int height = request.getHeight();
        return tiled && tilesOrigin != null && width == 256 && height == 256 && delegate instanceof RenderedImageMapOutputFormat;
    }

    private RenderedImage[] split(QuickTileCache.MetaTileKey key, RenderedImage metaTile, WMSMapContext map) {
        int metaFactor = key.getMetaFactor();
        RenderedImage[] tiles = new RenderedImage[key.getMetaFactor() * key.getMetaFactor()];
        int tileSize = key.getTileSize();
        int type = 0;
        if (metaTile instanceof PlanarImage) {
            type = 1;
        } else if (metaTile instanceof BufferedImage) {
            type = 2;
        }
        int i = 0;
        while (i < metaFactor) {
            int j = 0;
            while (j < metaFactor) {
                BufferedImage tile;
                int x = j * tileSize;
                int y = tileSize * (metaFactor - 1) - i * tileSize;
                switch (type) {
                    case 0: {
                        RenderedOp cropped = GTCropDescriptor.create((RenderedImage)metaTile, (Float)Float.valueOf(x), (Float)Float.valueOf(y), (Float)Float.valueOf(tileSize), (Float)Float.valueOf(tileSize), (RenderingHints)NO_CACHE_HINTS);
                        RasterCleaner.addImage((RenderedImage)cropped);
                        tile = cropped.getAsBufferedImage();
                        break;
                    }
                    case 1: {
                        PlanarImage pImage = (PlanarImage)metaTile;
                        WritableRaster wTile = WritableRaster.createWritableRaster(pImage.getSampleModel().createCompatibleSampleModel(tileSize, tileSize), new Point(x, y));
                        Rectangle sourceArea = new Rectangle(x, y, tileSize, tileSize);
                        sourceArea = sourceArea.intersection(pImage.getBounds());
                        pImage.copyData(wTile);
                        if (wTile.getMinX() != 0 || wTile.getMinY() != 0) {
                            tile = new BufferedImage(pImage.getColorModel(), (WritableRaster)wTile.createTranslatedChild(0, 0), pImage.getColorModel().isAlphaPremultiplied(), null);
                            break;
                        }
                        tile = new BufferedImage(pImage.getColorModel(), wTile, pImage.getColorModel().isAlphaPremultiplied(), null);
                        break;
                    }
                    case 2: {
                        BufferedImage image = (BufferedImage)metaTile;
                        tile = image.getSubimage(x, y, tileSize, tileSize);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(Errors.format((int)58, (Object)"metaTile class", (Object)metaTile.getClass().toString()));
                    }
                }
                tiles[i * key.getMetaFactor() + j] = tile;
                ++j;
            }
            ++i;
        }
        RasterCleaner.addImage(metaTile);
        return tiles;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String format) {
        throw new RuntimeException("The meta-tile output format should never be invoked directly!");
    }
}

