/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpSession;
import com.mockrunner.mock.web.MockServletContext;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfoImpl;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureStore;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.RasterMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.GetMapResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSMockData {
    public static final String TEST_NAMESPACE = "http://geoserver.org";
    private CatalogImpl catalog;
    private MemoryDataStore dataStore;
    private DataStoreInfo dataStoreInfo;
    private NamespaceInfoImpl namespaceInfo;
    private WorkspaceInfoImpl workspaceInfo;
    private StyleInfoImpl defaultStyle;
    private GetMapProducer mockMapProducer;
    private GeoServer mockGeoServer;
    private WMS mockWMS;

    public void setUp() throws Exception {
        this.mockMapProducer = new DummyRasterMapProducer();
        this.catalog = new CatalogImpl();
        this.namespaceInfo = new NamespaceInfoImpl();
        this.namespaceInfo.setId("testNs");
        this.namespaceInfo.setPrefix("geos");
        this.namespaceInfo.setURI(TEST_NAMESPACE);
        this.catalog.add((NamespaceInfo)this.namespaceInfo);
        this.workspaceInfo = new WorkspaceInfoImpl();
        this.catalog.setDefaultWorkspace((WorkspaceInfo)this.workspaceInfo);
        this.defaultStyle = new StyleInfoImpl((Catalog)this.catalog){

            public Style getStyle() throws IOException {
                StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
                Style style = styleFactory.createStyle();
                style.setName("Default Style");
                return style;
            }
        };
        this.defaultStyle.setFilename("defaultStyleFileName");
        this.defaultStyle.setId("defaultStyleId");
        this.defaultStyle.setName("defaultStyleName");
        this.catalog.add((StyleInfo)this.defaultStyle);
        this.dataStoreInfo = new DataStoreInfoImpl((Catalog)this.catalog);
        this.dataStoreInfo.setName("mockDataStore");
        this.dataStoreInfo.setEnabled(true);
        this.dataStoreInfo.setWorkspace((WorkspaceInfo)this.workspaceInfo);
        this.dataStore = new MemoryDataStore();
        ResourcePool resourcePool = new ResourcePool((Catalog)this.catalog){

            public DataStore getDataStore(DataStoreInfo info) throws IOException {
                return WMSMockData.this.dataStore;
            }
        };
        this.catalog.setResourcePool(resourcePool);
        this.mockGeoServer = new GeoServerImpl();
        this.mockGeoServer.setCatalog((Catalog)this.catalog);
        GeoServerInfoImpl geoserverInfo = new GeoServerInfoImpl(this.mockGeoServer);
        geoserverInfo.setId("geoserver");
        this.mockGeoServer.setGlobal((GeoServerInfo)geoserverInfo);
        WMSInfoImpl wmsInfo = new WMSInfoImpl();
        wmsInfo.setId("wms");
        wmsInfo.setName("WMS");
        wmsInfo.setEnabled(true);
        this.mockGeoServer.add((ServiceInfo)wmsInfo);
        this.mockWMS = new WMS(this.mockGeoServer);
    }

    public StyleInfo getDefaultStyle() {
        return this.defaultStyle;
    }

    public GetMapRequest createRequest() {
        GetMapRequest request = new GetMapRequest(this.mockWMS);
        request.setFormat("image/dummy");
        request.setWidth(512);
        request.setHeight(256);
        Envelope envelope = new Envelope(-180.0, 180.0, -90.0, 90.0);
        request.setBbox(envelope);
        request.setSRS("EPSG:4326");
        request.setCrs((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        try {
            request.setStyles(Collections.singletonList(this.defaultStyle.getStyle()));
        }
        catch (IOException e) {
            throw new RuntimeException("shouldn't happen", e);
        }
        request.setRawKvp(new HashMap());
        MockHttpServletRequest servletRequest = new MockHttpServletRequest();
        request.setHttpServletRequest((HttpServletRequest)servletRequest);
        MockHttpSession session = new MockHttpSession();
        servletRequest.setSession((HttpSession)session);
        MockServletContext context = new MockServletContext();
        session.setupServletContext((ServletContext)context);
        return request;
    }

    public GetMapResponse createResponse() {
        return this.createResponse(Collections.singletonList(this.mockMapProducer));
    }

    public GetMapResponse createResponse(List<GetMapProducer> availableProducers) {
        GetMapResponse getMap = new GetMapResponse(availableProducers);
        return getMap;
    }

    public MapLayerInfo addFeatureTypeLayer(String name, Class<? extends Geometry> geometryType) throws IOException {
        FeatureTypeInfoImpl featureTypeInfo = new FeatureTypeInfoImpl((Catalog)this.catalog);
        featureTypeInfo.setName(name);
        featureTypeInfo.setNativeName(name);
        featureTypeInfo.setEnabled(true);
        DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope bbox = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)wgs84);
        featureTypeInfo.setLatLonBoundingBox(bbox);
        featureTypeInfo.setNamespace((NamespaceInfo)this.namespaceInfo);
        featureTypeInfo.setNativeBoundingBox(bbox);
        featureTypeInfo.setNativeCRS((CoordinateReferenceSystem)wgs84);
        featureTypeInfo.setSRS("EPSG:4326");
        featureTypeInfo.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        featureTypeInfo.setStore((StoreInfo)this.dataStoreInfo);
        this.catalog.add((ResourceInfo)featureTypeInfo);
        LayerInfoImpl layerInfo = new LayerInfoImpl();
        layerInfo.setResource((ResourceInfo)featureTypeInfo);
        layerInfo.setName(name);
        layerInfo.setEnabled(true);
        layerInfo.setDefaultStyle((StyleInfo)this.defaultStyle);
        layerInfo.setType(LayerInfo.Type.VECTOR);
        this.catalog.add((LayerInfo)layerInfo);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setNamespaceURI(TEST_NAMESPACE);
        ftb.setName(name);
        ftb.add("name", String.class);
        ftb.add("geom", geometryType, (CoordinateReferenceSystem)wgs84);
        SimpleFeatureType featureType = ftb.buildFeatureType();
        this.dataStore.createSchema(featureType);
        return new MapLayerInfo((LayerInfo)layerInfo);
    }

    public SimpleFeature addFeature(SimpleFeatureType featureType, Object[] values) throws IOException, ParseException {
        FeatureStore fs = (FeatureStore)this.dataStore.getFeatureSource(featureType.getName());
        SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(featureType);
        sfb.addAll(values);
        SimpleFeature feature = sfb.buildFeature(null);
        fs.addFeatures(DataUtilities.collection((SimpleFeature)feature));
        return feature;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummyRasterMapProducer
    implements RasterMapProducer {
        public static final String MIME_TYPE = "image/dummy";
        public WMSMapContext mapContext;
        public boolean abortCalled;
        public boolean produceMapCalled;
        public String outputFormat;
        public boolean writeToCalled;

        public void formatImageOutputStream(RenderedImage image, OutputStream outStream) throws WmsException, IOException {
        }

        public RenderedImage getImage() {
            return null;
        }

        public void abort() {
            this.abortCalled = true;
        }

        public String getContentDisposition() {
            return null;
        }

        public String getContentType() throws IllegalStateException {
            return MIME_TYPE;
        }

        public String getOutputFormat() {
            return MIME_TYPE;
        }

        public void setMapContext(WMSMapContext mapContext) {
            this.mapContext = mapContext;
        }

        public WMSMapContext getMapContext() {
            return this.mapContext;
        }

        public Set<String> getOutputFormatNames() {
            return Collections.singleton(MIME_TYPE);
        }

        public void produceMap() throws WmsException {
            this.produceMapCalled = true;
        }

        public void setOutputFormat(String format) {
            this.outputFormat = format;
        }

        public void writeTo(OutputStream out) throws ServiceException, IOException {
            this.writeToCalled = true;
        }
    }
}

