/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import com.mockrunner.mock.web.MockHttpServletRequest;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import junit.framework.Test;
import org.geoserver.platform.ServiceException;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.styling.Style;
import org.vfny.geoserver.wms.requests.GetLegendGraphicKvpReader;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;
import org.vfny.geoserver.wms.servlets.GetLegendGraphic;

public class GetLegendGraphicKvpReaderTest
extends WMSTestSupport {
    GetLegendGraphicKvpReader requestReader;
    Map<String, String> requiredParameters;
    Map<String, String> optionalParameters;
    Map<String, String> allParameters;
    MockHttpServletRequest httpRequest;
    WMS wms;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetLegendGraphicKvpReaderTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.requiredParameters = new HashMap<String, String>();
        this.requiredParameters.put("VERSION", "1.0.0");
        this.requiredParameters.put("REQUEST", "GetLegendGraphic");
        this.requiredParameters.put("LAYER", "cite:Ponds");
        this.requiredParameters.put("FORMAT", "image/png");
        this.optionalParameters = new HashMap<String, String>();
        this.optionalParameters.put("STYLE", "Ponds");
        this.optionalParameters.put("FEATURETYPE", "fake_not_used");
        this.optionalParameters.put("SCALE", "1000");
        this.optionalParameters.put("WIDTH", "120");
        this.optionalParameters.put("HEIGHT", "90");
        this.allParameters = new HashMap<String, String>(this.requiredParameters);
        this.allParameters.putAll(this.optionalParameters);
        this.wms = this.getWMS();
        GetLegendGraphic service = new GetLegendGraphic(this.wms);
        this.requestReader = new GetLegendGraphicKvpReader(this.allParameters, this.wms);
        this.httpRequest = this.createRequest("wms", this.allParameters);
    }

    public void testRemoteSLDMultipleStyles() throws ServiceException {
        URL remoteSldUrl = ((Object)((Object)this)).getClass().getResource("MultipleStyles.sld");
        this.allParameters.put("SLD", remoteSldUrl.toExternalForm());
        this.allParameters.put("LAYER", "cite:Ponds");
        this.allParameters.put("STYLE", "Ponds");
        this.requestReader = new GetLegendGraphicKvpReader(this.allParameters, this.wms);
        GetLegendGraphicRequest request = (GetLegendGraphicRequest)this.requestReader.getRequest((HttpServletRequest)this.httpRequest);
        Style selectedStyle = request.getStyle();
        GetLegendGraphicKvpReaderTest.assertNotNull((Object)selectedStyle);
        GetLegendGraphicKvpReaderTest.assertEquals((String)"Ponds", (String)selectedStyle.getName());
        this.allParameters.put("LAYER", "cite:Lakes");
        this.allParameters.put("STYLE", "Lakes");
        this.requestReader = new GetLegendGraphicKvpReader(this.allParameters, this.wms);
        request = (GetLegendGraphicRequest)this.requestReader.getRequest((HttpServletRequest)this.httpRequest);
        selectedStyle = request.getStyle();
        GetLegendGraphicKvpReaderTest.assertNotNull((Object)selectedStyle);
        GetLegendGraphicKvpReaderTest.assertEquals((String)"Lakes", (String)selectedStyle.getName());
    }

    public void testMissingLayerParameter() {
        this.requiredParameters.remove("LAYER");
        this.requestReader = new GetLegendGraphicKvpReader(this.requiredParameters, this.wms);
        try {
            this.requestReader.getRequest((HttpServletRequest)this.httpRequest);
            GetLegendGraphicKvpReaderTest.fail((String)"Expected ServiceException");
        }
        catch (ServiceException e) {
            GetLegendGraphicKvpReaderTest.assertEquals((String)"LayerNotDefined", (String)e.getCode());
        }
    }

    public void testMissingFormatParameter() {
        this.requiredParameters.remove("FORMAT");
        this.requestReader = new GetLegendGraphicKvpReader(this.requiredParameters, this.wms);
        try {
            this.requestReader.getRequest((HttpServletRequest)this.httpRequest);
            GetLegendGraphicKvpReaderTest.fail((String)"Expected ServiceException");
        }
        catch (ServiceException e) {
            GetLegendGraphicKvpReaderTest.assertEquals((String)"MissingFormat", (String)e.getCode());
        }
    }

    public void testStrictParameter() {
        this.requestReader = new GetLegendGraphicKvpReader(this.allParameters, this.wms);
        GetLegendGraphicRequest request = (GetLegendGraphicRequest)this.requestReader.getRequest((HttpServletRequest)this.httpRequest);
        GetLegendGraphicKvpReaderTest.assertTrue((boolean)request.isStrict());
        this.allParameters.put("STRICT", "false");
        this.allParameters.remove("LAYER");
        this.requestReader = new GetLegendGraphicKvpReader(this.allParameters, this.wms);
        request = (GetLegendGraphicRequest)this.requestReader.getRequest((HttpServletRequest)this.httpRequest);
        GetLegendGraphicKvpReaderTest.assertFalse((boolean)request.isStrict());
    }
}

