/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.data.test.TestData;
import org.geoserver.test.GeoServerAbstractTestSupport;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMockData;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.xml.transform.TransformerBase;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.kml.KMLLegendTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLReflectorTest;
import org.w3c.dom.Document;

public class KMLLegendTransformerTest
extends GeoServerAbstractTestSupport {
    private WMSMockData mockData;
    private WMSMapContext mapContext;
    private MapLayer mapLayer;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new KMLLegendTransformerTest());
    }

    protected TestData buildTestData() throws Exception {
        return new TestData(){

            public File getDataDirectoryRoot() {
                return null;
            }

            public boolean isTestDataAvailable() {
                return false;
            }

            public void setUp() throws Exception {
            }

            public void tearDown() throws Exception {
            }
        };
    }

    protected void setUpInternal() throws Exception {
        this.mockData = new WMSMockData();
        this.mockData.setUp();
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("TestPoints", Point.class);
        this.mapContext = new WMSMapContext();
        GetMapRequest request = this.mockData.createRequest();
        request.setLayers(new MapLayerInfo[]{layer});
        FeatureSource featureSource = layer.getFeature().getFeatureSource(null, null);
        this.mapLayer = new DefaultMapLayer(featureSource, this.mockData.getDefaultStyle().getStyle());
        MockHttpServletRequest httpreq = (MockHttpServletRequest)request.getHttpServletRequest();
        httpreq.setScheme("http");
        httpreq.setServerName("geoserver.org");
        httpreq.setServerPort(8181);
        httpreq.setContextPath("/geoserver");
        this.mapContext.setRequest(request);
    }

    protected void tearDownInternal() throws Exception {
    }

    public void testKMLLegendTransformer() throws Exception {
        FeatureCollection features = FeatureCollections.newCollection();
        XpathEngine xpath = XMLUnit.newXpathEngine();
        KMLLegendTransformer transformer = new KMLLegendTransformer(this.mapContext);
        transformer.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.mapLayer, (TransformerBase)transformer);
        XMLAssert.assertXpathEvaluatesTo((String)"Legend", (String)"//kml/ScreenOverlay/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/ScreenOverlay/overlayXY/@x", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/ScreenOverlay/overlayXY/@y", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"pixels", (String)"//kml/ScreenOverlay/overlayXY/@xunits", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"pixels", (String)"//kml/ScreenOverlay/overlayXY/@yunits", (Document)dom);
        Map<String, String> expectedKVP = KMLReflectorTest.toKvp("http://geoserver.org:8181/geoserver/wms?service=wms&width=20&height=20&style=Default+Style&request=GetLegendGraphic&layer=&format=image%2Fpng&version=1.1.1");
        Map<String, String> resultantKVP = KMLReflectorTest.toKvp(xpath.evaluate("//kml/ScreenOverlay/Icon/href", dom));
        KMLReflectorTest.assertMapsEqual(expectedKVP, resultantKVP);
    }
}

