/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.legend;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.feature.FeatureCollection;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;
import org.vfny.geoserver.wms.responses.DefaultRasterLegendProducer;
import org.vfny.geoserver.wms.responses.LegendUtils;
import org.vfny.geoserver.wms.servlets.GetLegendGraphic;

public class DefaultRasterLegendProducerTest
extends WMSTestSupport {
    private static final Logger LOGGER = Logging.getLogger((String)DefaultRasterLegendProducerTest.class.getPackage().getName());
    private DefaultRasterLegendProducer legendProducer;
    GetLegendGraphic service;

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addCoverage(new QName("http://www.geo-solutions.it", "world", "gs"), MockData.class.getResource("world.tiff"), "tiff", "raster");
        dataDirectory.addStyle("rainfall", MockData.class.getResource("rainfall.sld"));
        dataDirectory.addStyle("rainfall_ramp", MockData.class.getResource("rainfall_ramp.sld"));
        dataDirectory.addStyle("rainfall_classes", MockData.class.getResource("rainfall_classes.sld"));
    }

    public void setUpInternal() throws Exception {
        super.setUpInternal();
        this.legendProducer = new DefaultRasterLegendProducer(){

            public void writeTo(OutputStream out) throws ServiceException, IOException {
                throw new UnsupportedOperationException();
            }

            public String getContentType() throws IllegalStateException {
                throw new UnsupportedOperationException();
            }
        };
        this.service = new GetLegendGraphic(this.getWMS());
    }

    public void tearDownInternal() throws Exception {
        this.legendProducer = null;
        super.tearDownInternal();
    }

    public void testUserSpecifiedRule() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        DefaultRasterLegendProducerTest.assertNotNull((Object)multipleRulesStyle);
        Rule rule = multipleRulesStyle.getFeatureTypeStyles()[0].getRules()[0];
        LOGGER.info("testing single rule " + rule.getName() + " from style " + multipleRulesStyle.getName());
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(this.getWMS());
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(multipleRulesStyle);
        req.setRule(rule);
        req.setLegendOptions(new HashMap());
        int HEIGHT_HINT = 30;
        req.setHeight(30);
        this.legendProducer.produceLegendGraphic(req);
        BufferedImage legend = this.legendProducer.getLegendGraphic();
        this.assertNotBlank("testUserSpecifiedRule", legend, LegendUtils.DEFAULT_BG_COLOR);
        String errMsg = "expected just one legend of height 30, for the rule " + rule.getName();
        int resultLegendCount = legend.getHeight() / 30;
        DefaultRasterLegendProducerTest.assertEquals((String)errMsg, (int)1, (int)resultLegendCount);
    }

    public void testRainfall() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName("rainfall").getStyle();
        DefaultRasterLegendProducerTest.assertNotNull((Object)multipleRulesStyle);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(this.getWMS());
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        DefaultRasterLegendProducerTest.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        FeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        req.setLayer(feature.getSchema());
        req.setStyle(multipleRulesStyle);
        req.setLegendOptions(new HashMap());
        int HEIGHT_HINT = 30;
        req.setHeight(30);
        this.legendProducer.produceLegendGraphic(req);
        BufferedImage legend = this.legendProducer.getLegendGraphic();
        this.assertNotBlank("testRainfall", legend, LegendUtils.DEFAULT_BG_COLOR);
        this.assertNotBlank("testRainfall", legend, LegendUtils.DEFAULT_BG_COLOR);
    }

    public void testNoLayerProvidedAndNonStrictRequest() throws Exception {
        Style style = this.getCatalog().getStyleByName("rainfall").getStyle();
        DefaultRasterLegendProducerTest.assertNotNull((Object)style);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(this.getWMS());
        req.setStrict(false);
        req.setLayer(null);
        req.setStyle(style);
        int HEIGHT_HINT = 30;
        req.setHeight(30);
        this.legendProducer.produceLegendGraphic(req);
        BufferedImage legend = this.legendProducer.getLegendGraphic();
        this.assertNotBlank("testRainfall", legend, LegendUtils.DEFAULT_BG_COLOR);
        this.assertNotBlank("testRainfall", legend, LegendUtils.DEFAULT_BG_COLOR);
    }
}

