/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.style;

import java.awt.Color;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.UserLayer;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;

public class StyleSnippets {
    public void styleLayerDescriptor() {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        sld.setName("example");
        sld.setAbstract("Example Style Layer Descriptor");
        UserLayer layer = styleFactory.createUserLayer();
        layer.setName("layer");
        FeatureTypeConstraint constraint = styleFactory.createFeatureTypeConstraint("Feature", (Filter)Filter.INCLUDE, null);
        layer.layerFeatureConstraints().add(constraint);
        Style style = styleFactory.createStyle();
        style.getDescription().setTitle("Style");
        style.getDescription().setAbstract("Definition of Style");
        layer.userStyles().add(style);
        sld.layers().add(layer);
    }

    public void externalGraphicStyle() {
        StyleBuilder styleBuilder = new StyleBuilder();
        Style style = styleBuilder.createStyle();
        PointSymbolizer pointSymbolizer = styleBuilder.createPointSymbolizer();
        Graphic graphic = styleBuilder.createGraphic();
        ExternalGraphic external = styleBuilder.createExternalGraphic("file:///C:/images/house.gif", "image/gif");
        graphic.graphicalSymbols().add(external);
        graphic.graphicalSymbols().add(styleBuilder.createMark("circle"));
        pointSymbolizer.setGraphic((org.opengis.style.Graphic)graphic);
        Rule rule = styleBuilder.createRule((Symbolizer)pointSymbolizer);
        FeatureTypeStyle featureTypeStyle = styleBuilder.createFeatureTypeStyle("Feature", rule);
        style.featureTypeStyles().add(featureTypeStyle);
    }

    public void fillFromFeatureAttribute() {
        StyleBuilder styleBuilder = new StyleBuilder();
        Style style = styleBuilder.createStyle();
        String typeName = "pretend";
        String attrName = "PERCENT";
        int[] breaks = new int[]{10, 25, 50, 75, 100};
        Color[] colors = new Color[]{Color.BLUE, Color.GREEN, Color.YELLOW, Color.ORANGE, Color.RED};
        FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Rule[] rules = new Rule[breaks.length];
        for (int i = 0; i < breaks.length; ++i) {
            Fill fill = styleBuilder.createFill(colors[i], 0.5);
            Stroke stroke = styleBuilder.createStroke(colors[i], 1.0);
            PolygonSymbolizer symbolizer = styleBuilder.createPolygonSymbolizer(stroke, fill);
            Rule rule = styleBuilder.createRule((Symbolizer)symbolizer);
            PropertyIsLessThanOrEqualTo filter = ff.lessOrEqual((Expression)ff.property("PERCENT"), (Expression)ff.literal(breaks[i]));
            rule.setFilter((Filter)filter);
            rule.setIsElseFilter(i > 0);
            rules[i] = rule;
        }
        FeatureTypeStyle fts = styleBuilder.createFeatureTypeStyle("pretend", rules);
        style.featureTypeStyles().add(fts);
    }
}

