/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Parameter;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.action.SafeAction;
import org.geotools.swing.data.JParameterListWizard;
import org.geotools.util.KVP;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ChannelSelection;
import org.opengis.style.ContrastMethod;
import org.opengis.style.SelectedChannelType;

public class ImageLab {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private JMapFrame frame;
    private AbstractGridCoverage2DReader reader;

    public static void main(String[] args) throws Exception {
        ImageLab me = new ImageLab();
        me.getLayersAndDisplay();
    }

    private void getLayersAndDisplay() throws Exception {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        list.add(new Parameter("image", File.class, "Image", "GeoTiff or World+Image to display as basemap", (Map)new KVP(new Object[]{"ext", "tif", "ext", "jpg"})));
        list.add(new Parameter("shape", File.class, "Shapefile", "Shapefile contents to display", (Map)new KVP(new Object[]{"ext", "shp"})));
        JParameterListWizard wizard = new JParameterListWizard("Image Lab", "Fill in the following layers", list);
        int finish = wizard.showModalDialog();
        if (finish != 0) {
            System.exit(0);
        }
        File imageFile = (File)wizard.getConnectionParameters().get("image");
        File shapeFile = (File)wizard.getConnectionParameters().get("shape");
        this.displayLayers(imageFile, shapeFile);
    }

    private void displayLayers(File rasterFile, File shpFile) throws Exception {
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)rasterFile);
        this.reader = format.getReader((Object)rasterFile);
        Style rasterStyle = this.createGreyscaleStyle(1);
        FileDataStore dataStore = FileDataStoreFinder.getDataStore((File)shpFile);
        SimpleFeatureSource shapefileSource = dataStore.getFeatureSource();
        Style shpStyle = SLD.createPolygonStyle((Color)Color.YELLOW, null, (float)0.0f);
        DefaultMapContext map = new DefaultMapContext();
        map.setTitle("ImageLab");
        map.addLayer(this.reader, rasterStyle);
        map.addLayer((FeatureSource)shapefileSource, shpStyle);
        this.frame = new JMapFrame((MapContext)map);
        this.frame.setSize(800, 600);
        this.frame.enableStatusBar(true);
        this.frame.enableToolBar(true);
        JMenuBar menuBar = new JMenuBar();
        this.frame.setJMenuBar(menuBar);
        JMenu menu = new JMenu("Raster");
        menuBar.add(menu);
        menu.add((Action)new SafeAction("Grayscale display", (MapContext)map){
            final /* synthetic */ MapContext val$map;
            {
                this.val$map = mapContext;
                super(x0);
            }

            public void action(ActionEvent e) throws Throwable {
                Style style = ImageLab.this.createGreyscaleStyle();
                if (style != null) {
                    this.val$map.getLayer(0).setStyle(style);
                    ImageLab.this.frame.repaint();
                }
            }
        });
        menu.add((Action)new SafeAction("RGB display", (MapContext)map){
            final /* synthetic */ MapContext val$map;
            {
                this.val$map = mapContext;
                super(x0);
            }

            public void action(ActionEvent e) throws Throwable {
                Style style = ImageLab.this.createRGBStyle();
                if (style != null) {
                    this.val$map.getLayer(0).setStyle(style);
                    ImageLab.this.frame.repaint();
                }
            }
        });
        this.frame.setVisible(true);
    }

    private Style createGreyscaleStyle() {
        GridCoverage2D cov = null;
        try {
            cov = this.reader.read(null);
        }
        catch (IOException giveUp) {
            throw new RuntimeException(giveUp);
        }
        int numBands = cov.getNumSampleDimensions();
        Object[] bandNumbers = new Integer[numBands];
        for (int i = 0; i < numBands; ++i) {
            bandNumbers[i] = i + 1;
        }
        Object selection = JOptionPane.showInputDialog((Component)this.frame, "Band to use for greyscale display", "Select an image band", 3, null, bandNumbers, 1);
        if (selection != null) {
            int band = ((Number)selection).intValue();
            return this.createGreyscaleStyle(band);
        }
        return null;
    }

    private Style createGreyscaleStyle(int band) {
        ContrastEnhancement ce = this.sf.contrastEnhancement((Expression)this.ff.literal(1.0), ContrastMethod.NORMALIZE);
        org.geotools.styling.SelectedChannelType sct = this.sf.createSelectedChannelType(String.valueOf(band), ce);
        RasterSymbolizer sym = this.sf.getDefaultRasterSymbolizer();
        org.geotools.styling.ChannelSelection sel = this.sf.channelSelection((SelectedChannelType)sct);
        sym.setChannelSelection((ChannelSelection)sel);
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
    }

    private Style createRGBStyle() {
        GridCoverage2D cov = null;
        try {
            cov = this.reader.read(null);
        }
        catch (IOException giveUp) {
            throw new RuntimeException(giveUp);
        }
        int numBands = cov.getNumSampleDimensions();
        if (numBands < 3) {
            return null;
        }
        String[] sampleDimensionNames = new String[numBands];
        for (int i = 0; i < numBands; ++i) {
            GridSampleDimension dim = cov.getSampleDimension(i);
            sampleDimensionNames[i] = dim.getDescription().toString();
        }
        boolean RED = false;
        boolean GREEN = true;
        int BLUE = 2;
        int[] channelNum = new int[]{-1, -1, -1};
        for (int i = 0; i < numBands; ++i) {
            String name = sampleDimensionNames[i].toLowerCase();
            if (name == null) continue;
            if (name.matches("red.*")) {
                channelNum[0] = i + 1;
                continue;
            }
            if (name.matches("green.*")) {
                channelNum[1] = i + 1;
                continue;
            }
            if (!name.matches("blue.*")) continue;
            channelNum[2] = i + 1;
        }
        if (channelNum[0] < 0 || channelNum[1] < 0 || channelNum[2] < 0) {
            channelNum[0] = 1;
            channelNum[1] = 2;
            channelNum[2] = 3;
        }
        org.geotools.styling.SelectedChannelType[] sct = new org.geotools.styling.SelectedChannelType[cov.getNumSampleDimensions()];
        ContrastEnhancement ce = this.sf.contrastEnhancement((Expression)this.ff.literal(1.0), ContrastMethod.NORMALIZE);
        for (int i = 0; i < 3; ++i) {
            sct[i] = this.sf.createSelectedChannelType(String.valueOf(channelNum[i]), ce);
        }
        RasterSymbolizer sym = this.sf.getDefaultRasterSymbolizer();
        org.geotools.styling.ChannelSelection sel = this.sf.channelSelection((SelectedChannelType)sct[0], (SelectedChannelType)sct[1], (SelectedChannelType)sct[2]);
        sym.setChannelSelection((ChannelSelection)sel);
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
    }
}

