/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.example;

import com.vividsolutions.jts.geom.Envelope;
import java.util.HashMap;
import java.util.logging.Level;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.swing.JMapFrame;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SLDExample {
    public static void main(String[] args) {
        try {
            SLDExample.localSLD();
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public static void supressInfo() {
        Logging.getLogger((String)"org.geotools.gml").setLevel(Level.SEVERE);
        Logging.getLogger((String)"net.refractions.xml").setLevel(Level.SEVERE);
    }

    public static void localSLD() throws Exception {
        SimpleFeatureSource source = SLDExample.demoFeatureSource();
        Style style = SLDExample.demoStyle(((SimpleFeatureType)source.getSchema()).getTypeName());
        SLDExample.show(source, style);
    }

    static SimpleFeatureSource demoFeatureSource() throws Exception {
        String getCapabilities = "http://localhost:8080/geoserver/wfs?service=WFS&request=GetCapabilities";
        HashMap<String, String> connectionParameters = new HashMap<String, String>();
        connectionParameters.put("WFSDataStoreFactory:GET_CAPABILITIES_URL", getCapabilities);
        DataStore data = DataStoreFinder.getDataStore(connectionParameters);
        String typeName = data.getTypeNames()[0];
        return data.getFeatureSource(typeName);
    }

    static Style demoStyle(String typeName) throws Exception {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        Stroke stroke = sf.createStroke((Expression)ff.literal((Object)"#FF0000"), (Expression)ff.literal(2));
        LineSymbolizer lineSymbolizer = sf.createLineSymbolizer();
        lineSymbolizer.setStroke((org.opengis.style.Stroke)stroke);
        Rule rule = sf.createRule();
        rule.setFilter((Filter)Filter.INCLUDE);
        rule.setSymbolizers(new Symbolizer[]{lineSymbolizer});
        FeatureTypeStyle type = sf.createFeatureTypeStyle();
        type.setFeatureTypeName(typeName);
        type.addRule(rule);
        Style style = sf.createStyle();
        style.addFeatureTypeStyle(type);
        return style;
    }

    public static void show(SimpleFeatureSource source, Style style) throws Exception {
        DefaultMapContext context = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        context.setAreaOfInterest((Envelope)source.getBounds(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        context.addLayer((FeatureSource)source, style);
        context.setTitle("FOSS4G");
        StreamingRenderer renderer = new StreamingRenderer();
        HashMap<String, Boolean> hints = new HashMap<String, Boolean>();
        hints.put("memoryPreloadingEnabled", Boolean.TRUE);
        renderer.setRendererHints(hints);
        JMapFrame frame = new JMapFrame((MapContext)context, (GTRenderer)renderer);
        frame.enableToolBar(true);
        frame.setVisible(true);
    }
}

