/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.example;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Polygon;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.Intersects;

public class WFSExample {
    public static void main(String[] args) {
        String getCapabilities = "http://localhost:8080/geoserver/wfs?service=WFS&request=GetCapabilities";
        if (args.length != 0) {
            getCapabilities = args[0];
        }
        try {
            WFSExample.supressInfo();
            WFSExample.dataAccess(getCapabilities);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void supressInfo() {
        Logging.getLogger((String)"org.geotools.gml").setLevel(Level.SEVERE);
        Logging.getLogger((String)"net.refractions.xml").setLevel(Level.SEVERE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dataAccess(String getCapabilities) throws Exception {
        HashMap<String, String> connectionParameters = new HashMap<String, String>();
        connectionParameters.put("WFSDataStoreFactory:GET_CAPABILITIES_URL", getCapabilities);
        DataStore data = DataStoreFinder.getDataStore(connectionParameters);
        String[] typeNames = data.getTypeNames();
        String typeName = typeNames[0];
        SimpleFeatureType schema = data.getSchema(typeName);
        System.out.println("Schema Attributes:" + schema.getAttributeCount());
        SimpleFeatureSource source = data.getFeatureSource(typeName);
        System.out.println("Metadata Bounds:" + source.getBounds());
        String geomName = schema.getGeometryDescriptor().getLocalName();
        Envelope bbox = new Envelope(-100.0, -70.0, 25.0, 40.0);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        Polygon polygon = JTS.toGeometry((Envelope)bbox);
        Intersects filter = ff.intersects((Expression)ff.property(geomName), (Expression)ff.literal((Object)polygon));
        DefaultQuery query = new DefaultQuery(typeName, (Filter)filter, new String[]{geomName});
        SimpleFeatureCollection features = source.getFeatures((Query)query);
        ReferencedEnvelope bounds = new ReferencedEnvelope();
        Iterator iterator = features.iterator();
        try {
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                bounds.include(feature.getBounds());
            }
            System.out.println("Calculated Bounds:" + bounds);
        }
        finally {
            features.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dataUpdate(String getCapabilities) throws Exception {
        HashMap<String, String> connectionParameters = new HashMap<String, String>();
        connectionParameters.put("WFSDataStoreFactory:GET_CAPABILITIES_URL", getCapabilities);
        DataStore data = DataStoreFinder.getDataStore(connectionParameters);
        String[] typeNames = data.getTypeNames();
        String typeName = typeNames[0];
        SimpleFeatureType schema = data.getSchema(typeName);
        System.out.println("Schema Attributes:" + schema.getAttributeCount());
        SimpleFeatureSource source = data.getFeatureSource(typeName);
        System.out.println("Metadata Bounds:" + source.getBounds());
        FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        DefaultQuery query = new DefaultQuery(typeName, (Filter)Filter.INCLUDE);
        query.setMaxFeatures(2);
        SimpleFeatureCollection features = source.getFeatures((Query)query);
        String fid = null;
        Iterator iterator = features.iterator();
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                fid = feature.getID();
            }
        }
        finally {
            features.close(iterator);
        }
        DefaultTransaction t = new DefaultTransaction();
        SimpleFeatureStore store = (SimpleFeatureStore)source;
        store.setTransaction((Transaction)t);
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(ff.featureId(fid));
        Id filter = ff.id(ids);
        try {
            store.removeFeatures((Filter)filter);
        }
        finally {
            t.rollback();
        }
    }
}

