/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.filter.function;

import java.awt.Color;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FunctionExpressionImpl;
import org.opengis.filter.FilterFactory;

public class ColorRampFunction
extends FunctionExpressionImpl {
    private static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    public ColorRampFunction() {
        super("colorramp");
    }

    public Object evaluate(Object feature) {
        float attributeValue = ((Float)this.getExpression(0).evaluate(feature, Float.class)).floatValue();
        float minValue = ((Float)this.getExpression(1).evaluate(feature, Float.class)).floatValue();
        float maxValue = ((Float)this.getExpression(2).evaluate(feature, Float.class)).floatValue();
        float saturation = ((Float)this.getExpression(3).evaluate(feature, Float.class)).floatValue();
        float brightness = ((Float)this.getExpression(3).evaluate(feature, Float.class)).floatValue();
        return this.valueToColor(attributeValue, minValue, maxValue, saturation, brightness);
    }

    private Color valueToColor(float value, float minValue, float maxValue, float saturation, float brightness) {
        float hue = (value - minValue) / (maxValue - minValue);
        if (hue < 0.0f || hue > 1.0f) {
            return null;
        }
        int rgb = Color.HSBtoRGB(this.adjustHue(hue), saturation, brightness);
        return new Color(rgb);
    }

    private float adjustHue(float hue) {
        return hue * 0.75f + 0.125f;
    }

    public int getArgCount() {
        return 5;
    }
}

