/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.grid;

import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.GridElement;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.Grids;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.styling.Fill;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.swing.JMapFrame;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class HexagonExample {
    public static void main(String[] args) {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("hextype");
        typeBuilder.add("hexagon", Polygon.class, (CoordinateReferenceSystem)null);
        typeBuilder.add("color", Color.class);
        SimpleFeatureType TYPE = typeBuilder.buildFeatureType();
        final ReferencedEnvelope bounds = new ReferencedEnvelope(0.0, 100.0, 0.0, 100.0, null);
        GridFeatureBuilder builder = new GridFeatureBuilder(TYPE){

            public void setAttributes(GridElement el, Map<String, Object> attributes) {
                int g = (int)(255.0 * el.getCenter().x / bounds.getWidth());
                int b = (int)(255.0 * el.getCenter().y / bounds.getHeight());
                attributes.put("color", new Color(0, g, b));
            }
        };
        double sideLen = 5.0;
        SimpleFeatureSource grid = Grids.createHexagonalGrid((ReferencedEnvelope)bounds, (double)sideLen, (double)-1.0, (GridFeatureBuilder)builder);
        DefaultMapContext map = new DefaultMapContext();
        map.addLayer((FeatureSource)grid, HexagonExample.createStyle("color"));
        JMapFrame.showMap((MapContext)map);
    }

    private static Style createStyle(String propName) {
        FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2(null);
        StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
        Stroke stroke = sf.createStroke((Expression)ff2.literal((Object)Color.BLACK), (Expression)ff2.literal(1.0));
        Fill fill = sf.createFill((Expression)ff2.property(propName));
        PolygonSymbolizer sym = sf.createPolygonSymbolizer(stroke, fill, null);
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
    }
}

