/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.opengis.feature.type.Name;

public class AppSchemaFileDataTest
extends TestCase {
    private static final String testData = "/test-data/";
    private static final File testDir = new File("target/test/" + AppSchemaFileDataTest.class.getSimpleName());

    public void setUp() throws IOException {
        FileUtils.deleteDirectory((File)testDir);
        AppSchemaFileDataTest.copyTestData("ArchSite.xsd", testDir);
        AppSchemaFileDataTest.copyTestData("ArchSiteNillable.xml", testDir);
        AppSchemaFileDataTest.copyTestData("AppSchemaFileDataTest.xml", testDir);
        AppSchemaFileDataTest.copyTestData("PointFeatureGeomPropertyfile.properties", new File(testDir, "directory"));
        AppSchemaDataAccessRegistry.unregisterAll();
    }

    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)testDir);
        AppSchemaDataAccessRegistry.unregisterAll();
    }

    private static void copyTestData(String baseFileName, File destDir) throws IOException {
        destDir.mkdirs();
        FileUtils.copyFileToDirectory((File)DataUtilities.urlToFile((URL)AppSchemaFileDataTest.class.getResource(testData + baseFileName)), (File)destDir);
    }

    private static String getTestDirPath(String baseFileName) {
        return new File(testDir, baseFileName).getPath();
    }

    public void testShapeMappings() throws Exception {
        String mappingFileNameRelativeShape = "ArchSiteNillable.xml";
        AppSchemaDataAccess dSRelative = null;
        try {
            dSRelative = this.buildDataAccess(mappingFileNameRelativeShape);
            AppSchemaFileDataTest.assertEquals((int)1, (int)dSRelative.getNames().size());
            AppSchemaFileDataTest.assertEquals((int)25, (int)this.countFeatures(dSRelative));
        }
        finally {
            if (dSRelative != null) {
                dSRelative.dispose();
            }
        }
    }

    public void testShapeMappingsAbsolute() throws Exception {
        String mappingFileNameRelativeShape = "ArchSiteNillable.xml";
        String configFilePathRelativeShape = AppSchemaFileDataTest.getTestDirPath(mappingFileNameRelativeShape);
        String mappingFileNameAbsoluteShape = "ArchSiteAbsolute.xml";
        String configFilePathAbsoluteShape = AppSchemaFileDataTest.getTestDirPath(mappingFileNameAbsoluteShape);
        AppSchemaDataAccess dSAbsolute = null;
        try {
            this.copyRelativeToAbsolute(configFilePathRelativeShape, configFilePathAbsoluteShape);
            dSAbsolute = this.buildDataAccess(mappingFileNameAbsoluteShape);
            AppSchemaFileDataTest.assertEquals((int)1, (int)dSAbsolute.getNames().size());
            AppSchemaFileDataTest.assertEquals((int)25, (int)this.countFeatures(dSAbsolute));
        }
        finally {
            if (dSAbsolute != null) {
                dSAbsolute.dispose();
            }
        }
    }

    public void testPropertiesMappings() throws Exception {
        String mappingFileNameRelativeProperties = "AppSchemaFileDataTest.xml";
        AppSchemaDataAccess dSRelative = null;
        try {
            dSRelative = this.buildDataAccess(mappingFileNameRelativeProperties);
            AppSchemaFileDataTest.assertEquals((int)1, (int)dSRelative.getNames().size());
            AppSchemaFileDataTest.assertEquals((int)2, (int)this.countFeatures(dSRelative));
        }
        finally {
            if (dSRelative != null) {
                dSRelative.dispose();
            }
        }
    }

    public void testPropertiesMappingsAbsolute() throws Exception {
        String mappingFileNameRelativeProperties = "AppSchemaFileDataTest.xml";
        String configFilePathRelativeProperties = AppSchemaFileDataTest.getTestDirPath(mappingFileNameRelativeProperties);
        String mappingFileNameAbsoluteProperties = "AppSchemaFileDataTestAbsolute.xml";
        String configFilePathAbsoluteProperties = AppSchemaFileDataTest.getTestDirPath(mappingFileNameAbsoluteProperties);
        AppSchemaDataAccess dSAbsolute = null;
        try {
            this.copyRelativeToAbsolute(configFilePathRelativeProperties, configFilePathAbsoluteProperties);
            dSAbsolute = this.buildDataAccess(mappingFileNameAbsoluteProperties);
            AppSchemaFileDataTest.assertEquals((int)1, (int)dSAbsolute.getNames().size());
            AppSchemaFileDataTest.assertEquals((int)2, (int)this.countFeatures(dSAbsolute));
        }
        finally {
            if (dSAbsolute != null) {
                dSAbsolute.dispose();
            }
        }
    }

    private int countFeatures(AppSchemaDataAccess dS) throws Exception {
        Name[] dSNameArray = dS.getTypeNames();
        String testType = dSNameArray[0].toString();
        FeatureSource featureSource = dS.getFeatureSourceByName(dSNameArray[0]);
        int numFeatures = featureSource.getCount(new Query(testType));
        return numFeatures;
    }

    private AppSchemaDataAccess buildDataAccess(String mappingsFileName) throws Exception {
        String configFilePath = this.extendFilename(testDir.getPath(), mappingsFileName);
        URL configFileUrl = DataUtilities.fileToURL((File)new File(configFilePath));
        XMLConfigDigester configReader = new XMLConfigDigester();
        AppSchemaDataAccessDTO config = configReader.parse(configFileUrl);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        AppSchemaDataAccess datastore = new AppSchemaDataAccess(mappings);
        return datastore;
    }

    private String copyRelativeToAbsolute(String filePathIn, String filePathOut) throws Exception {
        BufferedReader reader = null;
        PrintWriter writer = null;
        String absolutePath = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(filePathIn));
            writer = new PrintWriter(new FileWriter(filePathOut));
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("<value>file:")) {
                    String relativePath = line.split("<value>file:|</value>")[1];
                    String resolvedPath = this.extendFilename(testDir.getPath(), relativePath);
                    absolutePath = new File(resolvedPath).getAbsolutePath();
                    line = line.replace(relativePath, absolutePath);
                }
                if (line.trim().startsWith("<OCQL>")) {
                    line = line.replace("if_then_else(equalTo(CAT_DESC, 'No Name'), Expression.Nil , CAT_DESC)", "CAT_DESC");
                }
                writer.println(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        return absolutePath;
    }

    private String extendFilename(String baseFilename, String relativePath) throws RuntimeException {
        String extendedFilename = FilenameUtils.concat((String)(baseFilename = new File(baseFilename).getAbsolutePath()), (String)relativePath);
        if (extendedFilename == null) {
            throw new RuntimeException("Relative path to datastore is incompatible with the base path - check double dot steps.");
        }
        return extendedFilename;
    }
}

