/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.geotools.data.DataAccess;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAccessRegistry
extends ArrayList<DataAccess<FeatureType, Feature>> {
    private static final long serialVersionUID = 1999179819283985526L;
    protected static DataAccessRegistry registry = null;

    protected DataAccessRegistry() {
    }

    private static DataAccessRegistry newInstance() {
        return new DataAccessRegistry();
    }

    public static synchronized void register(DataAccess<FeatureType, Feature> dataAccess) {
        if (registry == null) {
            registry = DataAccessRegistry.newInstance();
        }
        registry.add(dataAccess);
    }

    public static synchronized void unregister(DataAccess<FeatureType, Feature> dataAccess) {
        if (registry == null) {
            throw new NullPointerException("This data access was never registered in DataAccessRegistry!: " + dataAccess.getClass());
        }
        registry.remove(dataAccess);
    }

    public static synchronized void unregisterAll() {
        if (registry != null) {
            registry.clear();
        }
    }

    public static boolean hasName(Name featureTypeName) throws IOException {
        if (registry == null) {
            return false;
        }
        for (DataAccess dataAccess : registry) {
            if (!dataAccess.getNames().contains(featureTypeName)) continue;
            return true;
        }
        return false;
    }

    public static FeatureSource<FeatureType, Feature> getFeatureSource(Name featureTypeName) throws IOException {
        if (registry == null) {
            throw new UnsupportedOperationException("This method is only for registered data access. You need to register the data access that has mapping for: " + featureTypeName.toString());
        }
        for (DataAccess dataAccess : registry) {
            if (!dataAccess.getNames().contains(featureTypeName)) continue;
            if (dataAccess instanceof AppSchemaDataAccess) {
                return ((AppSchemaDataAccess)dataAccess).getFeatureSourceByName(featureTypeName);
            }
            return dataAccess.getFeatureSource(featureTypeName);
        }
        DataAccessRegistry.throwDataSourceException(featureTypeName);
        return null;
    }

    public static DataAccess<FeatureType, Feature> getDataAccess(Name featureTypeName) throws IOException {
        return DataAccessRegistry.getFeatureSource(featureTypeName).getDataStore();
    }

    protected static void throwDataSourceException(Name featureTypeName) throws IOException {
        ArrayList typeNames = new ArrayList();
        Iterator dataAccessIterator = registry.iterator();
        while (dataAccessIterator.hasNext()) {
            typeNames.addAll(((DataAccess)dataAccessIterator.next()).getNames());
        }
        throw new DataSourceException("Feature type " + featureTypeName + " not found." + " Has the data access been registered in DataAccessRegistry?" + " Available: " + ((Object)typeNames).toString());
    }
}

