/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AttributeCreateOrderList;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.PathAttributeList;
import org.geotools.data.complex.TreeAttributeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.filter.LiteralExpressionImpl;
import org.opengis.feature.Attribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlFeatureTypeMapping
extends FeatureTypeMapping {
    private static final String XPATH_SEPARATOR = "/";
    private static final String XPATH_PROPERTY_SEPARATOR = "/@";
    private static final String XPATH_LEFT_INDEX_BRACKET = "[";
    private static final String XPATH_RIGHT_INDEX_BRACKET = "]";
    private Map<String, String> mapping = new HashMap<String, String>();
    private AttributeCreateOrderList attOrderedTypeList = null;
    private Map<String, TreeAttributeMapping> indexAttributeList;
    private TreeAttributeMapping rootAttribute;
    private int index = 1;
    private List<TreeAttributeMapping> setterAttributes = new ArrayList<TreeAttributeMapping>();

    public XmlFeatureTypeMapping() {
        super(null, null, new LinkedList<AttributeMapping>(), new NamespaceSupport());
    }

    public XmlFeatureTypeMapping(FeatureSource source, AttributeDescriptor target, List<AttributeMapping> mappings, NamespaceSupport namespaces) {
        this(source, target, mappings, namespaces, (String)null);
    }

    public XmlFeatureTypeMapping(FeatureSource source, AttributeDescriptor target, List<AttributeMapping> mappings, NamespaceSupport namespaces, String itemXpath) {
        super(source, target, mappings, namespaces, itemXpath);
        try {
            this.populateFeatureData();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error occured when trying to create attribute mappings", ex);
        }
    }

    public List<String> getStringMappingsIgnoreIndex(XPath.StepList targetPath) {
        ArrayList<String> mappings = new ArrayList<String>();
        String path = targetPath.toString();
        Set<String> c = this.mapping.keySet();
        for (String listPath : c) {
            String unindexedListPath = this.removeIndexFromPath(listPath);
            if (!path.equals(unindexedListPath)) continue;
            mappings.add(this.mapping.get(listPath));
        }
        if (mappings.isEmpty()) {
            for (TreeAttributeMapping att : this.setterAttributes) {
                String listPath = att.getTargetXPath().toString();
                String unindexedListPath = this.removeIndexFromPath(listPath);
                if (!path.equals(unindexedListPath)) continue;
                mappings.add(att.getSourceExpression().toString());
            }
        }
        return mappings;
    }

    private String removeIndexFromPath(String inputPath) {
        String tempPath = inputPath;
        while (tempPath.contains(XPATH_LEFT_INDEX_BRACKET)) {
            int leftIndex = tempPath.indexOf(XPATH_LEFT_INDEX_BRACKET);
            int rightIndex = tempPath.indexOf(XPATH_RIGHT_INDEX_BRACKET, leftIndex);
            String leftTempPath = tempPath.substring(0, leftIndex);
            String rightTempPath = tempPath.substring(rightIndex + 1);
            tempPath = leftTempPath + rightTempPath;
        }
        return tempPath;
    }

    @Override
    public List<AttributeMapping> getAttributeMappingsByExpression(Expression sourceExpression) {
        List<AttributeMapping> mappings = Collections.emptyList();
        for (AttributeMapping attMapping : this.attributeMappings) {
            if (!sourceExpression.equals(attMapping.getSourceExpression())) continue;
            if (mappings.size() == 0) {
                mappings = new ArrayList<AttributeMapping>(2);
            }
            mappings.add(attMapping);
        }
        return mappings;
    }

    public String getStringMapping(XPath.StepList exactPath) {
        for (AttributeMapping attMapping : this.attributeMappings) {
            if (!exactPath.equals((Object)attMapping.getTargetXPath())) continue;
            return "";
        }
        return null;
    }

    public void populateFeatureData() throws IOException {
        List<AttributeMapping> attMap = this.getAttributeMappings();
        if (this.attOrderedTypeList == null) {
            this.initialiseAttributeLists(attMap);
        }
        PathAttributeList elements = new PathAttributeList();
        elements.put(this.rootAttribute.getLabel(), this.itemXpath, null);
        String id = this.rootAttribute.getInstanceXpath() + XPATH_SEPARATOR + this.rootAttribute.getIdentifierExpression();
        this.mapping.put("@gml:id", id);
        this.mapping.put("@gsml:id", id);
        Iterator<TreeAttributeMapping> it = this.attOrderedTypeList.iterator();
        this.addComplexAttributes(elements, it);
        this.addSetterAttributes(elements);
        ++this.index;
        this.removeAllRelativePaths();
    }

    private void addComplexAttributes(PathAttributeList elements, Iterator<TreeAttributeMapping> it) {
        while (it.hasNext()) {
            TreeAttributeMapping attMapping = it.next();
            Expression sourceExpression = attMapping.getIdentifierExpression();
            List<PathAttributeList.Pair> ls = elements.get(attMapping.getParentLabel());
            if (ls == null) continue;
            for (int i = 0; i < ls.size(); ++i) {
                PathAttributeList.Pair parentAttribute = ls.get(i);
                String instancePath = attMapping.getInstanceXpath();
                int count = 1;
                String countXpath = null;
                if (instancePath != null) {
                    countXpath = parentAttribute.getXpath() + XPATH_SEPARATOR + attMapping.getInstanceXpath();
                }
                for (int j = 0; j < count; ++j) {
                    String bracketIndex = "";
                    String xpath = null;
                    xpath = instancePath == null ? parentAttribute.getXpath() + XPATH_SEPARATOR + sourceExpression.toString() : parentAttribute.getXpath() + XPATH_SEPARATOR + attMapping.getInstanceXpath() + "" + XPATH_SEPARATOR + sourceExpression.toString();
                    String label = this.getFullQueryPath(attMapping, attMapping.getTargetQueryString());
                    String idSuffix = "/@gml:id";
                    this.mapping.put(label + idSuffix, xpath);
                    XPath.StepList sl = attMapping.getTargetXPath();
                    this.setPathIndex(j, sl);
                    Attribute subFeature = null;
                    elements.put(attMapping.getLabel(), countXpath + "", subFeature);
                }
            }
        }
    }

    private void addSetterAttributes(PathAttributeList elements) {
        for (TreeAttributeMapping attMapping : this.setterAttributes) {
            List<PathAttributeList.Pair> ls = elements.get(attMapping.getParentLabel());
            if (ls == null) continue;
            for (int i = 0; i < ls.size(); ++i) {
                String label;
                PathAttributeList.Pair parentPair = ls.get(i);
                Expression sourceExpression = attMapping.getSourceExpression();
                StringBuffer usedXpath = (StringBuffer)this.getValue(parentPair.getXpath(), sourceExpression);
                if (usedXpath != null) {
                    label = this.getFullQueryPath(attMapping, attMapping.getTargetXPath().toString());
                    this.mapping.put(label, usedXpath.toString());
                    this.addClientProperties(attMapping, usedXpath, label);
                    continue;
                }
                usedXpath = new StringBuffer(parentPair.getXpath());
                label = this.getFullQueryPath(attMapping, attMapping.getTargetXPath().toString());
                this.addClientProperties(attMapping, usedXpath, label);
            }
        }
    }

    private void addClientProperties(TreeAttributeMapping attMapping, StringBuffer usedXpath, String label) {
        Map<Name, Expression> clientProperties = attMapping.getClientProperties();
        if (clientProperties.size() != 0) {
            for (Map.Entry<Name, Expression> entry : clientProperties.entrySet()) {
                Name propName = entry.getKey();
                Expression propExpr = entry.getValue();
                Object xPath = this.getValue(usedXpath.toString(), propExpr);
                if (xPath == null) continue;
                this.mapping.put(label + XPATH_PROPERTY_SEPARATOR + this.getPropertyNameXpath(propName), xPath.toString());
            }
        }
    }

    private String getPropertyNameXpath(Name propName) {
        String xpath;
        String namespaceUri = propName.getNamespaceURI();
        if (namespaceUri != null) {
            String namespace = this.namespaces.getPrefix(namespaceUri);
            xpath = namespace + propName.getSeparator() + propName.getLocalPart();
        } else {
            xpath = propName.getLocalPart();
        }
        return xpath;
    }

    private void setPathIndex(int j, XPath.StepList sl) {
        if (j > 0) {
            XPath.Step st = (XPath.Step)sl.get(sl.size() - 1);
            XPath.Step st2 = new XPath.Step(st.getName(), j + 1, st.isXmlAttribute());
            sl.remove(sl.size() - 1);
            sl.add(st2);
        }
    }

    protected Object getValue(String xpathPrefix, Expression node) {
        StringBuffer usedXpath = new StringBuffer();
        String expressionValue = node.toString();
        if (expressionValue.startsWith("'") || node instanceof LiteralExpressionImpl) {
            usedXpath.append(xpathPrefix);
            return null;
        }
        expressionValue = xpathPrefix + XPATH_SEPARATOR + expressionValue;
        usedXpath.append(expressionValue);
        return usedXpath;
    }

    private void initialiseAttributeLists(List<AttributeMapping> mappings) {
        TreeAttributeMapping treeAttMapping;
        for (AttributeMapping attMapping : mappings) {
            if (!attMapping.isTreeAttribute() || (treeAttMapping = (TreeAttributeMapping)attMapping).getLabel() == null || treeAttMapping.getParentLabel() != null || attMapping.getTargetNodeInstance() != null) continue;
            this.rootAttribute = treeAttMapping;
            break;
        }
        this.attOrderedTypeList = new AttributeCreateOrderList(this.rootAttribute.getLabel());
        this.indexAttributeList = new HashMap<String, TreeAttributeMapping>();
        this.indexAttributeList.put(this.rootAttribute.getLabel(), this.rootAttribute);
        for (AttributeMapping attMapping : mappings) {
            if (!attMapping.isTreeAttribute()) continue;
            treeAttMapping = (TreeAttributeMapping)attMapping;
            if (treeAttMapping.getLabel() == null) {
                this.setterAttributes.add(treeAttMapping);
                continue;
            }
            if (treeAttMapping.getParentLabel() == null) continue;
            this.attOrderedTypeList.put(treeAttMapping);
            this.indexAttributeList.put(treeAttMapping.getLabel(), treeAttMapping);
        }
    }

    protected void setClientProperties(Attribute target, Object source, Map<Name, Expression> clientProperties) {
        if (clientProperties.size() == 0) {
            return;
        }
        HashMap<Name, String> targetAttributes = new HashMap<Name, String>();
        for (Map.Entry<Name, Expression> entry : clientProperties.entrySet()) {
            Name propName = entry.getKey();
            Expression propExpr = entry.getValue();
            String propValue = null;
            if (propValue != null) {
                List ls = (List)((Object)propValue);
                propValue = ls.size() != 0 ? ls.get(0) : "";
            }
            targetAttributes.put(propName, propValue);
        }
    }

    private String getFullQueryPath(TreeAttributeMapping attMapping, String initialString) {
        StringBuffer name = new StringBuffer(initialString);
        TreeAttributeMapping tam = attMapping;
        while (tam.getParentLabel() != null) {
            if (this.rootAttribute.equals(tam = this.indexAttributeList.get(tam.getParentLabel()))) continue;
            name.insert(0, tam.getTargetQueryString() + XPATH_SEPARATOR);
        }
        return name.toString();
    }

    private void removeAllRelativePaths() {
        Set<String> c = this.mapping.keySet();
        for (String key : c) {
            String xPath2;
            String xPath = this.mapping.get(key);
            if (xPath.equals(xPath2 = this.removeRelativePaths(xPath))) continue;
            this.mapping.put(key, xPath2);
        }
    }

    private String removeRelativePaths(String xPath) {
        int slashPos;
        String xPathTemp = xPath;
        int NOT_FOUND = -1;
        String RELATIVE_PATH = "/../";
        int i = xPathTemp.indexOf("/../");
        while (i != -1 && (slashPos = xPathTemp.lastIndexOf(XPATH_SEPARATOR, i - 1)) != -1) {
            String left = xPathTemp.substring(0, slashPos + 1);
            String right = xPathTemp.substring(i + "/../".length());
            xPathTemp = left + right;
            i = xPathTemp.indexOf("/../");
        }
        return xPathTemp;
    }
}

