/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Collection;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexAttributeConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (ComplexAttribute.class.isAssignableFrom(source)) {
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    while (source instanceof ComplexAttribute) {
                        if (!((ComplexAttribute)source).getType().getDescriptors().isEmpty()) {
                            return null;
                        }
                        Collection valueMap = ((ComplexAttribute)source).getValue();
                        if (valueMap.isEmpty()) {
                            return null;
                        }
                        source = valueMap.iterator().next();
                    }
                    if (source instanceof Attribute) {
                        return ((Attribute)source).getValue();
                    }
                    return null;
                }
            };
        }
        if (Attribute.class.isAssignableFrom(source)) {
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    return ((Attribute)source).getValue();
                }
            };
        }
        return null;
    }
}

