/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureChainingTest;
import org.geotools.data.complex.config.CatalogUtilities;
import org.geotools.data.complex.config.EmfAppSchemaReader;
import org.geotools.data.complex.config.FeatureTypeRegistry;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.Types;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.ComplexFeatureTypeImpl;
import org.geotools.feature.type.FeatureTypeImpl;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.GMLSchema;
import org.geotools.xml.SchemaIndex;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAccessIntegrationTest {
    protected static final String GSMLNS = "http://www.cgi-iugs.org/xml/GeoSciML/2";
    protected static final String GMLNS = "http://www.opengis.net/gml";
    protected static final Name MAPPED_FEATURE = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"MappedFeature");
    private static final Name GEOLOGIC_UNIT_TYPE = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"GeologicUnitType");
    protected static final Name GEOLOGIC_UNIT = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"GeologicUnit");
    private static final Name COMPOSITION_PART_TYPE = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"CompositionPartType");
    private static final Name COMPOSITION_PART = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"CompositionPart");
    protected static final String schemaBase = "/test-data/";
    protected static EmfAppSchemaReader reader;
    protected static FeatureTypeRegistry typeRegistry;
    protected static DataAccess<FeatureType, Feature> mfDataAccess;
    protected static FeatureSource<FeatureType, Feature> guFeatureSource;
    protected static ArrayList<Feature> inputFeatures;
    protected static ArrayList<Feature> cpFeatures;
    protected static ArrayList<Feature> mfFeatures;
    protected static FilterFactory ff;

    @BeforeClass
    public static void setUp() throws Exception {
        DataAccessIntegrationTest.setFilterFactory();
        DataAccessIntegrationTest.loadGeologicUnitDataAccess();
        DataAccessIntegrationTest.loadDataAccesses("MappedFeaturePropertyfile.xml");
    }

    private static ArrayList<Feature> getInputFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> fCollection, FeatureType geologicUnitType) throws IOException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        AttributeDescriptorImpl featureDesc = new AttributeDescriptorImpl((AttributeType)geologicUnitType, GEOLOGIC_UNIT, 0, -1, false, null);
        AttributeDescriptor descriptionDescriptor = (AttributeDescriptor)geologicUnitType.getDescriptor(Types.typeName((String)GMLNS, (String)"description"));
        AttributeDescriptor nameDescriptor = (AttributeDescriptor)GMLSchema.ABSTRACTGMLTYPE_TYPE.getDescriptor(Types.typeName((String)GMLNS, (String)"name"));
        NameImpl name = new NameImpl(null, "simpleContent");
        AttributeType simpleContentType = typeRegistry.getAttributeType(Types.typeName((String)"http://www.w3.org/2001/XMLSchema", (String)"string"));
        AttributeDescriptorImpl stringDescriptor = new AttributeDescriptorImpl(simpleContentType, (Name)name, 1, 1, true, (Object)null);
        Iterator simpleFeatures = fCollection.iterator();
        while (simpleFeatures.hasNext()) {
            SimpleFeature next = (SimpleFeature)simpleFeatures.next();
            ArrayList<Object> properties = new ArrayList<Object>();
            String propertyName = "TEXTDESCRIPTION";
            ArrayList<Object> value = new ArrayList<Object>();
            value.add(new AttributeImpl(next.getProperty(propertyName).getValue(), (AttributeDescriptor)stringDescriptor, null));
            properties.add(new ComplexAttributeImpl(value, descriptionDescriptor, null));
            propertyName = "NAME";
            value = new ArrayList();
            value.add(new AttributeImpl(next.getProperty(propertyName).getValue(), (AttributeDescriptor)stringDescriptor, null));
            ComplexAttributeImpl name1 = new ComplexAttributeImpl(value, nameDescriptor, null);
            properties.add(name1);
            value = new ArrayList();
            propertyName = "ABBREVIATION";
            value.add(new AttributeImpl(next.getProperty(propertyName).getValue(), (AttributeDescriptor)stringDescriptor, null));
            properties.add(new ComplexAttributeImpl(value, nameDescriptor, null));
            ComplexType cpType = (ComplexType)typeRegistry.getAttributeType(COMPOSITION_PART_TYPE);
            ArrayList<ComplexAttributeImpl> compositionParts = new ArrayList<ComplexAttributeImpl>();
            compositionParts.add(name1);
            value = new ArrayList();
            value.add(new ComplexAttributeImpl(compositionParts, cpType, null));
            properties.add(new ComplexAttributeImpl(value, (AttributeDescriptor)geologicUnitType.getDescriptor(Types.typeName((String)GSMLNS, (String)"composition")), null));
            properties.add(new AttributeImpl((Object)next.getID(), (AttributeDescriptor)ComplexFeatureTypeImpl.FEATURE_CHAINING_LINK, null));
            features.add((Feature)new FeatureImpl(properties, (AttributeDescriptor)featureDesc, next.getIdentifier()));
        }
        fCollection.close(simpleFeatures);
        return features;
    }

    @Test
    public void testMappings() throws IOException {
        Feature guFeature;
        Iterator<Feature> mfIterator = mfFeatures.iterator();
        Iterator<Feature> guIterator = inputFeatures.iterator();
        HashMap<String, Feature> guMap = new HashMap<String, Feature>();
        while (guIterator.hasNext()) {
            guFeature = guIterator.next();
            String guId = guFeature.getIdentifier().getID();
            if (guMap.containsKey(guId)) continue;
            guMap.put(guId, guFeature);
        }
        String NESTED_LINK = "specification";
        while (mfIterator.hasNext()) {
            Feature mfFeature = mfIterator.next();
            String mfId = mfFeature.getIdentifier().toString();
            String[] guIds = FeatureChainingTest.mfToGuMap.get(mfId).split(";");
            Collection nestedGuFeatures = mfFeature.getProperties("specification");
            Assert.assertEquals((long)guIds.length, (long)nestedGuFeatures.size());
            ArrayList<String> nestedGuIds = new ArrayList<String>();
            for (Property property : nestedGuFeatures) {
                Object value = property.getValue();
                Assert.assertNotNull((Object)value);
                Assert.assertEquals((Object)(value instanceof Collection), (Object)true);
                Assert.assertEquals((long)((Collection)value).size(), (long)1L);
                Feature nestedGuFeature = (Feature)((Collection)value).iterator().next();
                String guId = nestedGuFeature.getIdentifier().toString();
                Assert.assertEquals((Object)true, (Object)guMap.containsKey(guId));
                nestedGuIds.add(guId);
                guFeature = (Feature)guMap.get(guId.toString());
                Collection guProperties = guFeature.getProperties();
                Assert.assertEquals((Object)guProperties, (Object)nestedGuFeature.getProperties());
            }
            Assert.assertEquals((Object)nestedGuIds.containsAll(Arrays.asList(guIds)), (Object)true);
        }
    }

    @Test
    public void testFilters() throws IOException {
        PropertyName property = ff.property("gsml:specification/gsml:GeologicUnit/gml:description");
        Literal string = ff.literal((Object)"Olivine basalt, tuff, microgabbro, minor sedimentary rocks");
        Function function = ff.function("contains_text", new Expression[]{property, string});
        PropertyIsEqualTo filter = ff.equals((Expression)function, (Expression)ff.literal(1));
        FeatureCollection filteredResults = mfDataAccess.getFeatureSource(MAPPED_FEATURE).getFeatures((Filter)filter);
        Assert.assertEquals((long)FeatureChainingTest.getCount((FeatureCollection<FeatureType, Feature>)filteredResults), (long)3L);
    }

    private static void loadGeologicUnitDataAccess() throws IOException {
        HashMap<String, String> moParams = new HashMap<String, String>();
        moParams.put("dbtype", "input-data-access");
        DataAccess inputDataAccess = DataAccessFinder.getDataStore(moParams);
        guFeatureSource = inputDataAccess.getFeatureSource(GEOLOGIC_UNIT);
    }

    protected static void loadDataAccesses(String mfMappingFile) throws IOException {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = DataAccessIntegrationTest.class.getResource(schemaBase + mfMappingFile);
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        mfDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull(mfDataAccess);
        FeatureType mappedFeatureType = mfDataAccess.getSchema(MAPPED_FEATURE);
        Assert.assertNotNull((Object)mappedFeatureType);
        FeatureSource mfSource = mfDataAccess.getFeatureSource(MAPPED_FEATURE);
        FeatureCollection mfCollection = mfSource.getFeatures();
        Iterator mfIterator = mfCollection.iterator();
        mfFeatures = new ArrayList();
        while (mfIterator.hasNext()) {
            mfFeatures.add((Feature)mfIterator.next());
        }
        mfCollection.close(mfIterator);
        url = DataAccessIntegrationTest.class.getResource("/test-data/CGITermValue.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("url", url.toExternalForm());
        DataAccess cgiDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)cgiDataAccess);
        url = DataAccessIntegrationTest.class.getResource("/test-data/CompositionPart.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess cpDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)cpDataAccess);
        FeatureSource cpSource = cpDataAccess.getFeatureSource(COMPOSITION_PART);
        FeatureCollection cpCollection = cpSource.getFeatures();
        Iterator cpIterator = cpCollection.iterator();
        cpFeatures = new ArrayList();
        while (cpIterator.hasNext()) {
            cpFeatures.add((Feature)cpIterator.next());
        }
        cpCollection.close(cpIterator);
    }

    @AfterClass
    public static void tearDown() {
        DataAccessRegistry.unregisterAll();
    }

    public static void setFilterFactory() {
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("gsml", GSMLNS);
        namespaces.declarePrefix("gml", GMLNS);
        ff = new FilterFactoryImplNamespaceAware(namespaces);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InputDataAccessFactory
    implements DataAccessFactory {
        public boolean canProcess(Map<String, Serializable> params) {
            Serializable dbType = params.get("dbtype");
            return dbType == null ? false : dbType.equals("input-data-access");
        }

        public DataAccess<? extends FeatureType, ? extends Feature> createDataStore(Map<String, Serializable> params) throws IOException {
            File dir;
            URL schemaURL = this.getClass().getResource(DataAccessIntegrationTest.schemaBase);
            try {
                dir = new File(schemaURL.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            PropertyDataStore dataStore = new PropertyDataStore(dir);
            FeatureSource simpleFeatureSource = dataStore.getFeatureSource(GEOLOGIC_UNIT);
            FeatureCollection fCollection = simpleFeatureSource.getFeatures();
            reader = EmfAppSchemaReader.newInstance();
            URL catalogLocation = this.getClass().getResource("/test-data/mappedPolygons.oasis.xml");
            reader.setCatalog(CatalogUtilities.buildPrivateCatalog((URL)catalogLocation));
            SchemaIndex schemaIndex = reader.parse(new URL(schemaURL.toString() + File.separator + "commonSchemas_new/GeoSciML/geologicUnit.xsd"), null);
            typeRegistry = new FeatureTypeRegistry();
            typeRegistry.addSchemas(schemaIndex);
            FeatureType simpleType = (FeatureType)typeRegistry.getAttributeType(GEOLOGIC_UNIT_TYPE);
            inputFeatures = DataAccessIntegrationTest.getInputFeatures((FeatureCollection<SimpleFeatureType, SimpleFeature>)fCollection, simpleType);
            FeatureTypeImpl guSchema = new FeatureTypeImpl(GEOLOGIC_UNIT, simpleType.getDescriptors(), null, true, simpleType.getRestrictions(), (AttributeType)GMLSchema.ABSTRACTFEATURETYPE_TYPE, null);
            return new InputDataAccess(inputFeatures, (FeatureType)guSchema);
        }

        public String getDescription() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public DataAccessFactory.Param[] getParametersInfo() {
            return null;
        }

        public boolean isAvailable() {
            return true;
        }

        public Map<RenderingHints.Key, ?> getImplementationHints() {
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class InputFeatureIterator
        implements Iterator<Feature>,
        FeatureIterator<Feature> {
            Iterator<Feature> iterator;

            public InputFeatureIterator(ArrayList<Feature> features) {
                this.iterator = features.iterator();
            }

            public void close() {
                this.iterator = null;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Feature next() throws NoSuchElementException {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class InputFeatureCollection
        implements FeatureCollection<FeatureType, Feature> {
            private ArrayList<Feature> fList = new ArrayList();
            private FeatureType schema;

            public InputFeatureCollection(FeatureType schema, Collection<Feature> features) {
                this.schema = schema;
                this.addAll(features);
            }

            public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
                throw new UnsupportedOperationException();
            }

            public boolean add(Feature obj) {
                return this.fList.add(obj);
            }

            public boolean addAll(Collection<? extends Feature> collection) {
                return this.fList.addAll(collection);
            }

            public boolean addAll(FeatureCollection<? extends FeatureType, ? extends Feature> resource) {
                throw new UnsupportedOperationException();
            }

            public void addListener(CollectionListener listener) throws NullPointerException {
                throw new UnsupportedOperationException();
            }

            public void clear() {
                this.fList.clear();
            }

            public void close(FeatureIterator<Feature> close) {
                close.close();
            }

            public void close(Iterator<Feature> close) {
                ((InputFeatureIterator)close).close();
            }

            public boolean contains(Object o) {
                return this.fList.contains(o);
            }

            public boolean containsAll(Collection<?> o) {
                return this.fList.containsAll(o);
            }

            public FeatureIterator<Feature> features() {
                return new InputFeatureIterator(this.fList);
            }

            public ReferencedEnvelope getBounds() {
                throw new UnsupportedOperationException();
            }

            public String getID() {
                return null;
            }

            public FeatureType getSchema() {
                return this.schema;
            }

            public boolean isEmpty() {
                return this.fList.isEmpty();
            }

            public Iterator<Feature> iterator() {
                return (Iterator)this.features();
            }

            public void purge() {
                throw new UnsupportedOperationException();
            }

            public boolean remove(Object o) {
                return this.fList.remove(o);
            }

            public boolean removeAll(Collection<?> c) {
                return this.fList.removeAll(c);
            }

            public void removeListener(CollectionListener listener) throws NullPointerException {
                throw new UnsupportedOperationException();
            }

            public boolean retainAll(Collection<?> c) {
                return this.fList.retainAll(c);
            }

            public int size() {
                return this.fList.size();
            }

            public FeatureCollection<FeatureType, Feature> sort(SortBy order) {
                throw new UnsupportedOperationException();
            }

            public FeatureCollection<FeatureType, Feature> subCollection(Filter filter) {
                if (filter == Filter.INCLUDE) {
                    return this;
                }
                InputFeatureCollection fCollection = new InputFeatureCollection(this.schema, new ArrayList<Feature>());
                for (Feature feature : this.fList) {
                    if (!filter.evaluate((Object)feature)) continue;
                    fCollection.add(feature);
                }
                return fCollection;
            }

            public Object[] toArray() {
                return this.fList.toArray();
            }

            public <O> O[] toArray(O[] a) {
                return this.fList.toArray(a);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class InputFeatureSource
        implements FeatureSource<FeatureType, Feature> {
            private FeatureCollection<FeatureType, Feature> fCollection;
            private DataAccess<FeatureType, Feature> dataAccess;

            public InputFeatureSource(FeatureCollection<FeatureType, Feature> fCollection, DataAccess<FeatureType, Feature> dataAccess) {
                this.fCollection = fCollection;
                this.dataAccess = dataAccess;
            }

            public void addFeatureListener(FeatureListener listener) {
                throw new UnsupportedOperationException();
            }

            public ReferencedEnvelope getBounds() throws IOException {
                throw new UnsupportedOperationException();
            }

            public ReferencedEnvelope getBounds(Query query) throws IOException {
                throw new UnsupportedOperationException();
            }

            public int getCount(Query query) throws IOException {
                return this.fCollection.size();
            }

            public DataAccess<FeatureType, Feature> getDataStore() {
                return this.dataAccess;
            }

            public FeatureCollection<FeatureType, Feature> getFeatures(Query query) throws IOException {
                return this.getFeatures(query.getFilter());
            }

            public FeatureCollection<FeatureType, Feature> getFeatures(Filter filter) throws IOException {
                return this.fCollection.subCollection(filter);
            }

            public FeatureCollection<FeatureType, Feature> getFeatures() throws IOException {
                return this.fCollection;
            }

            public ResourceInfo getInfo() {
                throw new UnsupportedOperationException();
            }

            public Name getName() {
                return this.fCollection.getSchema().getName();
            }

            public QueryCapabilities getQueryCapabilities() {
                throw new UnsupportedOperationException();
            }

            public FeatureType getSchema() {
                return this.fCollection.getSchema();
            }

            public Set<RenderingHints.Key> getSupportedHints() {
                throw new UnsupportedOperationException();
            }

            public void removeFeatureListener(FeatureListener listener) {
                throw new UnsupportedOperationException();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InputDataAccess
        implements DataAccess<FeatureType, Feature> {
            private FeatureSource<FeatureType, Feature> fSource;
            private ArrayList<Name> names = new ArrayList();

            public InputDataAccess(Collection<Feature> features, FeatureType schema) {
                InputFeatureCollection fCollection = new InputFeatureCollection(schema, features);
                this.fSource = new InputFeatureSource(fCollection, this);
                this.names.add(this.fSource.getName());
                DataAccessRegistry.register((DataAccess)this);
            }

            public void createSchema(FeatureType featureType) throws IOException {
                throw new UnsupportedOperationException();
            }

            public void dispose() {
                this.fSource = null;
                this.names.clear();
                DataAccessRegistry.unregister((DataAccess)this);
            }

            public FeatureSource<FeatureType, Feature> getFeatureSource(Name typeName) throws IOException {
                return this.fSource;
            }

            public ServiceInfo getInfo() {
                throw new UnsupportedOperationException();
            }

            public List<Name> getNames() throws IOException {
                return this.names;
            }

            public FeatureType getSchema(Name name) throws IOException {
                return this.fSource.getFeatures().getSchema();
            }

            public void updateSchema(Name typeName, FeatureType featureType) throws IOException {
                throw new UnsupportedOperationException();
            }
        }
    }
}

