/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.feature.type.ComplexTypeImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.expression.FeaturePropertyAccessorFactory;
import org.geotools.filter.identity.FeatureIdImpl;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.FeatureId;
import org.xml.sax.helpers.NamespaceSupport;

public class FeaturePropertyAccessorTest
extends TestCase {
    static final String EG = "urn:cgi:xmlns:Example:1.0";
    static final Name SIMPLE_ATTRIBUTE = new NameImpl("urn:cgi:xmlns:Example:1.0", "simpleAttribute");
    static final Name COMPLEX_ATTRIBUTE = new NameImpl("urn:cgi:xmlns:Example:1.0", "complexAttribute");
    static final Name ROOT_ATTRIBUTE = new NameImpl("urn:cgi:xmlns:Example:1.0", "rootAttribute");
    static final Name SINGLE_LEAF_ATTRIBUTE = new NameImpl("urn:cgi:xmlns:Example:1.0", "singleLeafAttribute");
    static final Name MULTI_LEAF_ATTRIBUTE = new NameImpl("urn:cgi:xmlns:Example:1.0", "multiLeafAttribute");
    static final NamespaceSupport NAMESPACES = new NamespaceSupport(){
        {
            this.declarePrefix("eg", FeaturePropertyAccessorTest.EG);
        }
    };

    public void testComplexFeature() {
        FeatureType fType = FeaturePropertyAccessorTest.createFeatureType();
        ComplexType complexAttType = (ComplexType)fType.getDescriptor(COMPLEX_ATTRIBUTE).getType();
        ComplexType rootAttType = (ComplexType)complexAttType.getDescriptor(ROOT_ATTRIBUTE).getType();
        ArrayList<Object> properties = new ArrayList<Object>(fType.getDescriptors().size());
        AttributeDescriptor attDesc = (AttributeDescriptor)fType.getDescriptor(SIMPLE_ATTRIBUTE);
        AttributeImpl simpleAttribute = new AttributeImpl((Object)"simple value", attDesc, null);
        properties.add(simpleAttribute);
        ArrayList<AttributeImpl> rootPropertiesOne = new ArrayList<AttributeImpl>();
        attDesc = (AttributeDescriptor)rootAttType.getDescriptor(MULTI_LEAF_ATTRIBUTE);
        AttributeImpl leafOne = new AttributeImpl((Object)"multi leaf value 1", attDesc, null);
        rootPropertiesOne.add(leafOne);
        AttributeImpl leafTwo = new AttributeImpl((Object)"multi leaf value 2", attDesc, null);
        rootPropertiesOne.add(leafTwo);
        attDesc = (AttributeDescriptor)rootAttType.getDescriptor(SINGLE_LEAF_ATTRIBUTE);
        AttributeImpl singleLeaf = new AttributeImpl((Object)"single leaf value", attDesc, null);
        rootPropertiesOne.add(singleLeaf);
        AttributeDescriptor rootDesc = (AttributeDescriptor)complexAttType.getDescriptor(ROOT_ATTRIBUTE);
        ComplexAttributeImpl rootOne = new ComplexAttributeImpl(rootPropertiesOne, rootDesc, null);
        ArrayList<AttributeImpl> rootPropertiesTwo = new ArrayList<AttributeImpl>();
        rootPropertiesTwo.add(leafOne);
        ComplexAttributeImpl rootTwo = new ComplexAttributeImpl(rootPropertiesTwo, rootDesc, null);
        ArrayList<AttributeImpl> rootPropertiesThree = new ArrayList<AttributeImpl>();
        rootPropertiesThree.add(singleLeaf);
        ComplexAttributeImpl rootThree = new ComplexAttributeImpl(rootPropertiesThree, rootDesc, null);
        ArrayList<ComplexAttributeImpl> complexProperties = new ArrayList<ComplexAttributeImpl>(2);
        complexProperties.add(rootOne);
        complexProperties.add(rootTwo);
        complexProperties.add(rootThree);
        ComplexAttributeImpl complexAttribute = new ComplexAttributeImpl(complexProperties, complexAttType, null);
        properties.add(complexAttribute);
        FeatureImpl feature = new FeatureImpl(properties, fType, (FeatureId)new FeatureIdImpl("test1"));
        AttributeExpressionImpl ex = new AttributeExpressionImpl("eg:simpleAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        FeaturePropertyAccessorTest.assertEquals((Object)simpleAttribute, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        FeaturePropertyAccessorTest.assertEquals((Object)complexAttribute, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        FeaturePropertyAccessorTest.assertEquals((Object)rootOne, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute[2]", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        FeaturePropertyAccessorTest.assertEquals((Object)rootTwo, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute[3]/eg:singleLeafAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        FeaturePropertyAccessorTest.assertEquals((Object)singleLeaf, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute[3]/eg:multiLeafAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        FeaturePropertyAccessorTest.assertEquals(null, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute[2]/eg:multiLeafAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        FeaturePropertyAccessorTest.assertEquals((Object)leafOne, (Object)ex.evaluate((Object)feature));
        ex = new AttributeExpressionImpl("eg:complexAttribute/eg:rootAttribute[2]/eg:multiLeafAttribute[2]", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        FeaturePropertyAccessorTest.assertEquals(null, (Object)ex.evaluate((Object)feature));
        boolean exceptionThrown = false;
        try {
            FeaturePropertyAccessorTest.assertEquals(null, (Object)ex.evaluate((Object)singleLeaf));
        }
        catch (ClassCastException e) {
            exceptionThrown = true;
        }
        if (!exceptionThrown) {
            FeaturePropertyAccessorTest.fail((String)"Expecting ClassCastException since object passed in is not a complex attribute.");
        }
        ex = new AttributeExpressionImpl("randomAttribute", new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)NAMESPACES));
        FeaturePropertyAccessorTest.assertEquals(null, (Object)ex.evaluate((Object)feature));
    }

    public static FeatureType createFeatureType() {
        FeatureTypeFactoryImpl tfac = new FeatureTypeFactoryImpl();
        NameImpl fName = new NameImpl(EG, "complexFeatureType");
        ArrayList<AttributeDescriptorImpl> schema = new ArrayList<AttributeDescriptorImpl>();
        AttributeTypeImpl attType = new AttributeTypeImpl(SIMPLE_ATTRIBUTE, String.class, false, false, Collections.EMPTY_LIST, null, null);
        AttributeDescriptorImpl attDesc = new AttributeDescriptorImpl((AttributeType)attType, SIMPLE_ATTRIBUTE, 0, 1, true, null);
        schema.add(attDesc);
        ArrayList<AttributeDescriptorImpl> rootProperties = new ArrayList<AttributeDescriptorImpl>();
        attType = new AttributeTypeImpl(SINGLE_LEAF_ATTRIBUTE, String.class, false, false, Collections.EMPTY_LIST, null, null);
        attDesc = new AttributeDescriptorImpl((AttributeType)attType, SINGLE_LEAF_ATTRIBUTE, 0, 1, true, null);
        rootProperties.add(attDesc);
        attType = new AttributeTypeImpl(MULTI_LEAF_ATTRIBUTE, String.class, false, false, Collections.EMPTY_LIST, null, null);
        attDesc = new AttributeDescriptorImpl((AttributeType)attType, MULTI_LEAF_ATTRIBUTE, 0, -1, true, null);
        rootProperties.add(attDesc);
        attType = new ComplexTypeImpl(ROOT_ATTRIBUTE, rootProperties, false, false, Collections.EMPTY_LIST, null, null);
        attDesc = new AttributeDescriptorImpl((AttributeType)attType, ROOT_ATTRIBUTE, 0, -1, true, null);
        ArrayList<AttributeDescriptorImpl> nestedProperties = new ArrayList<AttributeDescriptorImpl>(1);
        nestedProperties.add(attDesc);
        attType = new ComplexTypeImpl(COMPLEX_ATTRIBUTE, nestedProperties, false, false, Collections.EMPTY_LIST, null, null);
        attDesc = new AttributeDescriptorImpl((AttributeType)attType, COMPLEX_ATTRIBUTE, 0, -1, true, null);
        schema.add(attDesc);
        return tfac.createFeatureType((Name)fName, schema, null, false, Collections.EMPTY_LIST, null, null);
    }
}

