/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.filter.XPath;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.Types;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedAttributeMapping
extends AttributeMapping {
    private FeatureSource<FeatureType, Feature> source;
    private FeatureSource<FeatureType, Feature> mappingSource;
    private final Expression nestedFeatureType;
    private final XPath.StepList nestedTargetXPath;
    private Expression nestedSourceExpression;
    private FilterFactory filterFac;
    private NamespaceSupport namespaces;

    public NestedAttributeMapping(Expression idExpression, Expression parentExpression, XPath.StepList targetXPath, boolean isMultiValued, Map<Name, Expression> clientProperties, Expression sourceElement, XPath.StepList sourcePath, NamespaceSupport namespaces) throws IOException {
        super(idExpression, parentExpression, targetXPath, null, isMultiValued, clientProperties);
        this.nestedTargetXPath = sourcePath;
        this.nestedFeatureType = sourceElement;
        this.filterFac = new FilterFactoryImplNamespaceAware(namespaces);
        this.namespaces = namespaces;
    }

    @Override
    public boolean isNestedAttribute() {
        return true;
    }

    public List<Feature> getInputFeatures(Object foreignKeyValue, CoordinateReferenceSystem reprojection, Feature feature) throws IOException {
        if (this.isSameSource()) {
            throw new UnsupportedOperationException("Link field is missing from feature chaining mapping!");
        }
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        if (this.source == null || !(this.nestedFeatureType instanceof AttributeExpressionImpl)) {
            Object featureTypeName = this.getNestedFeatureType(feature);
            if (featureTypeName == null || !(featureTypeName instanceof Name)) {
                return Collections.EMPTY_LIST;
            }
            FeatureTypeMapping featureTypeMapping = AppSchemaDataAccessRegistry.getMappingByName((Name)featureTypeName);
            assert (featureTypeMapping != null);
            this.source = featureTypeMapping.getSource();
            assert (this.source != null);
            AttributeMapping mapping = featureTypeMapping.getAttributeMapping(this.nestedTargetXPath);
            assert (mapping != null);
            this.nestedSourceExpression = mapping.getSourceExpression();
        }
        assert (this.nestedSourceExpression != null);
        PropertyIsEqualTo filter = this.filterFac.equals(this.nestedSourceExpression, (Expression)this.filterFac.literal(foreignKeyValue));
        DefaultQuery query = new DefaultQuery();
        query.setCoordinateSystemReproject(reprojection);
        query.setFilter((Filter)filter);
        FeatureCollection fCollection = this.source.getFeatures((Query)query);
        Iterator it = fCollection.iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            Object value = this.nestedSourceExpression.evaluate((Object)f);
            if (value == null || !value.equals(foreignKeyValue) && (!(foreignKeyValue instanceof FeatureId) || !value.equals(((FeatureId)foreignKeyValue).getID()))) continue;
            matchingFeatures.add(f);
        }
        fCollection.close(it);
        return matchingFeatures;
    }

    public List<Feature> getInputFeatures(Object foreignKeyValue, CoordinateReferenceSystem reprojection, FeatureTypeMapping fMapping) throws IOException {
        if (this.isSameSource()) {
            throw new UnsupportedOperationException("Link field is missing from feature chaining mapping!");
        }
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        if (this.source == null || !(this.nestedFeatureType instanceof AttributeExpressionImpl)) {
            assert (fMapping != null);
            this.source = fMapping.getSource();
            assert (this.source != null);
            AttributeMapping mapping = fMapping.getAttributeMapping(this.nestedTargetXPath);
            assert (mapping != null);
            this.nestedSourceExpression = mapping.getSourceExpression();
        }
        assert (this.nestedSourceExpression != null);
        PropertyIsEqualTo filter = this.filterFac.equals(this.nestedSourceExpression, (Expression)this.filterFac.literal(foreignKeyValue));
        DefaultQuery query = new DefaultQuery();
        query.setCoordinateSystemReproject(reprojection);
        query.setFilter((Filter)filter);
        FeatureCollection fCollection = this.source.getFeatures((Query)query);
        Iterator it = fCollection.iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            Object value = this.nestedSourceExpression.evaluate((Object)f);
            if (value == null || !value.equals(foreignKeyValue) && (!(foreignKeyValue instanceof FeatureId) || !value.equals(((FeatureId)foreignKeyValue).getID()))) continue;
            matchingFeatures.add(f);
        }
        fCollection.close(it);
        return matchingFeatures;
    }

    public List<Feature> getFeatures(Object foreignKeyValue, CoordinateReferenceSystem reprojection, Feature feature) throws IOException {
        if (this.isSameSource()) {
            throw new UnsupportedOperationException("Link field is missing from feature chaining mapping!");
        }
        FeatureSource<FeatureType, Feature> fSource = this.getMappingSource(feature);
        if (fSource == null) {
            return null;
        }
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        PropertyName propertyName = this.filterFac.property(this.nestedTargetXPath.toString());
        PropertyIsEqualTo filter = this.filterFac.equals((Expression)propertyName, (Expression)this.filterFac.literal(foreignKeyValue));
        DefaultQuery query = new DefaultQuery();
        query.setCoordinateSystemReproject(reprojection);
        query.setFilter((Filter)filter);
        FeatureCollection fCollection = fSource.getFeatures((Query)query);
        Iterator iterator = fCollection.iterator();
        while (iterator.hasNext()) {
            matchingFeatures.add((Feature)iterator.next());
        }
        fCollection.close(iterator);
        return matchingFeatures;
    }

    private FeatureSource<FeatureType, Feature> getMappingSource(Feature feature) throws IOException {
        if (this.mappingSource == null || !(this.nestedFeatureType instanceof AttributeExpressionImpl)) {
            Object featureTypeName = this.getNestedFeatureType(feature);
            if (featureTypeName == null || !(featureTypeName instanceof Name)) {
                return null;
            }
            this.mappingSource = DataAccessRegistry.getFeatureSource((Name)featureTypeName);
        }
        return this.mappingSource;
    }

    public Object getNestedFeatureType(Feature feature) {
        Object fTypeValue = this.nestedFeatureType instanceof AttributeExpressionImpl ? ((AttributeExpressionImpl)this.nestedFeatureType).getPropertyName() : this.nestedFeatureType.evaluate((Object)feature);
        if (fTypeValue == null) {
            return null;
        }
        if (!(fTypeValue instanceof Hints)) {
            return Types.degloseName(fTypeValue.toString(), this.namespaces);
        }
        return fTypeValue;
    }

    public boolean isSameSource() {
        return this.nestedTargetXPath == null;
    }

    public boolean isConditional() {
        return !(this.nestedFeatureType instanceof AttributeExpressionImpl);
    }

    public FeatureTypeMapping getFeatureTypeMapping(Feature feature) throws IOException {
        FeatureSource<FeatureType, Feature> fSource = this.getMappingSource(feature);
        if (fSource == null) {
            return null;
        }
        return fSource instanceof MappingFeatureSource ? ((MappingFeatureSource)fSource).getMapping() : null;
    }

    public NamespaceSupport getNamespaces() {
        return this.namespaces;
    }
}

