/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.session;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeDBMSInfo;
import com.esri.sde.sdk.client.SeDelete;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeInsert;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeRasterColumn;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeRelease;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeState;
import com.esri.sde.sdk.client.SeStreamOp;
import com.esri.sde.sdk.client.SeTable;
import com.esri.sde.sdk.client.SeUpdate;
import com.esri.sde.sdk.geom.GeometryFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.Commands;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.SdeRow;
import org.geotools.arcsde.session.SessionPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Session
implements ISession {
    public static final Logger LOGGER;
    protected static final long TEST_SERVER_ROUNDTRIP_INTERVAL_SECONDS = 5L;
    private final SeConnection connection;
    private final SessionPool pool;
    private final ArcSDEConnectionConfig config;
    private static final AtomicInteger sessionCounter;
    private final int sessionId;
    private boolean transactionInProgress;
    private boolean isPassivated;
    private Map<String, SeTable> cachedTables = new WeakHashMap<String, SeTable>();
    private Map<String, SeLayer> cachedLayers = new WeakHashMap<String, SeLayer>();
    private Thread commandThread;
    private final AtomicInteger referenceCounter = new AtomicInteger();

    Session(SessionPool pool, ArcSDEConnectionConfig config) throws IOException {
        this.sessionId = sessionCounter.incrementAndGet();
        this.config = config;
        this.pool = pool;
        this.updateCommandThread();
        CreateSeConnectionCommand connectionCommand = new CreateSeConnectionCommand(config, this.sessionId);
        try {
            this.connection = this.issue(connectionCommand);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException shouldntHappen) {
            throw shouldntHappen;
        }
    }

    @Override
    public synchronized <T> T issue(Command<T> command) throws IOException {
        try {
            if (this.connection == null) {
                return command.execute(this, null);
            }
            return command.execute(this, this.connection);
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
    }

    private void updateCommandThread() {
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Thread currentThread = Thread.currentThread();
                if (currentThread != Session.this.commandThread) {
                    LOGGER.fine("updating command thread from " + Session.this.commandThread + " to " + currentThread);
                    Session.this.commandThread = currentThread;
                }
                return null;
            }
        };
    }

    @Override
    public final void testServer() throws IOException {
        long secondsSinceLastServerRoundTrip = this.connection.getTimeSinceLastRT();
        if (5L < secondsSinceLastServerRoundTrip) {
            this.issue(Commands.TEST_SERVER_COMMAND);
        }
    }

    @Override
    public final boolean isClosed() {
        return this.connection.isClosed();
    }

    void markActive() {
        this.referenceCounter.incrementAndGet();
        this.isPassivated = false;
    }

    void markInactive() {
        if (this.referenceCounter.get() != 0) {
            throw new IllegalStateException("referenceCount = " + this.referenceCounter);
        }
        this.isPassivated = true;
    }

    @Override
    public boolean isDisposed() {
        return this.isPassivated;
    }

    private void checkActive() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Unrecoverable error: " + this.toString() + " is passivated, shall not be used!");
        }
    }

    @Override
    public SeLayer getLayer(final String layerName) throws IOException {
        SeLayer seLayer;
        this.checkActive();
        if (!this.cachedLayers.containsKey(layerName)) {
            this.issue(new Command<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                    Map map = Session.this.cachedLayers;
                    synchronized (map) {
                        if (!Session.this.cachedLayers.containsKey(layerName)) {
                            SeTable table = Session.this.getTable(layerName);
                            String shapeColumn = Session.this.getShapeColumn(table);
                            if (shapeColumn == null) {
                                return null;
                            }
                            SeLayer layer = new SeLayer(connection, layerName, shapeColumn);
                            Session.this.cachedLayers.put(layerName, layer);
                        }
                    }
                    return null;
                }
            });
        }
        if ((seLayer = this.cachedLayers.get(layerName)) == null) {
            throw new NoSuchElementException("Layer '" + layerName + "' not found");
        }
        return seLayer;
    }

    private String getShapeColumn(SeTable table) throws ArcSdeException {
        try {
            for (SeColumnDefinition aDef : table.describe()) {
                if (aDef.getType() != SeColumnDefinition.TYPE_SHAPE) continue;
                return aDef.getName();
            }
        }
        catch (SeException e) {
            throw new ArcSdeException("Exception describing table " + table.getName(), e);
        }
        return null;
    }

    @Override
    public synchronized SeRasterColumn getRasterColumn(String rasterName) throws IOException {
        throw new UnsupportedOperationException("Waiting for a proper implementation");
    }

    @Override
    public List<String> getRasterColumns() throws IOException {
        this.checkActive();
        List<String> rasterNames = this.issue(Commands.GetRasterColumnNamesCommand);
        return rasterNames;
    }

    @Override
    public SeTable getTable(final String tableName) throws IOException {
        SeTable seTable;
        this.checkActive();
        if (!this.cachedTables.containsKey(tableName)) {
            this.issue(new Command<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                    Map map = Session.this.cachedTables;
                    synchronized (map) {
                        if (!Session.this.cachedTables.containsKey(tableName)) {
                            SeTable table = new SeTable(connection, tableName);
                            try {
                                table.describe();
                            }
                            catch (SeException e) {
                                throw new NoSuchElementException("Table '" + tableName + "' not found");
                            }
                            Session.this.cachedTables.put(tableName, table);
                        }
                    }
                    return null;
                }
            });
        }
        if ((seTable = this.cachedTables.get(tableName)) == null) {
            throw new NoSuchElementException("Table '" + tableName + "' not found");
        }
        return seTable;
    }

    @Override
    public void startTransaction() throws IOException {
        this.checkActive();
        this.issue(Commands.StartTransactionCommand);
        this.transactionInProgress = true;
    }

    @Override
    public void commitTransaction() throws IOException {
        this.checkActive();
        this.issue(Commands.CommitTransactionCommand);
        this.transactionInProgress = false;
    }

    @Override
    public boolean isTransactionActive() {
        this.checkActive();
        return this.transactionInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackTransaction() throws IOException {
        this.checkActive();
        try {
            this.issue(Commands.RollbackTransactionCommand);
        }
        finally {
            this.transactionInProgress = false;
        }
    }

    @Override
    public void dispose() throws IllegalStateException {
        this.checkActive();
        int refCount = this.referenceCounter.decrementAndGet();
        if (refCount > 0) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("---------> Ignoring disposal, ref count is still " + refCount + " for " + this);
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("  -> RefCount is " + refCount + ". Disposing " + this);
        }
        if (this.transactionInProgress) {
            throw new IllegalStateException("Transaction is in progress, should commit or rollback before closing");
        }
        try {
            this.pool.returnObject(this);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public String toString() {
        return "Session[" + this.sessionId + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        LOGGER.fine("Destroying connection " + this.toString());
        try {
            this.issue(Commands.CloseConnectionCommand);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "closing connection " + this.toString(), e);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other == this;
    }

    @Override
    public int hashCode() {
        return 0x11 ^ this.config.hashCode();
    }

    @Override
    public List<SeLayer> getLayers() throws IOException {
        return this.issue(Commands.GetLayersCommand);
    }

    @Override
    public String getUser() throws IOException {
        return this.issue(Commands.GetUserCommand);
    }

    @Override
    public SeRelease getRelease() throws IOException {
        return this.issue(Commands.GetReleaseCommand);
    }

    @Override
    public String getDatabaseName() throws IOException {
        return this.issue(Commands.GetDatabaseNameCommand);
    }

    @Override
    public SeDBMSInfo getDBMSInfo() throws IOException {
        return this.issue(Commands.getDBMSInfoCommand);
    }

    @Override
    public SeRegistration createSeRegistration(String typeName) throws IOException {
        return this.issue(new Commands.CreateSeRegistrationCommand(typeName));
    }

    @Override
    public SeTable createSeTable(String qualifiedName) throws IOException {
        return this.issue(new Commands.CreateSeTableCommand(qualifiedName));
    }

    @Override
    public SeInsert createSeInsert() throws IOException {
        return this.issue(Commands.CreateSeInsertCommand);
    }

    @Override
    public SeUpdate createSeUpdate() throws IOException {
        return this.issue(Commands.CreateSeUpdateCommand);
    }

    @Override
    public SeDelete createSeDelete() throws IOException {
        return this.issue(Commands.CreateSeDeleteCommand);
    }

    @Override
    public SeColumnDefinition[] describe(String tableName) throws IOException {
        SeTable table = this.getTable(tableName);
        return this.describe(table);
    }

    @Override
    public SeColumnDefinition[] describe(SeTable table) throws IOException {
        return this.issue(new Commands.DescribeTableCommand(table));
    }

    @Override
    public SdeRow fetch(SeQuery query) throws IOException {
        return this.fetch(query, new SdeRow((GeometryFactory)null));
    }

    @Override
    public SdeRow fetch(final SeQuery query, final SdeRow currentRow) throws IOException {
        return this.issue(new Command<SdeRow>(){

            @Override
            public SdeRow execute(ISession session, SeConnection connection) throws SeException, IOException {
                SeRow row = query.fetch();
                if (row == null) {
                    return null;
                }
                currentRow.setRow(row);
                return currentRow;
            }
        });
    }

    @Override
    public void close(SeState state) throws IOException {
        this.issue(new Commands.CloseStateCommand(state));
    }

    @Override
    public void close(SeStreamOp stream) throws IOException {
        this.issue(new Commands.CloseStreamCommand(stream));
    }

    @Override
    public SeState createState(SeObjectId stateId) throws IOException {
        return this.issue(new Commands.CreateSeStateCommand(stateId));
    }

    @Override
    public SeQuery createAndExecuteQuery(String[] propertyNames, SeSqlConstruct sql) throws IOException {
        return this.issue(new Commands.CreateAndExecuteQueryCommand(propertyNames, sql));
    }

    @Override
    public SeState createChildState(long parentStateId) throws IOException {
        return this.issue(new Commands.CreateVersionStateCommand(parentStateId));
    }

    static {
        Logger logger = null;
        try {
            Class<?> clazz = Class.forName("org.geotools.util.logging.Logging");
            Method method = clazz.getMethod("getLogger", String.class);
            logger = (Logger)method.invoke(null, "org.geotools.arcsde.session");
        }
        catch (Exception e) {
            logger = Logger.getLogger("org.geotools.arcsde.session");
            logger.info("org.geotools.util.logging.Logging seems not to be in the classpath, acquired Logger through java.util.Logger");
        }
        LOGGER = logger;
        sessionCounter = new AtomicInteger();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CreateSeConnectionCommand
    extends Command<SeConnection> {
        private final ArcSDEConnectionConfig config;
        private final int sessionId;

        private CreateSeConnectionCommand(ArcSDEConnectionConfig config, int sessionId) {
            this.config = config;
            this.sessionId = sessionId;
        }

        @Override
        public SeConnection execute(ISession session, SeConnection connection) throws SeException, IOException {
            String serverName = this.config.getServerName();
            int portNumber = this.config.getPortNumber();
            String databaseName = this.config.getDatabaseName();
            String userName = this.config.getUserName();
            String userPassword = this.config.getPassword();
            NegativeArraySizeException cause = null;
            SeConnection conn = null;
            try {
                for (int i = 0; i < 3; ++i) {
                    try {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Creating connection for session #" + this.sessionId + "(try " + (i + 1) + " of 3)");
                        }
                        conn = new SeConnection(serverName, portNumber, databaseName, userName, userPassword);
                        break;
                    }
                    catch (NegativeArraySizeException nase) {
                        LOGGER.warning("Strange failed ArcSDE connection error.  Trying again (try " + (i + 1) + " of 3). SessionId: " + this.sessionId);
                        cause = nase;
                        continue;
                    }
                }
            }
            catch (SeException e) {
                throw new ArcSdeException("Can't create connection to " + serverName + " for Session #" + this.sessionId, e);
            }
            catch (RuntimeException e) {
                throw (IOException)new IOException("Can't create connection to " + serverName + " for Session #" + this.sessionId).initCause(e);
            }
            if (cause != null) {
                throw (IOException)new IOException("Couldn't create ArcSDE connection to " + serverName + " for Session #" + this.sessionId + " because of strange SDE internal exception. " + " Tried 3 times, giving up.").initCause(cause);
            }
            return conn;
        }
    }

    private static class SessionThreadFactory
    implements ThreadFactory {
        private final int sessionId;
        private static final ThreadGroup group = new ThreadGroup("ArcSDE Session threads");

        public SessionThreadFactory(int sessionId) {
            this.sessionId = sessionId;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(group, r, "ArcSDE Session " + this.sessionId);
            t.setDaemon(true);
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SessionTask<T>
    implements Callable<T> {
        private final Command<T> command;

        private SessionTask(Command<T> command) {
            this.command = command;
        }

        @Override
        public T call() throws Exception {
            Thread currentThread = Thread.currentThread();
            if (Session.this.commandThread != currentThread) {
                LOGGER.fine("updating command thread from " + Session.this.commandThread + " to " + currentThread);
                Session.this.commandThread = currentThread;
            }
            if (currentThread != Session.this.commandThread) {
                throw new IllegalStateException("currentThread != commandThread");
            }
            try {
                return this.command.execute(Session.this, Session.this.connection);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Command execution failed for Session " + Session.this.sessionId + " in thread " + currentThread.getId(), e);
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Command execution failed for Session " + Session.this.sessionId + " in thread " + currentThread.getId());
                }
                if (e instanceof SeException) {
                    throw new ArcSdeException((SeException)((Object)e));
                }
                if (e instanceof IOException) {
                    throw e;
                }
                throw new RuntimeException("Command execution failed for Session " + Session.this.sessionId + " in thread " + currentThread.getId(), e);
            }
        }
    }
}

