/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcSDEDataStoreConfig {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.pool");
    private static final String NULL_ARGUMENTS_MSG = "Illegal arguments. At least one of them was null. Check to pass correct values to dbtype, server, port, database, user and password parameters";
    private static final String ILLEGAL_ARGUMENT_MSG = " is not valid for parameter ";
    public static final String DBTYPE_PARAM_NAME = "dbtype";
    public static final String DBTYPE_PARAM_VALUE = "arcsde";
    public static final String NAMESPACE_PARAM_NAME = "namespace";
    public static final String VERSION_PARAM_NAME = "database.version";
    public static final String ALLOW_NON_SPATIAL_TABLES_PARAM_NAME = "datastore.allowNonSpatialTables";
    public static final int DEFAULT_CONNECTIONS = 2;
    public static final int DEFAULT_MAX_CONNECTIONS = 6;
    public static final int DEFAULT_MAX_WAIT_TIME = 500;
    private String namespaceUri;
    private String version;
    private boolean allowNonSpatialTables;
    private ArcSDEConnectionConfig sessionConfig = new ArcSDEConnectionConfig();

    public ArcSDEConnectionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public ArcSDEDataStoreConfig(Map<String, Serializable> params) throws IllegalArgumentException {
        this.init(params);
    }

    public ArcSDEDataStoreConfig(ArcSDEConnectionConfig sessionConfig, String namespace, String versionName, boolean allowNonSpatialTables) {
        this.sessionConfig = sessionConfig;
        this.namespaceUri = namespace;
        this.allowNonSpatialTables = allowNonSpatialTables;
        this.version = versionName;
    }

    private void init(Map<String, Serializable> params) throws NumberFormatException, IllegalArgumentException {
        String dbtype = (String)((Object)params.get(DBTYPE_PARAM_NAME));
        String server = (String)((Object)params.get("server"));
        String port = String.valueOf(params.get("port"));
        String instance = (String)((Object)params.get("instance"));
        String user = (String)((Object)params.get("user"));
        String pwd = (String)((Object)params.get("password"));
        String _port = ArcSDEDataStoreConfig.checkParams(dbtype, server, port, instance, user, pwd);
        this.sessionConfig.setServerName(server);
        this.sessionConfig.setPortNumber(_port);
        this.sessionConfig.setDatabaseName(instance);
        this.sessionConfig.setUserName(user);
        this.sessionConfig.setPassword(pwd);
        this.setUpOptionalParams(params);
    }

    public Map<String, Serializable> toMap() {
        Map params = this.sessionConfig.toMap();
        params.put(DBTYPE_PARAM_NAME, DBTYPE_PARAM_VALUE);
        params.put(VERSION_PARAM_NAME, this.getVersion());
        params.put(NAMESPACE_PARAM_NAME, this.getNamespaceUri());
        params.put(ALLOW_NON_SPATIAL_TABLES_PARAM_NAME, this.isAllowNonSpatialTables());
        return params;
    }

    private void setUpOptionalParams(Map<String, Serializable> params) throws IllegalArgumentException {
        String exceptionMsg = "";
        Serializable ns = params.get(NAMESPACE_PARAM_NAME);
        this.namespaceUri = ns == null ? null : String.valueOf(ns);
        Integer minConnections = ArcSDEDataStoreConfig.getInt(params.get("pool.minConnections"), 2);
        Integer maxConnections = ArcSDEDataStoreConfig.getInt(params.get("pool.maxConnections"), 6);
        Integer connTimeOut = ArcSDEDataStoreConfig.getInt(params.get("pool.timeOut"), 500);
        this.version = (String)((Object)params.get(VERSION_PARAM_NAME));
        Serializable nonSpatial = params.get(ALLOW_NON_SPATIAL_TABLES_PARAM_NAME);
        boolean bl = this.allowNonSpatialTables = nonSpatial == null ? false : Boolean.valueOf(String.valueOf(nonSpatial));
        if (minConnections <= 0) {
            exceptionMsg = exceptionMsg + "pool.minConnections must be a positive integer. ";
        }
        if (maxConnections <= 0) {
            exceptionMsg = exceptionMsg + "pool.maxConnections must be a positive integer. ";
        }
        if (connTimeOut <= 0) {
            exceptionMsg = exceptionMsg + "pool.timeOut must be a positive integer. ";
        }
        if (minConnections > maxConnections) {
            exceptionMsg = exceptionMsg + "pool.minConnections must be lower than pool.maxConnections.";
        }
        if (exceptionMsg.length() != 0) {
            throw new IllegalArgumentException(exceptionMsg);
        }
        this.sessionConfig.setMinConnections(minConnections);
        this.sessionConfig.setMaxConnections(maxConnections);
        this.sessionConfig.setConnTimeOut(connTimeOut);
    }

    private static final Integer getInt(Object value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String sVal = String.valueOf(value);
        try {
            return Integer.valueOf(sVal);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    private static String checkParams(String dbType, String serverName, String portNumber, String databaseName, String userName, String userPassword) throws IllegalArgumentException, NullPointerException {
        if (!DBTYPE_PARAM_VALUE.equals(dbType)) {
            throw new IllegalArgumentException("parameter dbtype must be arcsde");
        }
        if (serverName == null || portNumber == null || userName == null || userPassword == null) {
            throw new NullPointerException(NULL_ARGUMENTS_MSG);
        }
        if (serverName.length() == 0) {
            ArcSDEDataStoreConfig.throwIllegal("server", serverName);
        }
        if (databaseName == null || databaseName.length() == 0) {
            LOGGER.fine("No database name specified");
        }
        if (userName.length() == 0) {
            ArcSDEDataStoreConfig.throwIllegal("user", userName);
        }
        if (userPassword.length() == 0) {
            ArcSDEDataStoreConfig.throwIllegal("password", userPassword);
        }
        String port = null;
        try {
            port = portNumber.indexOf(":") > 0 ? portNumber : Integer.valueOf(portNumber).toString();
        }
        catch (NumberFormatException ex) {
            ArcSDEDataStoreConfig.throwIllegal("port", portNumber);
        }
        return port;
    }

    private static void throwIllegal(String paramName, String paramValue) throws IllegalArgumentException {
        throw new IllegalArgumentException("'" + paramValue + "'" + ILLEGAL_ARGUMENT_MSG + paramName);
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getDatabaseName() {
        return this.sessionConfig.getDatabaseName();
    }

    public String getPortNumber() {
        return this.sessionConfig.getPortNumber();
    }

    public String getServerName() {
        return this.sessionConfig.getServerName();
    }

    public String getUserName() {
        return this.sessionConfig.getUserName();
    }

    public String getUserPassword() {
        return this.sessionConfig.getPassword();
    }

    public int hashCode() {
        int hash = 37;
        hash *= this.getServerName().hashCode();
        hash *= this.getPortNumber().hashCode();
        return hash *= this.getUserName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArcSDEDataStoreConfig)) {
            return false;
        }
        ArcSDEDataStoreConfig config = (ArcSDEDataStoreConfig)o;
        return config.getServerName().equals(this.getServerName()) && config.getPortNumber().equals(this.getPortNumber()) && config.getUserName().equals(this.getUserName());
    }

    public Integer getConnTimeOut() {
        return this.sessionConfig.getConnTimeOut();
    }

    public Integer getMaxConnections() {
        return this.sessionConfig.getMaxConnections();
    }

    public Integer getMinConnections() {
        return this.sessionConfig.getMinConnections();
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isAllowNonSpatialTables() {
        return this.allowNonSpatialTables;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + "[");
        sb.append("dbtype=").append(DBTYPE_PARAM_VALUE);
        sb.append(", server=").append(this.getServerName());
        sb.append(", port=").append(this.getPortNumber());
        sb.append(", instance=").append(this.getDatabaseName());
        sb.append(", user=").append(this.getUserName());
        sb.append(", password=*****");
        sb.append(", version='").append(this.version == null ? "[DEFAULT]" : this.version).append("'");
        sb.append(", non-spatial:").append(this.allowNonSpatialTables);
        sb.append(", minConnections=").append(this.getMinConnections());
        sb.append(", maxConnections=").append(this.getMaxConnections());
        sb.append(", connTimeOut=").append(this.getConnTimeOut());
        sb.append("]");
        return sb.toString();
    }
}

