/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.client.SeTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.SdeRow;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public abstract class FIDReader {
    protected String layerName;
    private String fidColumn;
    private int columnIndex;
    public static final FIDReader NULL_READER = new FIDReader(null, null){

        public long readFid(SdeRow row) throws IOException {
            return (long)(10000.0 * Math.random());
        }
    };

    private FIDReader(String layerName, String fidColumn) {
        this.layerName = layerName;
        this.fidColumn = fidColumn;
    }

    public String getFidColumn() {
        return this.fidColumn;
    }

    public void setColumnIndex(int fidIndex) {
        this.columnIndex = fidIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public long readFid(SdeRow row) throws IOException {
        Object fid = row.getObject(this.columnIndex);
        return ((Number)fid).longValue();
    }

    public String[] getPropertiesToFetch(SimpleFeatureType schema) throws IOException {
        ArrayList<String> attNames = new ArrayList<String>(schema.getAttributeCount() + 1);
        List attDescriptors = schema.getAttributeDescriptors();
        for (AttributeDescriptor property : attDescriptors) {
            attNames.add(property.getLocalName());
        }
        String fidColumn = this.getFidColumn();
        int fidIndex = attNames.indexOf(fidColumn);
        if (fidColumn != null && fidIndex == -1) {
            attNames.add(fidColumn);
            fidIndex = attNames.size() - 1;
        }
        this.setColumnIndex(fidIndex);
        return attNames.toArray(new String[attNames.size()]);
    }

    public static FIDReader getFidReader(ISession session, final SeTable table, final SeLayer layer, final SeRegistration reg) throws IOException {
        return (FIDReader)session.issue((Command)new Command<FIDReader>(){

            public FIDReader execute(ISession session, SeConnection connection) throws SeException, IOException {
                return FIDReader.getFidReaderInternal(session, table, layer, reg);
            }
        });
    }

    private static FIDReader getFidReaderInternal(ISession session, SeTable table, SeLayer layer, SeRegistration reg) throws IOException, ArcSdeException {
        FIDReader fidReader = null;
        String tableName = reg.getTableName();
        try {
            int rowIdColumnType = reg.getRowIdColumnType();
            String rowIdColumnName = reg.getRowIdColumnName();
            int rowIdColumnIndex = -1;
            SeColumnDefinition[] schema = session.describe(table);
            for (int index = 0; index < schema.length; ++index) {
                if (!schema[index].getName().equals(rowIdColumnName)) continue;
                rowIdColumnIndex = index;
                break;
            }
            if (rowIdColumnType == SeRegistration.SE_REGISTRATION_ROW_ID_COLUMN_TYPE_SDE) {
                fidReader = new SdeManagedFidReader(tableName, rowIdColumnName);
            } else if (rowIdColumnType == SeRegistration.SE_REGISTRATION_ROW_ID_COLUMN_TYPE_USER) {
                fidReader = new UserManagedFidReader(tableName, rowIdColumnName);
            } else if (rowIdColumnType == SeRegistration.SE_REGISTRATION_ROW_ID_COLUMN_TYPE_NONE) {
                String shapeColName = layer.getSpatialColumn();
                String shapeIdColName = layer.getShapeAttributeName(SeLayer.SE_SHAPE_ATTRIBUTE_FID);
                fidReader = new ShapeFidReader(tableName, shapeColName, shapeIdColName);
            } else {
                throw new IllegalStateException("Unkown ArcSDE row ID registration type: " + rowIdColumnType + " for layer " + tableName);
            }
            fidReader.setColumnIndex(rowIdColumnIndex);
            return fidReader;
        }
        catch (SeException e) {
            throw new ArcSdeException("Obtaining FID strategy for " + tableName, e);
        }
    }

    public static class UserManagedFidReader
    extends FIDReader {
        public UserManagedFidReader(String layerName, String rowIdColName) {
            super(layerName, rowIdColName);
        }
    }

    public static class SdeManagedFidReader
    extends FIDReader {
        public SdeManagedFidReader(String layerName, String rowIdColName) {
            super(layerName, rowIdColName);
        }
    }

    public static class ShapeFidReader
    extends FIDReader {
        private final String shapeColName;
        private int shapeIndex;

        public ShapeFidReader(String layerName, String shapeColName, String shapeIdColName) {
            super(layerName, shapeIdColName);
            this.shapeColName = shapeColName;
            this.shapeIndex = -1;
        }

        public long readFid(SdeRow row) throws IOException {
            long longFid;
            if (this.shapeIndex != -1) {
                try {
                    SeShape shape = row.getShape(this.shapeIndex);
                    if (shape == null) {
                        throw new NullPointerException("Can't get FID from " + this.layerName + " as it has SHAPE fid reading strategy and got a null shape");
                    }
                    longFid = shape.getFeatureId().longValue();
                }
                catch (SeException e) {
                    throw new ArcSdeException("Getting fid from shape", e);
                }
            } else {
                int shapeIdIndex = this.getColumnIndex();
                Integer id = (Integer)row.getObject(shapeIdIndex);
                longFid = id.longValue();
            }
            return longFid;
        }

        public String[] getPropertiesToFetch(SimpleFeatureType schema) throws IOException {
            ArrayList<String> attNames = new ArrayList<String>(schema.getAttributeCount() + 1);
            List attDescriptors = schema.getAttributeDescriptors();
            for (AttributeDescriptor property : attDescriptors) {
                attNames.add(property.getLocalName());
            }
            this.shapeIndex = attNames.indexOf(this.shapeColName);
            if (this.shapeIndex == -1) {
                String fidColumn = this.getFidColumn();
                int fidIndex = attNames.indexOf(this.shapeColName);
                if (fidIndex == -1) {
                    attNames.add(fidColumn);
                    fidIndex = attNames.size() - 1;
                }
                this.setColumnIndex(fidIndex);
            }
            return attNames.toArray(new String[attNames.size()]);
        }
    }
}

