/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.jai;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RecyclingTileFactory;
import javax.media.jai.TileCache;
import javax.media.jai.TileFactory;
import org.geotools.arcsde.raster.io.TileReader;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class ArcSDEPlanarImage
extends PlanarImage {
    private static final Logger LOGGER = Logging.getLogger(ArcSDEPlanarImage.class);
    private TileReader tileReader;
    private final SampleModel tileSampleModel;
    private final BigInteger UID;
    private final int hashCode;
    private final TileCache tileCache;

    public ArcSDEPlanarImage(TileReader tileReader, int minX, int minY, int width, int height, int tileGridXOffset, int tileGridYOffset, SampleModel tileSampleModel, ColorModel colorModel) {
        int bytesPerPixel;
        this.tileReader = tileReader;
        this.tileSampleModel = tileSampleModel;
        this.minX = minX;
        this.minY = minY;
        this.width = width;
        this.height = height;
        this.tileGridXOffset = tileGridXOffset;
        this.tileGridYOffset = tileGridYOffset;
        this.tileWidth = tileReader.getTileWidth();
        this.tileHeight = tileReader.getTileHeight();
        this.colorModel = colorModel;
        this.sampleModel = tileSampleModel;
        int result = 17;
        result = Utilities.hash((Object)tileReader.getServerName(), (int)result);
        result = Utilities.hash((Object)tileReader.getRasterTableName(), (int)result);
        result = Utilities.hash((long)tileReader.getRasterId(), (int)result);
        this.hashCode = result = Utilities.hash((int)tileReader.getPyramidLevel(), (int)result);
        this.UID = (BigInteger)ImageUtil.generateID((Object)((Object)this));
        switch (tileSampleModel.getDataType()) {
            case 0: {
                bytesPerPixel = 1;
                break;
            }
            case 5: {
                bytesPerPixel = 8;
                break;
            }
            case 3: 
            case 4: {
                bytesPerPixel = 4;
                break;
            }
            case 1: 
            case 2: {
                bytesPerPixel = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown DataBuffer type: " + tileSampleModel.getDataType());
            }
        }
        int numTilesInCache = 16;
        long memCapacity = numTilesInCache * bytesPerPixel * this.tileWidth * this.tileHeight * tileSampleModel.getNumBands();
        this.tileCache = JAI.createTileCache((long)memCapacity);
        JAI jai = JAI.getDefaultInstance();
        TileFactory tileFactory = (TileFactory)jai.getRenderingHint(JAI.KEY_TILE_FACTORY);
        this.tileFactory = tileFactory == null ? (this.tileCache instanceof Observable ? new org.geotools.coverage.grid.io.imageio.RecyclingTileFactory((Observable)this.tileCache) : new RecyclingTileFactory()) : tileFactory;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public BigInteger getImageID() {
        return this.UID;
    }

    public synchronized Raster getTile(int tileX, int tileY) {
        Raster currentTile = this.tileCache.getTile((RenderedImage)((Object)this), tileX, tileY);
        if (currentTile != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("! GOT TILE FROM TileCache " + tileX + ", " + tileY + ", plevel " + this.tileReader.getPyramidLevel());
            }
            return currentTile;
        }
        int xOrigin = this.tileXToX(tileX);
        int yOrigin = this.tileYToY(tileY);
        currentTile = this.tileFactory.createTile(this.tileSampleModel, new Point(xOrigin, yOrigin));
        if (this.shallIgnoreTile(tileX, tileY)) {
            return currentTile;
        }
        int readerTileX = tileX;
        int readerTileY = tileY;
        try {
            switch (this.tileSampleModel.getDataType()) {
                case 0: {
                    DataBufferByte dataBuffer = (DataBufferByte)currentTile.getDataBuffer();
                    byte[][] bankData = dataBuffer.getBankData();
                    this.tileReader.getTile(readerTileX, readerTileY, bankData);
                    break;
                }
                case 1: {
                    DataBufferUShort dataBuffer = (DataBufferUShort)currentTile.getDataBuffer();
                    short[][] bankData = dataBuffer.getBankData();
                    this.tileReader.getTile(readerTileX, readerTileY, bankData);
                    break;
                }
                case 2: {
                    DataBufferShort dataBuffer = (DataBufferShort)currentTile.getDataBuffer();
                    short[][] bankData = dataBuffer.getBankData();
                    this.tileReader.getTile(readerTileX, readerTileY, bankData);
                    break;
                }
                case 3: {
                    DataBufferInt dataBuffer = (DataBufferInt)currentTile.getDataBuffer();
                    int[][] bankData = dataBuffer.getBankData();
                    this.tileReader.getTile(readerTileX, readerTileY, bankData);
                    break;
                }
                case 4: {
                    DataBufferFloat dataBuffer = (DataBufferFloat)currentTile.getDataBuffer();
                    float[][] bankData = dataBuffer.getBankData();
                    this.tileReader.getTile(readerTileX, readerTileY, bankData);
                    break;
                }
                case 5: {
                    DataBufferDouble dataBuffer = (DataBufferDouble)currentTile.getDataBuffer();
                    double[][] bankData = dataBuffer.getBankData();
                    this.tileReader.getTile(readerTileX, readerTileY, bankData);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized DataBuffer type: " + this.tileSampleModel.getDataType());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.tileCache.add((RenderedImage)((Object)this), tileX, tileY, currentTile);
        return currentTile;
    }

    private boolean shallIgnoreTile(int tx, int ty) {
        int minTileX = this.tileReader.getMinTileX();
        int minTileY = this.tileReader.getMinTileY();
        int maxTileX = this.tileReader.getMaxTileX();
        int maxTileY = this.tileReader.getMaxTileY();
        boolean ignore = tx < minTileX || ty < minTileY || tx > maxTileX || ty > maxTileY;
        return ignore;
    }

    public synchronized void dispose() {
        super.dispose();
        this.tileReader.dispose();
    }

    protected void finalize() {
        this.dispose();
    }
}

