/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.util;

import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import com.esri.sde.sdk.pe.PeFactory;
import com.esri.sde.sdk.pe.PeGeographicCS;
import com.esri.sde.sdk.pe.PeProjectedCS;
import com.esri.sde.sdk.pe.PeProjectionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ArcSDEUtils {
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");

    private ArcSDEUtils() {
    }

    public static CoordinateReferenceSystem findCompatibleCRS(SeCoordinateReference seCoordRef) throws DataSourceException {
        if (seCoordRef == null) {
            LOGGER.fine("SeCoordinateReference is null, using DefaultEngineeringCRS.CARTESIAN_2D");
            return DefaultEngineeringCRS.CARTESIAN_2D;
        }
        PeCoordinateSystem coordSys = seCoordRef.getCoordSys();
        if (coordSys == null) {
            LOGGER.fine("SeCoordinateReference.getCoordSys() is null, using DefaultEngineeringCRS.CARTESIAN_2D");
            return DefaultEngineeringCRS.CARTESIAN_2D;
        }
        try {
            CoordinateReferenceSystem crs;
            int[] seEpsgCodes;
            int epsgCode = -1;
            if (coordSys instanceof PeGeographicCS) {
                seEpsgCodes = PeFactory.geogcsCodelist();
            } else if (coordSys instanceof PeProjectedCS) {
                seEpsgCodes = PeFactory.projcsCodelist();
            } else {
                throw new RuntimeException("Shouldnt happen!: Unnkown SeCoordSys type: " + coordSys.getClass().getName());
            }
            for (int i = 0; i < seEpsgCodes.length; ++i) {
                try {
                    int seEpsgCode = seEpsgCodes[i];
                    PeCoordinateSystem candidate = (PeCoordinateSystem)PeFactory.factory((int)seEpsgCode);
                    if (candidate == null || !candidate.getName().trim().equals(coordSys.getName())) continue;
                    epsgCode = seEpsgCode;
                    break;
                }
                catch (PeProjectionException pe) {
                    // empty catch block
                }
            }
            if (epsgCode == -1) {
                LOGGER.warning("Couldn't determine EPSG code for this raster.  Using SDE's WKT-like coordSysDescription() instead.");
                crs = CRS.parseWKT((String)seCoordRef.getCoordSysDescription());
            } else {
                crs = CRS.decode((String)("EPSG:" + epsgCode));
            }
            return crs;
        }
        catch (FactoryException e) {
            LOGGER.log(Level.SEVERE, "", e);
            throw new DataSourceException((Throwable)e);
        }
        catch (PeProjectionException e) {
            LOGGER.log(Level.SEVERE, "", e);
            throw new DataSourceException((Throwable)e);
        }
    }
}

