/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.Description;
import org.geotools.styling.StyleFactory;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionBuilder<P>
implements Builder<Description> {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    P parent;
    private boolean unset;
    private InternationalString title;
    private InternationalString description;

    public DescriptionBuilder() {
        this(null);
    }

    public DescriptionBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    @Override
    public Description build() {
        if (this.unset) {
            return null;
        }
        Description descript = this.sf.description(this.title, this.description);
        if (this.parent == null) {
            this.reset();
        }
        return descript;
    }

    @Override
    public DescriptionBuilder<P> reset() {
        this.unset = false;
        this.title = null;
        this.description = null;
        return this;
    }

    public DescriptionBuilder<P> title(InternationalString title) {
        this.title = title;
        return this;
    }

    public DescriptionBuilder<P> title(String title) {
        this.title = new SimpleInternationalString(title);
        return this;
    }

    public InternationalString title() {
        return this.title;
    }

    public DescriptionBuilder<P> description(InternationalString description) {
        this.description = description;
        return this;
    }

    public DescriptionBuilder<P> description(String description) {
        this.description = new SimpleInternationalString(description);
        return this;
    }

    public InternationalString description() {
        return this.description;
    }

    @Override
    public DescriptionBuilder<P> reset(Description original) {
        this.unset = false;
        this.title = original.getTitle();
        this.description = original.getAbstract();
        return this;
    }

    @Override
    public DescriptionBuilder<P> unset() {
        this.unset = true;
        this.title = null;
        this.description = null;
        return this;
    }
}

