/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.expression.ChildExpressionBuilder;
import org.geotools.styling.Mark;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.builder.ExternalMarkBuilder;
import org.geotools.styling.builder.FillBuilder;
import org.geotools.styling.builder.StrokeBuilder;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ExternalMark;
import org.opengis.style.Fill;
import org.opengis.style.Stroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkBuilder<P>
implements Builder<Mark> {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    P parent;
    StrokeBuilder<MarkBuilder<P>> strokeBuilder = new StrokeBuilder<MarkBuilder>(this);
    FillBuilder<MarkBuilder<P>> fill = new FillBuilder<MarkBuilder>(this);
    ExternalMarkBuilder<MarkBuilder<P>> externalMark = new ExternalMarkBuilder<MarkBuilder>(this);
    ChildExpressionBuilder<MarkBuilder<P>> wellKnownName = new ChildExpressionBuilder<MarkBuilder>(this);

    public MarkBuilder() {
        this(null);
    }

    public MarkBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    public ChildExpressionBuilder<MarkBuilder<P>> wellKnownName() {
        this.externalMark.unset();
        return this.wellKnownName;
    }

    public MarkBuilder<P> wellKnownName(Expression name) {
        this.wellKnownName.reset(name);
        this.externalMark.unset();
        return this;
    }

    public MarkBuilder<P> name(Expression name) {
        return this.wellKnownName(name);
    }

    public ExternalMarkBuilder<MarkBuilder<P>> externalMark() {
        return this.externalMark;
    }

    public StrokeBuilder<MarkBuilder<P>> stroke() {
        return this.strokeBuilder;
    }

    public FillBuilder<MarkBuilder<P>> fill() {
        return this.fill;
    }

    @Override
    public MarkBuilder<P> reset() {
        ((ChildExpressionBuilder)this.wellKnownName.reset()).literal("square");
        this.externalMark.unset();
        this.strokeBuilder.reset();
        this.fill.reset();
        return this;
    }

    @Override
    public Mark build() {
        Mark mark = null;
        if (!this.externalMark.isUnset()) {
            mark = this.sf.mark((ExternalMark)this.externalMark.build(), (Fill)this.fill.build(), (Stroke)this.strokeBuilder.build());
        }
        if (!this.wellKnownName.isUnset()) {
            mark = this.sf.mark(this.wellKnownName.build(), (Fill)this.fill.build(), (Stroke)this.strokeBuilder.build());
        }
        if (this.parent == null) {
            this.reset();
        }
        return mark;
    }

    @Override
    public MarkBuilder<P> reset(Mark mark) {
        if (mark == null) {
            return this.unset();
        }
        this.wellKnownName.reset(mark.getWellKnownName());
        this.externalMark.reset(mark.getExternalMark());
        this.strokeBuilder.reset(mark.getStroke());
        this.fill.reset((Fill)mark.getFill());
        return null;
    }

    @Override
    public MarkBuilder<P> unset() {
        this.externalMark.unset();
        this.wellKnownName.unset();
        this.fill.unset();
        this.strokeBuilder.unset();
        return this;
    }
}

