/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.awt.Color;
import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.expression.ChildExpressionBuilder;
import org.geotools.filter.expression.ExpressionBuilder;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.builder.GraphicBuilder;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Graphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrokeBuilder<P>
implements Builder<Stroke> {
    P parent;
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    ChildExpressionBuilder<StrokeBuilder<P>> color = new ChildExpressionBuilder<StrokeBuilder>(this);
    ChildExpressionBuilder<StrokeBuilder<P>> width = new ChildExpressionBuilder<StrokeBuilder>(this);
    ChildExpressionBuilder<StrokeBuilder<P>> opacity = new ChildExpressionBuilder<StrokeBuilder>(this);
    ChildExpressionBuilder<StrokeBuilder<P>> lineCap = new ChildExpressionBuilder<StrokeBuilder>(this);
    ChildExpressionBuilder<StrokeBuilder<P>> lineJoin = new ChildExpressionBuilder<StrokeBuilder>(this);
    float[] dashArray = null;
    ChildExpressionBuilder<StrokeBuilder<P>> dashOffset = new ChildExpressionBuilder<StrokeBuilder>(this);
    GraphicBuilder<StrokeBuilder<P>> graphicFill = new GraphicBuilder();
    GraphicBuilder<StrokeBuilder<P>> graphicStroke = new GraphicBuilder();
    private boolean unset;

    public StrokeBuilder() {
        this.reset();
    }

    public StrokeBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    @Override
    public StrokeBuilder<P> unset() {
        this.reset();
        this.unset = true;
        return this;
    }

    @Override
    public StrokeBuilder<P> reset() {
        this.color.reset(Stroke.DEFAULT.getColor());
        this.width.reset(Stroke.DEFAULT.getWidth());
        this.opacity.reset(Stroke.DEFAULT.getOpacity());
        this.lineCap.reset(Stroke.DEFAULT.getLineCap());
        this.lineJoin.reset(Stroke.DEFAULT.getLineJoin());
        this.dashArray = Stroke.DEFAULT.getDashArray();
        this.dashOffset.reset(Stroke.DEFAULT.getDashOffset());
        this.graphicFill.unset();
        this.graphicStroke.reset();
        this.unset = false;
        return this;
    }

    @Override
    public StrokeBuilder<P> reset(Stroke stroke) {
        this.color.reset(stroke.getColor());
        this.width.reset(stroke.getWidth());
        this.opacity.reset(stroke.getOpacity());
        this.lineCap.reset(stroke.getLineCap());
        this.lineJoin.reset(stroke.getLineJoin());
        this.dashArray = stroke.getDashArray();
        this.dashOffset.reset(stroke.getDashOffset());
        this.graphicFill.reset((Graphic)stroke.getGraphicFill());
        this.graphicStroke.reset((Graphic)stroke.getGraphicStroke());
        this.unset = false;
        return this;
    }

    public StrokeBuilder<P> color(Expression color) {
        this.color.reset(color);
        this.unset = false;
        return this;
    }

    public StrokeBuilder<P> color(Color color) {
        this.color.literal(color);
        this.unset = false;
        return this;
    }

    public StrokeBuilder<P> color(String color) {
        this.color.literal(color);
        this.unset = false;
        return this;
    }

    public ExpressionBuilder color() {
        return this.color;
    }

    public StrokeBuilder<P> width(Expression width) {
        this.width.reset(width);
        this.unset = false;
        return this;
    }

    public StrokeBuilder<P> width(int width) {
        this.width.literal(width);
        this.unset = false;
        return this;
    }

    public StrokeBuilder<P> width(double width) {
        this.width.literal(width);
        this.unset = false;
        return this;
    }

    public ChildExpressionBuilder<StrokeBuilder<P>> width() {
        return this.width;
    }

    public StrokeBuilder<P> opacity(Expression opacity) {
        this.opacity.reset(opacity);
        this.unset = false;
        return this;
    }

    public StrokeBuilder<P> opacity(double opacity) {
        this.opacity.literal(opacity);
        this.unset = false;
        return this;
    }

    public ExpressionBuilder opacity() {
        return this.opacity;
    }

    public StrokeBuilder<P> lineCap(Expression lineCap) {
        this.lineCap.reset(lineCap);
        this.unset = false;
        return this;
    }

    public ChildExpressionBuilder<StrokeBuilder<P>> lineCap() {
        return this.lineCap;
    }

    public StrokeBuilder<P> lineJoin(Expression lineJoin) {
        this.lineJoin.reset(lineJoin);
        this.unset = false;
        return this;
    }

    public ChildExpressionBuilder<StrokeBuilder<P>> lineJoin() {
        return this.lineJoin;
    }

    public StrokeBuilder<P> dashArray(float[] dashArray) {
        this.dashArray = dashArray;
        this.unset = false;
        return this;
    }

    public float[] dashArray() {
        return this.dashArray;
    }

    public StrokeBuilder<P> dashOffet(Expression dashOffet) {
        this.dashOffset.reset(dashOffet);
        this.unset = false;
        return this;
    }

    public StrokeBuilder<P> dashOffet(int offset) {
        this.dashOffset.literal(offset);
        this.unset = false;
        return this;
    }

    public StrokeBuilder<P> dashOffet(double offset) {
        this.dashOffset.literal(offset);
        this.unset = false;
        return this;
    }

    public ChildExpressionBuilder<StrokeBuilder<P>> dashOffset() {
        return this.dashOffset;
    }

    public GraphicBuilder<StrokeBuilder<P>> graphicStroke() {
        this.unset = false;
        return this.graphicStroke;
    }

    public GraphicBuilder<StrokeBuilder<P>> fillBuilder() {
        this.unset = false;
        return this.graphicFill;
    }

    @Override
    public Stroke build() {
        if (this.unset) {
            return null;
        }
        Stroke stroke = this.sf.createStroke(this.color.build(), this.width.build(), this.opacity.build(), this.lineJoin.build(), this.lineCap.build(), this.dashArray, this.dashOffset.build(), this.graphicFill.build(), this.graphicStroke.build());
        this.reset();
        return stroke;
    }
}

