/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ExtensionSymbolizer;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.builder.ExtensionSymbolizerBuilder;
import org.geotools.styling.builder.LineSymbolizerBuilder;
import org.geotools.styling.builder.PointSymbolizerBuilder;
import org.geotools.styling.builder.PolygonSymbolizerBuilder;
import org.geotools.styling.builder.RasterSymbolizerBuilder;
import org.geotools.styling.builder.TextSymbolizerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolizerBuilder<P>
implements Builder<Symbolizer> {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    P parent;
    Builder<? extends Symbolizer> delegate = null;

    public SymbolizerBuilder() {
        this(null);
    }

    public SymbolizerBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    public PointSymbolizerBuilder<P> point() {
        if (this.delegate == null || !(this.delegate instanceof PointSymbolizerBuilder)) {
            this.delegate = new PointSymbolizerBuilder<P>(this.parent);
        }
        return (PointSymbolizerBuilder)this.delegate;
    }

    public LineSymbolizerBuilder<P> line() {
        if (this.delegate == null || !(this.delegate instanceof LineSymbolizerBuilder)) {
            this.delegate = new LineSymbolizerBuilder<P>(this.parent);
        }
        return (LineSymbolizerBuilder)this.delegate;
    }

    public PolygonSymbolizerBuilder<P> polygon() {
        if (this.delegate == null || !(this.delegate instanceof PolygonSymbolizerBuilder)) {
            this.delegate = new PolygonSymbolizerBuilder<P>(this.parent);
        }
        return (PolygonSymbolizerBuilder)this.delegate;
    }

    public TextSymbolizerBuilder<P> text() {
        if (this.delegate == null || !(this.delegate instanceof TextSymbolizerBuilder)) {
            this.delegate = new TextSymbolizerBuilder<P>(this.parent);
        }
        return (TextSymbolizerBuilder)this.delegate;
    }

    public RasterSymbolizerBuilder<P> raster() {
        if (this.delegate == null || !(this.delegate instanceof RasterSymbolizerBuilder)) {
            this.delegate = new RasterSymbolizerBuilder<P>(this.parent);
        }
        return (RasterSymbolizerBuilder)this.delegate;
    }

    public ExtensionSymbolizerBuilder<P> vendor() {
        if (this.delegate == null || !(this.delegate instanceof ExtensionSymbolizerBuilder)) {
            this.delegate = new ExtensionSymbolizerBuilder<P>(this.parent);
        }
        return (ExtensionSymbolizerBuilder)this.delegate;
    }

    @Override
    public SymbolizerBuilder<P> unset() {
        this.delegate = null;
        return this;
    }

    @Override
    public SymbolizerBuilder<P> reset() {
        this.delegate = new PointSymbolizerBuilder<SymbolizerBuilder>(this).reset();
        return this;
    }

    @Override
    public SymbolizerBuilder<P> reset(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return this.unset();
        }
        if (symbolizer instanceof PointSymbolizer) {
            this.delegate = new PointSymbolizerBuilder<SymbolizerBuilder>(this).reset((PointSymbolizer)symbolizer);
        } else if (symbolizer instanceof LineSymbolizer) {
            this.delegate = new LineSymbolizerBuilder<SymbolizerBuilder>(this).reset((LineSymbolizer)symbolizer);
        } else if (symbolizer instanceof PolygonSymbolizer) {
            this.delegate = new PolygonSymbolizerBuilder<SymbolizerBuilder>(this).reset((PolygonSymbolizer)symbolizer);
        } else if (symbolizer instanceof TextSymbolizer) {
            this.delegate = new TextSymbolizerBuilder<SymbolizerBuilder>(this).reset((TextSymbolizer)symbolizer);
        } else if (symbolizer instanceof RasterSymbolizer) {
            this.delegate = new RasterSymbolizerBuilder<SymbolizerBuilder>(this).reset((RasterSymbolizer)symbolizer);
        } else if (symbolizer instanceof ExtensionSymbolizer) {
            this.delegate = new ExtensionSymbolizerBuilder<SymbolizerBuilder>(this).reset((ExtensionSymbolizer)symbolizer);
        }
        return this;
    }

    @Override
    public Symbolizer build() {
        if (this.delegate == null) {
            return null;
        }
        Symbolizer symbolizer = this.delegate.build();
        if (this.parent == null) {
            this.reset();
        }
        return symbolizer;
    }
}

