/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.tdk.cache;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.identity.FeatureId;
import org.tecgraf.tdk.cache.CachingFeatureAccessFactory;
import org.tecgraf.tdk.cache.CachingSimpleFeature;
import org.tecgraf.tdk.cache.FeatureCacher;
import org.tecgraf.tdk.cache.query.QueryAnalyzer;

public class BasicFeatureCacher
implements FeatureCacher<SimpleFeatureType, SimpleFeature> {
    private static Logger _logger = Logger.getLogger(BasicFeatureCacher.class);
    SpatialIndex _index;
    private Query _cachedQuery;
    private FilterFactory2 _filterFactory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private CachingFeatureAccessFactory<SimpleFeatureType, SimpleFeature> _cachingFeatureAccessFactory;
    private ReferencedEnvelope _cachedBounds;
    private SimpleFeatureType _completeSchema;

    public BasicFeatureCacher(SimpleFeatureType completeSchema, CachingFeatureAccessFactory<SimpleFeatureType, SimpleFeature> cachingFeatureAccessFactory) {
        if (completeSchema == null) {
            throw new IllegalArgumentException("completeSchema can't be null");
        }
        if (cachingFeatureAccessFactory == null) {
            throw new IllegalArgumentException("cachingFeatureAccessFactory can't be null");
        }
        this._cachingFeatureAccessFactory = cachingFeatureAccessFactory;
        this._completeSchema = completeSchema;
        this.init();
    }

    @Override
    public void clear() {
        _logger.debug((Object)("Clearing cache for type '" + this._cachedQuery.getTypeName() + "'"));
        this.init();
    }

    private void init() {
        this._cachedQuery = new DefaultQuery(this._completeSchema.getTypeName(), (Filter)Filter.EXCLUDE);
        this._cachedBounds = new ReferencedEnvelope(this._completeSchema.getCoordinateReferenceSystem());
        this._index = new Quadtree();
    }

    @Override
    public FeatureCollection<SimpleFeatureType, SimpleFeature> get(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null");
        }
        _logger.trace((Object)("Retrieving features for type '" + this._cachedQuery.getTypeName() + "' and query " + query));
        SimpleFeatureType alternate = this._completeSchema;
        try {
            if (query.getPropertyNames() != Query.ALL_NAMES && (alternate = DataUtilities.createSubType((SimpleFeatureType)this._completeSchema, (String[])query.getPropertyNames())).equals(this._completeSchema)) {
                alternate = this._completeSchema;
            }
        }
        catch (SchemaException e) {
            _logger.error((Object)"Could not retype features to this new schema, returning features in full schema", (Throwable)e);
        }
        FeatureCollection collection = FeatureCollections.newCollection();
        if (!query.getTypeName().equalsIgnoreCase(this._cachedQuery.getTypeName())) {
            _logger.warn((Object)("The cacher expects a different type name. '" + query.getTypeName() + "' is not '" + this._cachedQuery.getTypeName() + "'."));
            return new EmptyFeatureCollection(this._completeSchema);
        }
        if (query.getFilter().equals(Filter.EXCLUDE)) {
            _logger.warn((Object)"Query is using a 'exclude all' filter. Returning empty collection.");
            return new EmptyFeatureCollection(this._completeSchema);
        }
        if (query.getFilter().equals(Filter.INCLUDE) || query.equals(this._cachedQuery)) {
            List features = this._index.query((Envelope)this._cachedBounds);
            for (SimpleFeature feature : features) {
                collection.add((Feature)new CachingSimpleFeature(DataUtilities.reType((SimpleFeatureType)alternate, (SimpleFeature)feature)));
            }
            _logger.trace((Object)("Returning " + collection.size() + " features."));
            if (collection.size() == 0) {
                collection = new EmptyFeatureCollection(this._completeSchema);
            }
            return collection;
        }
        QueryAnalyzer subQueryAnalizer = this._cachingFeatureAccessFactory.createQueryAnalyzer(query);
        Envelope envelope = subQueryAnalizer.getEnvelope();
        List features = envelope.isNull() ? this._index.query((Envelope)this._cachedBounds) : this._index.query(envelope);
        for (SimpleFeature feature : features) {
            if (!query.getFilter().evaluate((Object)feature)) continue;
            collection.add((Feature)new CachingSimpleFeature(DataUtilities.reType((SimpleFeatureType)alternate, (SimpleFeature)feature)));
        }
        _logger.trace((Object)("Returning " + collection.size() + " features."));
        if (collection.size() == 0) {
            collection = new EmptyFeatureCollection(this._completeSchema);
        }
        return collection;
    }

    @Override
    public Query getCachedQuery() {
        return this._cachedQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection, Query query) {
        if (featureCollection == null) {
            throw new IllegalArgumentException("featureCollection can't be null");
        }
        if (query == null) {
            throw new IllegalArgumentException("query can't be null");
        }
        if (!this._cachedQuery.getTypeName().equalsIgnoreCase(query.getTypeName())) {
            _logger.warn((Object)("Not adding features . Query type name differs from this cache type. Expected '" + this._cachedQuery.getTypeName() + "' but was '" + query.getTypeName() + "'."));
            return;
        }
        if (!this._cachedQuery.getTypeName().equalsIgnoreCase(((SimpleFeatureType)featureCollection.getSchema()).getTypeName())) {
            _logger.warn((Object)("Not adding features . Collection type name differs from this cache type. Expected '" + this._cachedQuery.getTypeName() + "' but was '" + ((SimpleFeatureType)featureCollection.getSchema()).getTypeName() + "'."));
            return;
        }
        _logger.debug((Object)("Refilling cache from " + query));
        if (featureCollection.size() == 0) {
            _logger.debug((Object)"Empty collection, nothing added to the cache.");
            return;
        }
        _logger.debug((Object)("Adding " + featureCollection.size() + " features."));
        if (this._cachedQuery.getFilter().equals(Filter.EXCLUDE)) {
            FeatureIterator iterator = featureCollection.features();
            try {
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    ReferencedEnvelope featureBounds = new ReferencedEnvelope(feature.getBounds());
                    this._cachedBounds.expandToInclude((Envelope)featureBounds);
                    this._index.insert((Envelope)featureBounds, (Object)feature);
                }
                this._cachedQuery = query;
            }
            finally {
                iterator.close();
            }
        }
        QueryAnalyzer queryAnalyzer = this._cachingFeatureAccessFactory.createQueryAnalyzer(this._cachedQuery);
        FeatureIterator iterator = featureCollection.features();
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                ReferencedEnvelope featureBounds = new ReferencedEnvelope(feature.getBounds());
                this._cachedBounds.expandToInclude((Envelope)featureBounds);
                this._index.insert((Envelope)new ReferencedEnvelope(feature.getBounds()), (Object)feature);
            }
        }
        finally {
            iterator.close();
        }
        if (!queryAnalyzer.isSubQuery(query)) {
            this._cachedQuery = new DefaultQuery(this._cachedQuery.getTypeName(), (Filter)this._filterFactory.or(this._cachedQuery.getFilter(), query.getFilter()));
        }
    }

    @Override
    public void add(SimpleFeature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("feature can't be null");
        }
        _logger.debug((Object)("Adding '" + feature.getType().getTypeName() + "->" + feature.getID() + "' to cache."));
        FeatureCollection collection = FeatureCollections.newCollection();
        collection.add((Feature)feature);
        HashSet<FeatureId> idSet = new HashSet<FeatureId>();
        idSet.add(feature.getIdentifier());
        DefaultQuery query = new DefaultQuery(this._cachedQuery.getTypeName(), (Filter)this._filterFactory.id(idSet));
        this.add((FeatureCollection<SimpleFeatureType, SimpleFeature>)collection, (Query)query);
    }

    @Override
    public void remove(SimpleFeature feature) {
        ReferencedEnvelope boundingBox = new ReferencedEnvelope(feature.getBounds());
        List features = this._index.query((Envelope)boundingBox);
        for (Feature indexedFeature : features) {
            if (!indexedFeature.getIdentifier().equals(feature.getIdentifier())) continue;
            this._index.remove((Envelope)boundingBox, (Object)indexedFeature);
            break;
        }
    }

    @Override
    public void update(SimpleFeature feature) {
        if (feature instanceof CachingSimpleFeature) {
            CachingSimpleFeature cachingSimpleFeature = (CachingSimpleFeature)feature;
            SimpleFeature originalFeature = cachingSimpleFeature.getDelegate();
            ReferencedEnvelope oldBoundingBox = new ReferencedEnvelope(originalFeature.getBounds());
            List features = this._index.query((Envelope)oldBoundingBox);
            originalFeature.setAttributes(cachingSimpleFeature.getAttributes());
            for (Feature indexedFeature : features) {
                if (!indexedFeature.getIdentifier().equals(feature.getIdentifier())) continue;
                this._index.remove((Envelope)oldBoundingBox, (Object)indexedFeature);
                this._index.insert((Envelope)new ReferencedEnvelope(originalFeature.getBounds()), (Object)originalFeature);
                break;
            }
        } else {
            List features = this._index.query((Envelope)this._cachedBounds);
            for (Feature indexedFeature : features) {
                if (!indexedFeature.getIdentifier().equals(feature.getIdentifier())) continue;
                this._index.remove((Envelope)new ReferencedEnvelope(indexedFeature.getBounds()), (Object)indexedFeature);
                this._index.insert((Envelope)new ReferencedEnvelope(feature.getBounds()), (Object)feature);
                break;
            }
        }
    }

    @Override
    public String getTypeName() {
        return this._cachedQuery.getTypeName();
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this._completeSchema;
    }
}

