/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.tdk.cache;

import org.apache.log4j.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.tecgraf.tdk.cache.BasicFeatureCacher;
import org.tecgraf.tdk.cache.CachingFeatureAccessFactory;
import org.tecgraf.tdk.cache.CachingFeatureReader;
import org.tecgraf.tdk.cache.CachingFeatureSource;
import org.tecgraf.tdk.cache.CachingFeatureStore;
import org.tecgraf.tdk.cache.FeatureCacher;
import org.tecgraf.tdk.cache.SimpleCachingFeatureReader;
import org.tecgraf.tdk.cache.SimpleCachingFeatureSource;
import org.tecgraf.tdk.cache.SimpleCachingFeatureStore;
import org.tecgraf.tdk.cache.SimpleCachingFeatureWriter;
import org.tecgraf.tdk.cache.query.DefaultQueryAnalyzer;
import org.tecgraf.tdk.cache.query.QueryAnalyzer;

public class DefaultCachingFeatureAccessFactory
implements CachingFeatureAccessFactory<SimpleFeatureType, SimpleFeature> {
    private static Logger _logger = Logger.getLogger(DefaultCachingFeatureAccessFactory.class);

    @Override
    public FeatureCacher<SimpleFeatureType, SimpleFeature> createFeatureCacher(SimpleFeatureType schema) {
        _logger.debug((Object)("Building cacher for '" + schema.getTypeName() + "'"));
        return new BasicFeatureCacher(schema, this);
    }

    @Override
    public CachingFeatureSource<SimpleFeatureType, SimpleFeature> createFeatureSource(FeatureSource<SimpleFeatureType, SimpleFeature> featureSource, FeatureCacher<SimpleFeatureType, SimpleFeature> featureCacher) {
        return new SimpleCachingFeatureSource(featureSource, featureCacher);
    }

    @Override
    public CachingFeatureStore<SimpleFeatureType, SimpleFeature> createFeatureStore(FeatureStore<SimpleFeatureType, SimpleFeature> featureStore, FeatureCacher<SimpleFeatureType, SimpleFeature> featureCacher) {
        return new SimpleCachingFeatureStore(featureStore, featureCacher);
    }

    @Override
    public QueryAnalyzer createQueryAnalyzer(Query query) {
        return new DefaultQueryAnalyzer(query);
    }

    @Override
    public CachingFeatureReader<SimpleFeatureType, SimpleFeature> createFeatureReader(Query query, FeatureCacher<SimpleFeatureType, SimpleFeature> featureCacher) {
        return new SimpleCachingFeatureReader(query, featureCacher);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(FeatureWriter<SimpleFeatureType, SimpleFeature> wrappedFeatureWriter, FeatureCacher<SimpleFeatureType, SimpleFeature> featureCacher) {
        return new SimpleCachingFeatureWriter(wrappedFeatureWriter, featureCacher);
    }
}

