/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.tdk.cache;

import java.io.IOException;
import org.geotools.data.FeatureWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.tecgraf.tdk.cache.CachingFeatureWriter;
import org.tecgraf.tdk.cache.FeatureCacher;

public class SimpleCachingFeatureWriter
implements CachingFeatureWriter<SimpleFeatureType, SimpleFeature> {
    private FeatureWriter<SimpleFeatureType, SimpleFeature> _writer;
    private FeatureCacher<SimpleFeatureType, SimpleFeature> _cacher;
    private SimpleFeature _currentFeature;
    boolean _insert = false;

    public SimpleCachingFeatureWriter(FeatureWriter<SimpleFeatureType, SimpleFeature> writer, FeatureCacher<SimpleFeatureType, SimpleFeature> cacher) {
        if (writer == null) {
            throw new IllegalArgumentException("writer can't be null");
        }
        if (cacher == null) {
            throw new IllegalArgumentException("cacher can't be null");
        }
        this._writer = writer;
        this._cacher = cacher;
    }

    public void close() throws IOException {
        this._writer.close();
    }

    public SimpleFeatureType getFeatureType() {
        return (SimpleFeatureType)this._writer.getFeatureType();
    }

    public boolean hasNext() throws IOException {
        return this._writer.hasNext();
    }

    public SimpleFeature next() throws IOException {
        this._insert = !this.hasNext();
        this._currentFeature = (SimpleFeature)this._writer.next();
        return this._currentFeature;
    }

    public void remove() throws IOException {
        this._writer.remove();
        this._cacher.remove(this._currentFeature);
    }

    public void write() throws IOException {
        this._writer.write();
        if (this._insert) {
            this._cacher.add(this._currentFeature);
        } else {
            this._cacher.update(this._currentFeature);
        }
    }
}

