/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.tdk.cache.query;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.geometry.Geometry;
import org.tecgraf.tdk.cache.query.QueryAnalyzer;

public class DefaultQueryAnalyzer
implements QueryAnalyzer {
    private Query _query;

    public DefaultQueryAnalyzer(Query query) {
        this.setQuery(query);
    }

    @Override
    public Envelope getEnvelope() {
        Filter filter = this._query.getFilter();
        return this.getEnvelope(filter);
    }

    private Envelope getEnvelope(Filter filter) {
        BinarySpatialOperator gf;
        Envelope result = new Envelope();
        if (filter instanceof And) {
            ReferencedEnvelope bounds = new ReferencedEnvelope();
            for (Filter f : ((And)filter).getChildren()) {
                Envelope e = this.getEnvelope(f);
                bounds.expandToInclude(e);
            }
            result = bounds;
        } else if (filter instanceof BinarySpatialOperator && this.filterIsSupported(gf = (BinarySpatialOperator)filter)) {
            Expression lg = gf.getExpression1();
            Expression rg = gf.getExpression2();
            if (lg instanceof Literal) {
                Object value = ((Literal)lg).getValue();
                if (rg instanceof PropertyName) {
                    result = this.retrieveEnvelopeFromValue(value);
                }
            } else if (rg instanceof Literal) {
                Object value = ((Literal)rg).getValue();
                if (lg instanceof PropertyName) {
                    result = this.retrieveEnvelopeFromValue(value);
                }
            }
        }
        return result;
    }

    private Envelope retrieveEnvelopeFromValue(Object value) {
        if (value instanceof com.vividsolutions.jts.geom.Geometry) {
            com.vividsolutions.jts.geom.Geometry g = (com.vividsolutions.jts.geom.Geometry)value;
            return g.getEnvelopeInternal();
        }
        if (value instanceof Geometry) {
            Geometry g = (Geometry)value;
            return this.getEnvelope(g);
        }
        return new Envelope();
    }

    private Envelope getEnvelope(Geometry g) {
        org.opengis.geometry.Envelope envelope = g.getEnvelope();
        double x1 = envelope.getMinimum(0);
        double x2 = envelope.getMaximum(0);
        double y1 = envelope.getMinimum(1);
        double y2 = envelope.getMaximum(1);
        Envelope result = new Envelope(x1, x2, y1, y2);
        return result;
    }

    private boolean filterIsSupported(BinarySpatialOperator f) {
        return f instanceof BBOX || f instanceof Contains || f instanceof Crosses || f instanceof DWithin || f instanceof Equals || f instanceof Intersects || f instanceof Overlaps || f instanceof Touches || f instanceof Within;
    }

    @Override
    public Query getQuery() {
        return this._query;
    }

    @Override
    public Query getResidue(Query query) {
        if (this.isSubQuery(query)) {
            return new DefaultQuery(this._query.getTypeName(), (Filter)Filter.EXCLUDE);
        }
        return query;
    }

    @Override
    public boolean isSubQuery(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null");
        }
        if (query.equals(this._query)) {
            return true;
        }
        if (!query.getTypeName().equalsIgnoreCase(this._query.getTypeName())) {
            return false;
        }
        if (query.getFilter().equals(Filter.EXCLUDE)) {
            return true;
        }
        return this._query.getFilter().equals(Filter.INCLUDE);
    }

    @Override
    public void setQuery(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null");
        }
        this._query = query;
    }
}

