/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.tdk.data;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.tecgraf.tdk.cache.SimpleCachingDataStore;
import org.tecgraf.tdk.data.CachingType;

public abstract class AbstractDataStoreFactoryDecorator
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param CACHE_TYPE = new DataAccessFactory.Param("cache type", CachingType.class, "cache type", true, (Object)CachingType.SIMPLECACHING);
    protected static final String CACHED_SUFIX = " - cached";
    protected DataStoreFactorySpi _target;

    public AbstractDataStoreFactoryDecorator(DataStoreFactorySpi target) {
        if (target == null) {
            throw new IllegalArgumentException("target can't be null");
        }
        this._target = target;
    }

    public abstract DataStore createTargetDataStore(Map<String, Serializable> var1) throws IOException;

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("params should not be null.");
        }
        CachingType cacheType = this.getCachingType(params);
        if (cacheType == null) {
            throw new IllegalArgumentException("Could not find the caching type parameter for createDataStore.");
        }
        switch (this.getCachingType(params)) {
            case SIMPLECACHING: {
                return new SimpleCachingDataStore(this.createTargetDataStore(params));
            }
        }
        throw new UnsupportedOperationException("Your library version does not have suport for " + (Object)((Object)this.getCachingType(params)));
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean canProcess(Map<String, Serializable> params) {
        if (params == null) {
            throw new IllegalArgumentException("params should not be null.");
        }
        CachingType cachingType = this.getCachingType(params);
        if (cachingType == null) {
            return false;
        }
        return this._target.canProcess(params);
    }

    private CachingType getCachingType(Map<String, Serializable> params) {
        Serializable paramValue = params.get(AbstractDataStoreFactoryDecorator.CACHE_TYPE.key);
        CachingType cachingType = paramValue instanceof String ? CachingType.getCachingType((String)((Object)paramValue)) : (paramValue instanceof CachingType ? (CachingType)((Object)paramValue) : null);
        return cachingType;
    }

    public String getDescription() {
        return this._target.getDescription() + CACHED_SUFIX;
    }

    public String getDisplayName() {
        return this._target.getDisplayName() + CACHED_SUFIX;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        DataAccessFactory.Param[] targetParams = this._target.getParametersInfo();
        DataAccessFactory.Param[] params = new DataAccessFactory.Param[targetParams.length + 1];
        System.arraycopy(targetParams, 0, params, 0, targetParams.length);
        params[params.length - 1] = CACHE_TYPE;
        return params;
    }

    public boolean isAvailable() {
        return this._target.isAvailable();
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return this._target.getImplementationHints();
    }
}

