/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.text;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.iterator.RectIter;
import org.geotools.image.io.StreamImageWriter;

public abstract class TextImageWriter
extends StreamImageWriter {
    private static final int MAXIMUM_DIGITS = 12;
    private static final double NODIGITS_THRESHOLD = 1000000.0;
    private static final double DELTA_THRESHOLD = 0.1;
    private double maximum;
    private BufferedWriter writer;

    protected TextImageWriter(ImageWriterSpi provider) {
        super(provider);
    }

    protected Locale getDataLocale(ImageWriteParam parameters) {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).locale : null;
    }

    protected Charset getCharset(ImageWriteParam parameters) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).charset : null;
    }

    protected String getLineSeparator(ImageWriteParam parameters) {
        String lineSeparator;
        if (this.originatingProvider instanceof Spi && (lineSeparator = ((Spi)this.originatingProvider).lineSeparator) != null) {
            return lineSeparator;
        }
        return System.getProperty("line.separator", "\n");
    }

    protected BufferedWriter getWriter(ImageWriteParam parameters) throws IllegalStateException, IOException {
        if (this.writer == null) {
            Object output = this.getOutput();
            if (output instanceof BufferedWriter) {
                this.writer = (BufferedWriter)output;
                this.closeOnReset = null;
            } else if (output instanceof Writer) {
                this.writer = new BufferedWriter((Writer)output);
                this.closeOnReset = null;
            } else {
                OutputStream stream = this.getOutputStream();
                Charset charset = this.getCharset(parameters);
                this.writer = new BufferedWriter(charset != null ? new OutputStreamWriter(stream, charset) : new OutputStreamWriter(stream));
                if (this.closeOnReset == stream) {
                    this.closeOnReset = this.writer;
                }
            }
        }
        return this.writer;
    }

    protected strictfp NumberFormat createNumberFormat(IIOImage image, ImageWriteParam parameters) {
        NumberFormat format;
        int type;
        Locale locale = this.getDataLocale(parameters);
        int n = type = image.hasRaster() ? image.getRaster().getTransferType() : image.getRenderedImage().getSampleModel().getDataType();
        if (type != 4 && type != 5) {
            this.maximum = 32767.0;
            return locale != null ? NumberFormat.getIntegerInstance(locale) : NumberFormat.getIntegerInstance();
        }
        int digits = 0;
        double multiple = 1.0;
        this.maximum = Double.NEGATIVE_INFINITY;
        RectIter iterator = TextImageWriter.createRectIter(image, parameters);
        if (!iterator.finishedBands()) {
            do {
                if (!iterator.finishedLines()) {
                    do {
                        if (!iterator.finishedPixels()) {
                            block2: do {
                                double value;
                                if (Double.isInfinite(value = Math.abs(iterator.getSampleDouble()))) continue;
                                if (value > this.maximum) {
                                    this.maximum = value;
                                }
                                while (true) {
                                    double scaled = value * multiple;
                                    if (type == 4) {
                                        scaled = (float)scaled;
                                    }
                                    if (!(StrictMath.abs(scaled - StrictMath.rint(scaled)) >= 0.1)) continue block2;
                                    if (++digits > 12) {
                                        return NumberFormat.getNumberInstance(locale);
                                    }
                                    multiple *= 10.0;
                                }
                            } while (!iterator.nextPixelDone());
                        }
                        iterator.startPixels();
                    } while (!iterator.nextLineDone());
                }
                iterator.startLines();
            } while (!iterator.nextBandDone());
        }
        NumberFormat numberFormat = format = locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance();
        if (digits != 0 || this.maximum >= 0.1) {
            format.setMaximumFractionDigits(digits);
            if (this.maximum < 1000000.0) {
                format.setMinimumFractionDigits(digits);
            }
        }
        return format;
    }

    protected FieldPosition getExpectedFractionPosition(NumberFormat format) {
        int width = Math.max((int)Math.floor(Math.log10(this.maximum)) + 1, format.getMinimumIntegerDigits());
        int digits = Math.min(format.getMaximumFractionDigits(), 12);
        if (format instanceof DecimalFormat) {
            DecimalFormat decimal = (DecimalFormat)format;
            if (digits > 0 || decimal.isDecimalSeparatorAlwaysShown()) {
                ++width;
            }
            width += Math.max(decimal.getNegativePrefix().length(), decimal.getPositivePrefix().length());
            digits += Math.max(decimal.getNegativeSuffix().length(), decimal.getPositiveSuffix().length());
        }
        FieldPosition position = new FieldPosition(1);
        position.setBeginIndex(width);
        position.setEndIndex(width += digits);
        return position;
    }

    protected void close() throws IOException {
        this.writer = null;
        super.close();
    }

    public static abstract class Spi
    extends StreamImageWriter.Spi {
        private static final Class[] INPUT_TYPES = new Class[]{File.class, URL.class, URLConnection.class, Writer.class, OutputStream.class, ImageOutputStream.class, String.class};
        private static final String[] EXTENSIONS = new String[]{"txt", "TXT", "asc", "ASC", "dat", "DAT"};
        protected Charset charset;
        protected Locale locale;
        protected String lineSeparator;

        public Spi() {
            this.outputTypes = INPUT_TYPES;
            this.suffixes = EXTENSIONS;
        }
    }
}

