/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.utils.coveragetiler;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.utils.progress.BaseArgumentsManager;
import org.geotools.utils.progress.ExceptionEvent;
import org.geotools.utils.progress.ProcessingEvent;
import org.geotools.utils.progress.ProcessingEventListener;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class CoverageTiler
extends BaseArgumentsManager
implements ProcessingEventListener,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(CoverageTiler.class.toString());
    private static final String VERSION = "0.3";
    private static final String NAME = "CoverageTiler";
    private Option inputLocationOpt = this.optionBuilder.withShortName("s").withLongName("src_coverage").withArgument(this.argumentBuilder.withName("source").withMinimum(1).withMaximum(1).create()).withDescription("path where the source code is located").withRequired(true).create();
    private Option outputLocationOpt = this.optionBuilder.withShortName("d").withLongName("dest_directory").withArgument(this.argumentBuilder.withName("destination").withMinimum(0).withMaximum(1).create()).withDescription("output directory, if none is provided, the \"tiled\" directory will be used").withRequired(false).create();
    private Option tileDimOpt = this.optionBuilder.withShortName("t").withLongName("tile_dimension").withArgument(this.argumentBuilder.withName("t").withMinimum(1).withMaximum(1).create()).withDescription("Width and height of each tile we generate").withRequired(true).create();
    private Option compressionTypeOpt;
    private Option compressionRatioOpt;
    private Option internalTileDimOpt = this.optionBuilder.withShortName("it").withLongName("internal_tile_dimension").withArgument(this.argumentBuilder.withName("it").withMinimum(0).withMaximum(1).create()).withDescription("Internal width and height of each tile we generate").withRequired(false).create();
    private File inputLocation;
    private File outputLocation;
    private int tileWidth;
    private int tileHeight;
    private int internalTileWidth = 512;
    private int internalTileHeight = 512;
    private String compressionScheme = "LZW";
    private double compressionRatio = 0.75;

    public CoverageTiler() {
        super(NAME, VERSION);
        this.compressionTypeOpt = this.optionBuilder.withShortName("z").withLongName("compressionType").withDescription("compression type.").withArgument(this.argumentBuilder.withName("compressionType").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
            }
        }).create()).withRequired(false).create();
        this.compressionRatioOpt = this.optionBuilder.withShortName("r").withLongName("compressionRatio").withDescription("compression ratio.").withArgument(this.argumentBuilder.withName("compressionRatio").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                String val = (String)args.get(0);
                double value = Double.parseDouble(val);
                if (value <= 0.0 || value > 1.0) {
                    throw new InvalidArgumentException("Invalid compressio ratio");
                }
            }
        }).create()).withRequired(false).create();
        this.addOption(this.tileDimOpt);
        this.addOption(this.inputLocationOpt);
        this.addOption(this.outputLocationOpt);
        this.addOption(this.internalTileDimOpt);
        this.addOption(this.compressionTypeOpt);
        this.addOption(this.compressionRatioOpt);
        this.finishInitialization();
    }

    public static void main(String[] args) throws MalformedURLException, InterruptedException {
        CoverageTiler coverageTiler = new CoverageTiler();
        coverageTiler.addProcessingEventListener(coverageTiler);
        if (coverageTiler.parseArgs(args)) {
            Thread t = new Thread((Runnable)coverageTiler, NAME);
            t.setPriority(coverageTiler.getPriority());
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else {
            LOGGER.fine("Exiting...");
        }
    }

    public void getNotification(ProcessingEvent event) {
        LOGGER.info("Progress is at " + event.getPercentage() + "\n" + "attached message is: " + event.getMessage());
    }

    public void exceptionOccurred(ExceptionEvent event) {
        LOGGER.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    public void run() {
        GridCoverage2D gc;
        StringBuilder message = new StringBuilder("Acquiring a reader to  ").append(this.inputLocation);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)this.inputLocation);
        if (format == null || format instanceof UnknownFormat) {
            this.fireException("Unable to decide format for this coverage", 0.0, new IOException("Could not find a format for this coverage"));
            return;
        }
        AbstractGridCoverage2DReader inReader = format.getReader((Object)this.inputLocation, new Hints((RenderingHints.Key)Hints.OVERVIEW_POLICY, (Object)OverviewPolicy.IGNORE));
        if (inReader == null) {
            message = new StringBuilder("Unable to instantiate a reader for this coverage");
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.fine(message.toString());
            }
            this.fireEvent(message.toString(), 0.0);
            return;
        }
        if (!this.outputLocation.exists()) {
            this.outputLocation.mkdir();
        }
        GeneralEnvelope envelope = inReader.getOriginalEnvelope();
        message = new StringBuilder("Original envelope is ").append(envelope.toString());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        GridEnvelope range = inReader.getOriginalGridRange();
        int w = range.getSpan(0);
        int h = range.getSpan(1);
        this.tileWidth = this.tileWidth > w ? w : this.tileWidth;
        this.tileHeight = this.tileHeight > h ? h : this.tileHeight;
        message = new StringBuilder("Original range is ").append(range.toString());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        message = new StringBuilder("New matrix dimension is (cols,rows)==(").append(this.tileWidth).append(",").append(this.tileHeight).append(")");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 0.0);
        try {
            gc = inReader.read(null);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            this.fireException(e);
            return;
        }
        int numTileX = (int)((double)w / ((double)this.tileWidth * 1.0) + 1.0);
        int numTileY = (int)((double)h / ((double)this.tileHeight * 1.0) + 1.0);
        int i = 0;
        while (i < numTileX) {
            int j = 0;
            while (j < numTileY) {
                Rectangle sourceRegion = new Rectangle(i * this.tileWidth, j * this.tileHeight, this.tileWidth, this.tileHeight);
                message = new StringBuilder("Writing region  ").append(sourceRegion);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)(i + j) / ((double)(numTileX * numTileY) * 1.0));
                File fileOut = new File(this.outputLocation, "mosaic" + "_" + Integer.toString(i * this.tileWidth + j) + "." + "tiff");
                if (fileOut.exists()) {
                    fileOut.delete();
                }
                message = new StringBuilder("Preparing to write tile (col,row)==(").append(j).append(",").append(i).append(") to file ").append(fileOut);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)(i + j) / ((double)(numTileX * numTileY) * 1.0));
                GeoTiffFormat outFormat = new GeoTiffFormat();
                try {
                    GeoTiffWriteParams wp = new GeoTiffWriteParams();
                    wp.setTilingMode(2);
                    wp.setTiling(this.internalTileWidth, this.internalTileHeight);
                    wp.setSourceRegion(sourceRegion);
                    if (this.compressionScheme != null && !Double.isNaN(this.compressionRatio)) {
                        wp.setCompressionMode(2);
                        wp.setCompressionType(this.compressionScheme);
                        wp.setCompressionQuality((float)this.compressionRatio);
                    }
                    ParameterValueGroup params = outFormat.getWriteParameters();
                    params.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
                    GeoTiffWriter writerWI = new GeoTiffWriter((Object)fileOut);
                    writerWI.write((GridCoverage)gc, params.values().toArray(new GeneralParameterValue[1]));
                    writerWI.dispose();
                }
                catch (IOException e) {
                    this.fireException(e);
                    return;
                }
                ++j;
            }
            ++i;
        }
        message = new StringBuilder("Done...");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message.toString());
        }
        this.fireEvent(message.toString(), 100.0);
    }

    public boolean parseArgs(String[] args) {
        if (!super.parseArgs(args)) {
            return false;
        }
        this.inputLocation = new File((String)this.getOptionValue(this.inputLocationOpt));
        this.outputLocation = this.hasOption(this.outputLocationOpt) ? new File((String)this.getOptionValue(this.outputLocationOpt)) : new File(this.inputLocation.getParentFile(), "tiled");
        String tileDim = (String)this.getOptionValue(this.tileDimOpt);
        String[] pairs = tileDim.split(",");
        this.tileWidth = Integer.parseInt(pairs[0]);
        this.tileHeight = Integer.parseInt(pairs[1]);
        String internalTileDim = (String)this.getOptionValue(this.internalTileDimOpt);
        if (internalTileDim != null && internalTileDim.length() > 0) {
            pairs = internalTileDim.split(",");
            this.internalTileWidth = Integer.parseInt(pairs[0]);
            this.internalTileHeight = Integer.parseInt(pairs[1]);
        }
        if (this.hasOption(this.compressionTypeOpt)) {
            this.compressionScheme = (String)this.getOptionValue(this.compressionTypeOpt);
            if (this.compressionScheme == "") {
                this.compressionScheme = null;
            }
        }
        if (this.hasOption(this.compressionRatioOpt)) {
            try {
                this.compressionRatio = Double.parseDouble((String)this.getOptionValue(this.compressionRatioOpt));
            }
            catch (Exception e) {
                this.compressionRatio = Double.NaN;
            }
        }
        return true;
    }

    public File getInputLocation() {
        return this.inputLocation;
    }

    public void setInputLocation(File inputLocation) {
        this.inputLocation = inputLocation;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int numTileX) {
        this.tileWidth = numTileX;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(int numTileY) {
        this.tileHeight = numTileY;
    }

    public File getOutputLocation() {
        return this.outputLocation;
    }

    public void setOutputLocation(File outputLocation) {
        this.outputLocation = outputLocation;
    }

    public final double getCompressionRatio() {
        return this.compressionRatio;
    }

    public final void setCompressionRatio(double compressionRatio) {
        this.compressionRatio = compressionRatio;
    }

    public final String getCompressionScheme() {
        return this.compressionScheme;
    }

    public final void setCompressionScheme(String compressionScheme) {
        this.compressionScheme = compressionScheme;
    }

    public int getInternalTileHeight() {
        return this.internalTileHeight;
    }

    public void setInternalTileHeight(int internalTileHeight) {
        this.internalTileHeight = internalTileHeight;
    }

    public int getInternalTileWidth() {
        return this.internalTileWidth;
    }

    public void setInternalTileWidth(int internalTileWidth) {
        this.internalTileWidth = internalTileWidth;
    }
}

