/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.utils.imagemosaic;

import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli2.Option;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.geotools.data.DataSourceException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.resources.CRSUtilities;
import org.geotools.util.logging.Logging;
import org.geotools.utils.progress.BaseArgumentsManager;
import org.geotools.utils.progress.ExceptionEvent;
import org.geotools.utils.progress.ProcessingEvent;
import org.geotools.utils.progress.ProcessingEventListener;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MosaicIndexBuilder
extends BaseArgumentsManager
implements Runnable,
ProcessingEventListener {
    private static final Logger LOGGER = Logging.getLogger((String)"it.geosolutions.utils.imagemosaic");
    private static final String VERSION = "0.3";
    private static final String NAME = "MosaicIndexBuilder";
    private final Option locationOpt = this.optionBuilder.withShortName("s").withLongName("source_directory").withArgument(this.argumentBuilder.withName("source").withMinimum(1).withMaximum(1).create()).withDescription("path where files are located").withRequired(true).create();
    private final Option nameOpt;
    private final Option relativePathOpt;
    private final Option wildcardOpt = this.optionBuilder.withShortName("w").withLongName("wildcardOpt").withArgument(this.argumentBuilder.withName("wildcardOpt").withMinimum(0).withMaximum(1).create()).withDescription("wildcardOpt to use for selecting files").withRequired(false).create();
    private String locationPath;
    private int numberOfLevels;
    private double[][] resolutionLevels;
    private int numFiles;
    private String wildcardString = "*.*";
    private String indexName = "index";
    private boolean mustConvertToRGB = false;
    private ColorModel actualCM = null;
    private ColorModel defaultCM = null;
    private SampleModel defaultSM = null;
    private SampleModel actualSM = null;
    private GeneralEnvelope globEnvelope = null;
    private GeneralEnvelope envelope = null;
    private byte[][] defaultPalette = null;
    private CoordinateReferenceSystem defaultCRS = null;
    private CoordinateReferenceSystem actualCRS = null;
    private boolean absolute = false;

    private void recurse(List<File> allFiles, String locationPath) {
        File dir = new File(locationPath);
        WildcardFileFilter fileFilter = new WildcardFileFilter(this.wildcardString);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        File[] dirs = dir.listFiles((FileFilter)DirectoryFileFilter.INSTANCE);
        int i = 0;
        while (i < files.length) {
            allFiles.add(files[i]);
            ++i;
        }
        i = 0;
        while (i < dirs.length) {
            this.recurse(allFiles, locationPath + '/' + dirs[i].getName());
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [45[WHILELOOP]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createPropertiesFiles(GeneralEnvelope globEnvelope, boolean doneSomething) {
        if (this.numFiles > 0 && doneSomething) {
            StringBuffer message;
            block26: {
                message = new StringBuffer("Creating final properties file ");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), 99.9);
                Properties properties = new Properties();
                properties.setProperty("AbsolutePath", Boolean.toString(this.absolute));
                properties.setProperty("NumFiles", Integer.toString(this.numFiles));
                properties.setProperty("Envelope2D", new StringBuffer(Double.toString(globEnvelope.getMinimum(0))).append(",").append(Double.toString(globEnvelope.getMinimum(1))).append(" ").append(Double.toString(globEnvelope.getMaximum(0))).append(",").append(Double.toString(globEnvelope.getMaximum(1))).toString());
                properties.setProperty("LevelsNum", Integer.toString(this.numberOfLevels));
                StringBuffer levels = new StringBuffer();
                int k = 0;
                while (k < this.numberOfLevels) {
                    levels.append(Double.toString(this.resolutionLevels[0][k])).append(",").append(Double.toString(this.resolutionLevels[1][k]));
                    if (k < this.numberOfLevels - 1) {
                        levels.append(" ");
                    }
                    ++k;
                }
                properties.setProperty("Levels", levels.toString());
                properties.setProperty("Name", this.indexName);
                properties.setProperty("ExpandToRGB", Boolean.toString(this.mustConvertToRGB));
                OutputStream outStream = null;
                try {
                    outStream = new BufferedOutputStream(new FileOutputStream(String.valueOf(this.locationPath) + "/" + this.indexName + ".properties"));
                    properties.store(outStream, "");
                }
                catch (FileNotFoundException e) {
                    this.fireEvent(e.getLocalizedMessage(), 0.0);
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                        break block26;
                    }
                    catch (Throwable e2) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                        }
                        break block26;
                    }
                }
                catch (IOException e) {
                    try {
                        this.fireEvent(e.getLocalizedMessage(), 0.0);
                        break block26;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block27: {
                            try {
                                if (outStream != null) {
                                    outStream.close();
                                }
                            }
                            catch (Throwable e3) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block27;
                                LOGGER.log(Level.FINE, e3.getLocalizedMessage(), e3);
                            }
                        }
                    }
                }
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block26;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
            message = new StringBuffer("Done!!!");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(message.toString());
            }
            this.fireEvent(message.toString(), 100.0);
        } else {
            StringBuffer message = new StringBuffer("No file to process!!!");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(message.toString());
            }
            this.fireEvent(message.toString(), 100.0);
        }
    }

    private boolean checkColorModels(ColorModel defaultCM, byte[][] defaultPalette, ColorModel actualCM) {
        if (defaultCM instanceof ComponentColorModel && actualCM instanceof ComponentColorModel) {
            ComponentColorModel defCCM = (ComponentColorModel)defaultCM;
            ComponentColorModel actualCCM = (ComponentColorModel)actualCM;
            return defCCM.getNumColorComponents() != actualCCM.getNumColorComponents() || defCCM.hasAlpha() != actualCCM.hasAlpha() || !defCCM.getColorSpace().equals(actualCCM.getColorSpace()) || defCCM.getTransparency() != actualCCM.getTransparency() || defCCM.getTransferType() != actualCCM.getTransferType();
        }
        if (defaultCM instanceof IndexColorModel && actualCM instanceof IndexColorModel) {
            IndexColorModel defICM = (IndexColorModel)defaultCM;
            IndexColorModel actualICM = (IndexColorModel)actualCM;
            if (defICM.getNumColorComponents() != actualICM.getNumColorComponents() || defICM.hasAlpha() != actualICM.hasAlpha() || !defICM.getColorSpace().equals(actualICM.getColorSpace()) || defICM.getTransferType() != actualICM.getTransferType()) {
                return true;
            }
            if (defICM.getMapSize() != actualICM.getMapSize() || defICM.getTransparency() != actualICM.getTransparency() || defICM.getTransferType() != actualICM.getTransferType() || defICM.getTransparentPixel() != actualICM.getTransparentPixel()) {
                this.mustConvertToRGB = true;
                return false;
            }
            int numBands = actualICM.getNumColorComponents();
            byte[][] actualPalette = new byte[3][actualICM.getMapSize()];
            actualICM.getReds(actualPalette[0]);
            actualICM.getGreens(actualPalette[0]);
            actualICM.getBlues(actualPalette[0]);
            if (numBands == 4) {
                actualICM.getAlphas(defaultPalette[0]);
            }
            int i = 0;
            while (i < defICM.getMapSize()) {
                int j = 0;
                while (j < numBands) {
                    if (actualPalette[j][i] != defaultPalette[j][i]) {
                        this.mustConvertToRGB = true;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public MosaicIndexBuilder() {
        super(NAME, VERSION);
        this.nameOpt = this.optionBuilder.withShortName("name").withLongName("index_name").withArgument(this.argumentBuilder.withName("name").withMinimum(0).withMaximum(1).create()).withDescription("name for the index file").withRequired(false).create();
        this.relativePathOpt = this.optionBuilder.withShortName("abs").withLongName("absolute_path").withDescription("whether or not paths shuld be absolute").withRequired(false).create();
        this.addOption(this.locationOpt);
        this.addOption(this.wildcardOpt);
        this.addOption(this.nameOpt);
        this.addOption(this.relativePathOpt);
        this.finishInitialization();
    }

    public static void main(String[] args) {
        MosaicIndexBuilder mosaicIndexBuilder = new MosaicIndexBuilder();
        mosaicIndexBuilder.addProcessingEventListener(mosaicIndexBuilder);
        if (mosaicIndexBuilder.parseArgs(args)) {
            Thread t = new Thread((Runnable)mosaicIndexBuilder, NAME);
            t.setPriority(mosaicIndexBuilder.getPriority());
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else {
            LOGGER.fine("Exiting...");
        }
    }

    @Override
    public boolean parseArgs(String[] args) {
        if (!super.parseArgs(args)) {
            return false;
        }
        this.locationPath = (String)this.getOptionValue(this.locationOpt);
        File inDir = new File(this.locationPath);
        if (!inDir.isDirectory()) {
            LOGGER.severe("Provided input dir does not exist or is not a dir!");
            return false;
        }
        try {
            this.locationPath = inDir.getCanonicalPath();
            this.locationPath = this.locationPath.replace('\\', '/');
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return false;
        }
        if (this.hasOption(this.wildcardOpt)) {
            this.wildcardString = (String)this.getOptionValue(this.wildcardOpt);
        }
        if (this.hasOption(this.nameOpt)) {
            this.indexName = (String)this.getOptionValue(this.nameOpt);
        }
        if (this.hasOption(this.relativePathOpt)) {
            this.absolute = true;
        }
        return true;
    }

    protected final double[] getResolution(GeneralEnvelope envelope, Rectangle2D dim, CoordinateReferenceSystem crs) throws DataSourceException {
        double[] requestedRes = null;
        try {
            if (dim != null && envelope != null) {
                MathTransform tr;
                CoordinateReferenceSystem crs2D = CRSUtilities.getCRS2D((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem());
                if (crs != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)crs2D) && !(tr = CRS.findMathTransform((CoordinateReferenceSystem)crs2D, (CoordinateReferenceSystem)crs)).isIdentity()) {
                    envelope = CRS.transform((MathTransform)tr, (Envelope)envelope);
                }
                requestedRes = new double[]{envelope.getLength(0) / dim.getWidth(), envelope.getLength(1) / dim.getHeight()};
            }
            return requestedRes;
        }
        catch (TransformException e) {
            throw new DataSourceException("Unable to get the resolution", (Throwable)e);
        }
        catch (FactoryException e) {
            throw new DataSourceException("Unable to get the resolution", (Throwable)e);
        }
    }

    @Override
    public void getNotification(ProcessingEvent event) {
        LOGGER.info(new StringBuffer("Progress is at ").append(event.getPercentage()).append("\n").append("attached message is: ").append(event.getMessage()).toString());
    }

    @Override
    public void exceptionOccurred(ExceptionEvent event) {
        LOGGER.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    public final void setLocationPath(String locationPath) {
        this.locationPath = locationPath;
        File inDir = new File(locationPath);
        if (!inDir.isDirectory()) {
            LOGGER.severe("Provided input dir does not exist or is not a dir!");
            throw new IllegalArgumentException("Provided input dir does not exist or is not a dir!");
        }
        try {
            locationPath = inDir.getCanonicalPath();
            locationPath = locationPath.replace('\\', '/');
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public final void setWildcardString(String wildcardString) {
        this.wildcardString = wildcardString;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public double getResolutionX() {
        return this.resolutionLevels[0][0];
    }

    public double getResolutionY() {
        return this.resolutionLevels[1][0];
    }
}

