/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.utils.imageoverviews;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriter;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.geotools.image.io.ImageIOExt;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;
import org.geotools.utils.CoverageToolsConstants;
import org.geotools.utils.WriteProgressListenerAdapter;
import org.geotools.utils.progress.BaseArgumentsManager;
import org.geotools.utils.progress.ExceptionEvent;
import org.geotools.utils.progress.ProcessingEvent;
import org.geotools.utils.progress.ProcessingEventListener;

public class OverviewsEmbedder
extends BaseArgumentsManager
implements Runnable,
ProcessingEventListener {
    private final OverviewsEmbedderWriteProgressListener writeProgressListener = new OverviewsEmbedderWriteProgressListener();
    private static final String NAME = "OverviewsEmbedder";
    private static final String VERSION = "0.3";
    private Option locationOpt;
    private Option tileDimOpt;
    private Option scaleAlgorithmOpt;
    private Option wildcardOpt;
    private Option numStepsOpt;
    private Option scaleFactorOpt;
    private Option compressionRatioOpt;
    private Option compressionTypeOpt;
    private int tileW = -1;
    private int tileH = -1;
    private String scaleAlgorithm;
    private static final Logger LOGGER = Logging.getLogger((String)OverviewsEmbedder.class.toString());
    private BorderExtender borderExtender = CoverageToolsConstants.DEFAULT_BORDER_EXTENDER;
    private int downsampleStep;
    private float[] lowPassFilter = CoverageToolsConstants.DEFAULT_KERNEL_GAUSSIAN;
    private String sourcePath;
    private String compressionScheme = null;
    private double compressionRatio = 0.75;
    private int numSteps;
    private String wildcardString = "*.*";
    private int fileBeingProcessed;
    private int overviewInProcess;

    public OverviewsEmbedder() {
        super(NAME, VERSION);
        this.locationOpt = this.optionBuilder.withShortName("s").withLongName("source").withArgument(this.argumentBuilder.withName("source").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Source can be a single file or  directory ");
                }
                File source = new File((String)args.get(0));
                if (!source.exists()) {
                    throw new InvalidArgumentException("The provided source is invalid! ");
                }
            }
        }).create()).withDescription("path where files are located").withRequired(true).create();
        this.tileDimOpt = this.optionBuilder.withShortName("t").withLongName("tiled_dimension").withArgument(this.argumentBuilder.withName("t").withMinimum(0).withMaximum(1).create()).withDescription("tile dimensions as a couple width,height in pixels").withRequired(false).create();
        this.scaleFactorOpt = this.optionBuilder.withShortName("f").withLongName("scale_factor").withArgument(this.argumentBuilder.withName("f").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scale factor at a time can be chosen");
                }
                int factor = Integer.parseInt((String)args.get(0));
                if (factor <= 0) {
                    throw new InvalidArgumentException("The provided scale factor is negative! ");
                }
                if (factor == 1) {
                    LOGGER.warning("The scale factor is 1, program will exit!");
                    System.exit(0);
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.wildcardOpt = this.optionBuilder.withShortName("w").withLongName("wildcardOpt").withArgument(this.argumentBuilder.withName("wildcardOpt").withMinimum(0).withMaximum(1).create()).withDescription("wildcardOpt to use for selecting files").withRequired(false).create();
        this.numStepsOpt = this.optionBuilder.withShortName("n").withLongName("num_steps").withArgument(this.argumentBuilder.withName("n").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one  number of step at a time can be chosen");
                }
                int steps = Integer.parseInt((String)args.get(0));
                if (steps <= 0) {
                    throw new InvalidArgumentException("The provided number of step is negative! ");
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.scaleAlgorithmOpt = this.optionBuilder.withShortName("a").withLongName("scaling_algorithm").withArgument(this.argumentBuilder.withName("a").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                SubsampleAlgorithm algorithm = SubsampleAlgorithm.valueOf((String)args.get(0));
                if (algorithm != null) {
                    throw new InvalidArgumentException("The scaling algorithm " + args.get(0) + " is not supported");
                }
            }
        }).create()).withDescription("name of the scaling algorithm, eeither one of average (a), filtered\t (f), bilinear (bil), nearest neigbhor (nn)").withRequired(false).create();
        this.compressionTypeOpt = this.optionBuilder.withShortName("z").withLongName("compressionType").withDescription("compression type.").withArgument(this.argumentBuilder.withName("compressionType").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
            }
        }).create()).withRequired(false).create();
        this.compressionRatioOpt = this.optionBuilder.withShortName("r").withLongName("compressionRatio").withDescription("compression ratio.").withArgument(this.argumentBuilder.withName("compressionRatio").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                String val = (String)args.get(0);
                double value = Double.parseDouble(val);
                if (value <= 0.0 || value > 1.0) {
                    throw new InvalidArgumentException("Invalid compressio ratio");
                }
            }
        }).create()).withRequired(false).create();
        this.addOption(this.locationOpt);
        this.addOption(this.tileDimOpt);
        this.addOption(this.scaleFactorOpt);
        this.addOption(this.scaleAlgorithmOpt);
        this.addOption(this.numStepsOpt);
        this.addOption(this.wildcardOpt);
        this.addOption(this.compressionTypeOpt);
        this.addOption(this.compressionRatioOpt);
        this.finishInitialization();
    }

    private static ImageLayout createTiledLayout(int tileWidth, int tileHeight, int tileGrdiOffseX, int tileGrdiOffseY) {
        ImageLayout layout = new ImageLayout();
        layout.setTileGridXOffset(tileGrdiOffseX);
        layout.setTileGridYOffset(tileGrdiOffseY);
        layout.setValid(16);
        layout.setValid(32);
        layout.setTileWidth(tileWidth);
        layout.setTileHeight(tileHeight);
        layout.setValid(128);
        layout.setValid(64);
        return layout;
    }

    private RenderedOp subsample(RenderedOp src, TileCache scaleTC, Interpolation interpolation) {
        RenderingHints newHints = new RenderingHints(JAI.KEY_TILE_CACHE, scaleTC);
        newHints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        newHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, this.borderExtender));
        ParameterBlockJAI pb = new ParameterBlockJAI("filteredsubsample");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Integer(this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Integer(this.downsampleStep));
        pb.setParameter("qsFilterArray", (Object)new float[]{1.0f});
        pb.setParameter("Interpolation", (Object)interpolation);
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb, (RenderingHints)newHints);
    }

    public int getDownsampleStep() {
        return this.downsampleStep;
    }

    public void setDownsampleStep(int downsampleWH) {
        this.downsampleStep = downsampleWH;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public int getTileHeight() {
        return this.tileH;
    }

    public void setTileHeight(int tileHeight) {
        this.tileH = tileHeight;
    }

    public int getTileWidth() {
        return this.tileW;
    }

    public void setTileWidth(int tileWidth) {
        this.tileW = tileWidth;
    }

    private RenderedOp filteredSubsample(RenderedImage src, TileCache scaleTC) {
        RenderingHints newHints = new RenderingHints(JAI.KEY_TILE_CACHE, scaleTC);
        newHints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        ParameterBlockJAI pb = new ParameterBlockJAI("filteredsubsample");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Integer(this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Integer(this.downsampleStep));
        pb.setParameter("qsFilterArray", (Object)this.lowPassFilter);
        pb.setParameter("Interpolation", (Object)new InterpolationNearest());
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb, (RenderingHints)newHints);
    }

    private RenderedOp scaleAverage(RenderedImage src, TileCache scaleTC) {
        RenderingHints newHints = new RenderingHints(JAI.KEY_TILE_CACHE, scaleTC);
        newHints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        newHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, this.borderExtender));
        ParameterBlockJAI pb = new ParameterBlockJAI("SubsampleAverage");
        pb.addSource((Object)src);
        pb.setParameter("scaleX", (Object)new Double(1.0 / (double)this.downsampleStep));
        pb.setParameter("scaleY", (Object)new Double(1.0 / (double)this.downsampleStep));
        return JAI.create((String)"SubsampleAverage", (ParameterBlock)pb, (RenderingHints)newHints);
    }

    public void setBorderExtender(BorderExtender borderExtender) {
        this.borderExtender = borderExtender;
    }

    public float[] getLowPassFilter() {
        return this.lowPassFilter;
    }

    public void setLowPassFilter(float[] lowPassFilter) {
        this.lowPassFilter = lowPassFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.sourcePath == null) {
            this.fireEvent("Provided sourcePath is null", 0.0);
            return;
        }
        file = new File(this.sourcePath);
        numFiles = 1;
        if (!file.canRead() || !file.exists()) {
            this.fireEvent("Provided file " + file.getAbsolutePath() + " cannot be read or does not exist", 0.0);
            return;
        }
        if (file.isDirectory()) {
            if (this.wildcardString == null) {
                this.fireEvent("Provided wildcardString is null", 0.0);
                return;
            }
            fileFilter = new WildcardFileFilter(this.wildcardString);
            files = file.listFiles((FileFilter)fileFilter);
            numFiles = files.length;
            if (numFiles <= 0) {
                message = new StringBuilder("No files to process!");
                if (OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) {
                    OverviewsEmbedder.LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), 100.0);
            }
        } else {
            files = new File[]{file};
        }
        if (files == null || files.length == 0) {
            this.fireEvent("Unable to find input files for the provided wildcard " + this.wildcardString + " and input path " + this.sourcePath, 0.0);
            return;
        }
        this.fileBeingProcessed = 0;
        while (this.fileBeingProcessed < numFiles) {
            block180: {
                message = new StringBuilder("Managing file  ").append(this.fileBeingProcessed).append(" of ").append(files[this.fileBeingProcessed]).append(" files");
                if (OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) {
                    OverviewsEmbedder.LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                if (this.getStopThread()) {
                    message = new StringBuilder("Stopping requested at file  ").append(this.fileBeingProcessed).append(" of ").append(numFiles).append(" files");
                    if (OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) {
                        OverviewsEmbedder.LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    return;
                }
                stream = null;
                writer = null;
                streamOut = null;
                baseTC = null;
                scaleTC = null;
                currentImage = null;
                newImage = null;
                try {
                    block233: {
                        block232: {
                            block231: {
                                block230: {
                                    block229: {
                                        block228: {
                                            stream = ImageIO.createImageInputStream(files[this.fileBeingProcessed]);
                                            if (stream != null) break block228;
                                            message = new StringBuilder("Unable to create an input stream for file").append(files[this.fileBeingProcessed]);
                                            if (OverviewsEmbedder.LOGGER.isLoggable(Level.SEVERE)) {
                                                OverviewsEmbedder.LOGGER.severe(message.toString());
                                            }
                                            this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                                            var27_26 = null;
                                            if (baseTC == null) ** GOTO lbl332
                                            ** GOTO lbl327
                                        }
                                        stream.mark();
                                        it = ImageIO.getImageReaders(stream);
                                        if (it.hasNext()) break block229;
                                        message = new StringBuilder("Unable to find a reader for file").append(files[this.fileBeingProcessed]);
                                        if (OverviewsEmbedder.LOGGER.isLoggable(Level.SEVERE)) {
                                            OverviewsEmbedder.LOGGER.severe(message.toString());
                                        }
                                        this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                                        ** GOTO lbl381
                                    }
                                    reader = it.next();
                                    stream.reset();
                                    stream.mark();
                                    if (reader.getFormatName().toLowerCase().startsWith("tif")) break block230;
                                    if (OverviewsEmbedder.LOGGER.isLoggable(Level.INFO)) {
                                        OverviewsEmbedder.LOGGER.info("Discarding input file " + files[this.fileBeingProcessed] + " since it is not a proper tif file.");
                                    }
                                    ** GOTO lbl437
                                }
                                reader.setInput(stream);
                                layout = null;
                                actualTileW = reader.getTileWidth(0);
                                actualTileH = reader.getTileHeight(0);
                                numImages = reader.getNumImages(true);
                                if (!reader.isImageTiled(0) || reader.isImageTiled(0) && actualTileH != this.tileH && this.tileH != -1 || actualTileW != this.tileW && this.tileW != -1) {
                                    message = new StringBuilder("Retiling image  ").append(this.fileBeingProcessed);
                                    if (OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) {
                                        OverviewsEmbedder.LOGGER.fine(message.toString());
                                    }
                                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                                    layout = OverviewsEmbedder.createTiledLayout(this.tileW, this.tileH, 0, 0);
                                }
                                stream.reset();
                                reader.reset();
                                reader.dispose();
                                streamOut = ImageIOExt.createImageOutputStream(null, (Object)files[this.fileBeingProcessed]);
                                if (streamOut != null) break block231;
                                message = new StringBuilder("Unable to acquire an ImageOutputStream for the file ").append(files[this.fileBeingProcessed].toString());
                                if (OverviewsEmbedder.LOGGER.isLoggable(Level.SEVERE)) {
                                    OverviewsEmbedder.LOGGER.severe(message.toString());
                                }
                                this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                                ** GOTO lbl493
                            }
                            writer = new TIFFImageWriterSpi().createWriterInstance();
                            writer.setOutput(streamOut);
                            writer.addIIOWriteProgressListener(this.writeProgressListener);
                            writer.addIIOWriteWarningListener(this.writeProgressListener);
                            param = writer.getDefaultWriteParam();
                            if (param.canWriteTiles()) break block232;
                            message = new StringBuilder("This format do not support tiling!");
                            if (OverviewsEmbedder.LOGGER.isLoggable(Level.SEVERE)) {
                                OverviewsEmbedder.LOGGER.severe(message.toString());
                            }
                            this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                            ** GOTO lbl549
                        }
                        if (writer.canInsertImage(numImages)) break block233;
                        message = new StringBuilder("This format do not support overviews!");
                        if (OverviewsEmbedder.LOGGER.isLoggable(Level.SEVERE)) {
                            OverviewsEmbedder.LOGGER.severe(message.toString());
                        }
                        this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                        ** GOTO lbl605
                    }
                    if (this.tileH != -1 & this.tileW != -1) {
                        param.setTilingMode(2);
                        param.setTiling(this.tileW, this.tileH, 0, 0);
                    } else {
                        param.setTilingMode(2);
                        param.setTiling(actualTileW, actualTileH, 0, 0);
                    }
                    if (this.compressionScheme != null && !Double.isNaN(this.compressionRatio)) {
                        param.setCompressionMode(2);
                        param.setCompressionType(this.compressionScheme);
                        param.setCompressionQuality((float)this.compressionRatio);
                    }
                    tilecacheSize = this.getTileCacheSize() <= 0L ? 0x8000000L : super.getTileCacheSize();
                    baseTC = JAI.createTileCache();
                    baseTC.setMemoryCapacity(tilecacheSize / 2L);
                    baseTC.setMemoryThreshold(1.0f);
                    scaleTC = JAI.createTileCache();
                    scaleTC.setMemoryCapacity(tilecacheSize / 2L);
                    scaleTC.setMemoryThreshold(1.0f);
                    newHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
                    newHints.add(new RenderingHints(JAI.KEY_TILE_CACHE, baseTC));
                    pbjRead = new ParameterBlock();
                    pbjRead.add(stream);
                    pbjRead.add((Object)0);
                    pbjRead.add(Boolean.FALSE);
                    pbjRead.add(Boolean.FALSE);
                    pbjRead.add(Boolean.FALSE);
                    pbjRead.add(null);
                    pbjRead.add(null);
                    pbjRead.add(null);
                    pbjRead.add(null);
                    currentImage = JAI.create((String)"ImageRead", (ParameterBlock)pbjRead, (RenderingHints)newHints);
                    message = new StringBuilder("Read original image  ").append(this.fileBeingProcessed);
                    if (OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) {
                        OverviewsEmbedder.LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                    this.overviewInProcess = 0;
                    while (this.overviewInProcess < this.numSteps) {
                        message = new StringBuilder("Subsampling step ").append(this.overviewInProcess).append(" of image  ").append(this.fileBeingProcessed);
                        if (OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) {
                            OverviewsEmbedder.LOGGER.fine(message.toString());
                        }
                        this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                        if (currentImage.getWidth() / this.downsampleStep <= 0 || currentImage.getHeight() / this.downsampleStep <= 0) break;
                        algorithm = SubsampleAlgorithm.valueOf(this.scaleAlgorithm);
                        switch (7.$SwitchMap$org$geotools$utils$imageoverviews$OverviewsEmbedder$SubsampleAlgorithm[algorithm.ordinal()]) {
                            case 1: {
                                newImage = this.scaleAverage((RenderedImage)currentImage, scaleTC);
                                break;
                            }
                            case 2: {
                                newImage = this.filteredSubsample((RenderedImage)currentImage, scaleTC);
                                break;
                            }
                            case 3: {
                                newImage = this.subsample(currentImage, scaleTC, (Interpolation)new InterpolationBilinear());
                                break;
                            }
                            case 4: {
                                newImage = this.subsample(currentImage, scaleTC, (Interpolation)new InterpolationBicubic(2));
                                break;
                            }
                            case 5: {
                                newImage = this.subsample(currentImage, scaleTC, (Interpolation)new InterpolationNearest());
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid scaling algorithm " + this.scaleAlgorithm);
                            }
                        }
                        imageMetadata = null;
                        if (writer instanceof TIFFImageWriter && (imageMetadata = writer.getDefaultImageMetadata(new ImageTypeSpecifier((RenderedImage)newImage), param)) != null) {
                            ((TIFFImageMetadata)imageMetadata).addShortOrLongField(254, 1);
                        }
                        writer.writeInsert(-1, new IIOImage((RenderedImage)newImage, null, imageMetadata), param);
                        message = new StringBuilder("Step ").append(this.overviewInProcess).append(" of image  ").append(this.fileBeingProcessed).append(" done!");
                        if (OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) {
                            OverviewsEmbedder.LOGGER.fine(message.toString());
                        }
                        this.fireEvent(message.toString(), (double)this.fileBeingProcessed * 100.0 / (double)numFiles);
                        baseTC.flush();
                        appo = baseTC;
                        baseTC = scaleTC;
                        scaleTC = appo;
                        currentImage = newImage;
                        ++this.overviewInProcess;
                    }
                    message = new StringBuilder("Done with  image  ").append(this.fileBeingProcessed);
                    if (OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) {
                        OverviewsEmbedder.LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)(this.fileBeingProcessed + 1) * 100.0 / (double)numFiles);
                    ** GOTO lbl661
                }
                catch (Throwable e) {
                    block179: {
                        block178: {
                            block177: {
                                block176: {
                                    this.fireException(e);
                                    var27_26 = null;
                                    if (baseTC != null) {
                                        try {
                                            baseTC.flush();
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                    }
                                    if (scaleTC != null) {
                                        try {
                                            scaleTC.flush();
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                    }
                                    try {
                                        if (streamOut != null) {
                                            streamOut.flush();
                                        }
                                    }
                                    catch (Throwable e) {
                                        if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block176;
                                        OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                    }
                                }
                                try {
                                    if (streamOut != null) {
                                        streamOut.close();
                                    }
                                }
                                catch (Throwable e) {
                                    if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block177;
                                    OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                            }
                            try {
                                if (writer != null) {
                                    writer.dispose();
                                }
                            }
                            catch (Throwable e) {
                                if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block178;
                                OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                        }
                        try {
                            if (currentImage != null) {
                                currentImage.dispose();
                            }
                        }
                        catch (Throwable e) {
                            if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block179;
                            OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                    if (newImage != null) {
                        newImage.dispose();
                    }
                    try {
                        stream.close();
                    }
                    catch (Throwable e) {
                        if (OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) {
                            OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                        break block180;
                    }
                }
                {
                    block227: {
                        block226: {
                            block225: {
                                block224: {
                                    block223: {
                                        block222: {
                                            block221: {
                                                block220: {
                                                    block219: {
                                                        block218: {
                                                            block217: {
                                                                block216: {
                                                                    block215: {
                                                                        block214: {
                                                                            block213: {
                                                                                block212: {
                                                                                    block211: {
                                                                                        block210: {
                                                                                            block209: {
                                                                                                block208: {
                                                                                                    block207: {
                                                                                                        block206: {
                                                                                                            block205: {
                                                                                                                block204: {
                                                                                                                    block203: {
                                                                                                                        block202: {
                                                                                                                            block201: {
                                                                                                                                block200: {
                                                                                                                                    block199: {
                                                                                                                                        block198: {
                                                                                                                                            block197: {
                                                                                                                                                block196: {
                                                                                                                                                    block195: {
                                                                                                                                                        block194: {
                                                                                                                                                            block193: {
                                                                                                                                                                block192: {
                                                                                                                                                                    block191: {
                                                                                                                                                                        block190: {
                                                                                                                                                                            block189: {
                                                                                                                                                                                block188: {
                                                                                                                                                                                    block187: {
                                                                                                                                                                                        block234: {
                                                                                                                                                                                            catch (Throwable var26_28) {
                                                                                                                                                                                                block186: {
                                                                                                                                                                                                    block185: {
                                                                                                                                                                                                        block184: {
                                                                                                                                                                                                            block183: {
                                                                                                                                                                                                                block182: {
                                                                                                                                                                                                                    block181: {
                                                                                                                                                                                                                        var27_26 = null;
                                                                                                                                                                                                                        if (baseTC != null) {
                                                                                                                                                                                                                            ** try [egrp 2[TRYBLOCK] [16 : 2101->2111)] { 
lbl274:
                                                                                                                                                                                                                            // 1 sources

                                                                                                                                                                                                                            baseTC.flush();
                                                                                                                                                                                                                            break block181;
lbl276:
                                                                                                                                                                                                                            // 1 sources

                                                                                                                                                                                                                            catch (Exception e) {
                                                                                                                                                                                                                                // empty catch block
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (scaleTC != null) {
                                                                                                                                                                                                                        ** try [egrp 3[TRYBLOCK] [17 : 2118->2128)] { 
lbl281:
                                                                                                                                                                                                                        // 1 sources

                                                                                                                                                                                                                        scaleTC.flush();
                                                                                                                                                                                                                        break block182;
lbl283:
                                                                                                                                                                                                                        // 1 sources

                                                                                                                                                                                                                        catch (Exception e) {
                                                                                                                                                                                                                            // empty catch block
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                                ** try [egrp 4[TRYBLOCK] [18 : 2130->2145)] { 
lbl287:
                                                                                                                                                                                                                // 1 sources

                                                                                                                                                                                                                if (streamOut != null) {
                                                                                                                                                                                                                    streamOut.flush();
                                                                                                                                                                                                                }
                                                                                                                                                                                                                break block183;
lbl290:
                                                                                                                                                                                                                // 1 sources

                                                                                                                                                                                                                catch (Throwable e) {
                                                                                                                                                                                                                    if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block183;
                                                                                                                                                                                                                    OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                            ** try [egrp 5[TRYBLOCK] [19 : 2175->2190)] { 
lbl295:
                                                                                                                                                                                                            // 1 sources

                                                                                                                                                                                                            if (streamOut != null) {
                                                                                                                                                                                                                streamOut.close();
                                                                                                                                                                                                            }
                                                                                                                                                                                                            break block184;
lbl298:
                                                                                                                                                                                                            // 1 sources

                                                                                                                                                                                                            catch (Throwable e) {
                                                                                                                                                                                                                if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block184;
                                                                                                                                                                                                                OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                        ** try [egrp 6[TRYBLOCK] [20 : 2220->2233)] { 
lbl303:
                                                                                                                                                                                                        // 1 sources

                                                                                                                                                                                                        if (writer != null) {
                                                                                                                                                                                                            writer.dispose();
                                                                                                                                                                                                        }
                                                                                                                                                                                                        break block185;
lbl306:
                                                                                                                                                                                                        // 1 sources

                                                                                                                                                                                                        catch (Throwable e) {
                                                                                                                                                                                                            if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block185;
                                                                                                                                                                                                            OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                    ** try [egrp 7[TRYBLOCK] [21 : 2263->2276)] { 
lbl311:
                                                                                                                                                                                                    // 1 sources

                                                                                                                                                                                                    if (currentImage != null) {
                                                                                                                                                                                                        currentImage.dispose();
                                                                                                                                                                                                    }
                                                                                                                                                                                                    break block186;
lbl314:
                                                                                                                                                                                                    // 1 sources

                                                                                                                                                                                                    catch (Throwable e) {
                                                                                                                                                                                                        if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block186;
                                                                                                                                                                                                        OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                                if (newImage != null) {
                                                                                                                                                                                                    newImage.dispose();
                                                                                                                                                                                                }
                                                                                                                                                                                                ** try [egrp 8[TRYBLOCK] [22 : 2316->2326)] { 
lbl321:
                                                                                                                                                                                                // 1 sources

                                                                                                                                                                                                stream.close();
                                                                                                                                                                                                throw var26_28;
lbl323:
                                                                                                                                                                                                // 1 sources

                                                                                                                                                                                                catch (Throwable e) {
                                                                                                                                                                                                    if (OverviewsEmbedder.LOGGER.isLoggable(Level.FINE) == false) throw var26_28;
                                                                                                                                                                                                    OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                                                                }
                                                                                                                                                                                                throw var26_28;
                                                                                                                                                                                            }
lbl327:
                                                                                                                                                                                            // 1 sources

                                                                                                                                                                                            ** try [egrp 2[TRYBLOCK] [16 : 2101->2111)] { 
lbl328:
                                                                                                                                                                                            // 1 sources

                                                                                                                                                                                            baseTC.flush();
                                                                                                                                                                                            break block234;
lbl330:
                                                                                                                                                                                            // 1 sources

                                                                                                                                                                                            catch (Exception e) {
                                                                                                                                                                                                // empty catch block
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                        if (scaleTC != null) {
                                                                                                                                                                                            ** try [egrp 3[TRYBLOCK] [17 : 2118->2128)] { 
lbl335:
                                                                                                                                                                                            // 1 sources

                                                                                                                                                                                            scaleTC.flush();
                                                                                                                                                                                            break block187;
lbl337:
                                                                                                                                                                                            // 1 sources

                                                                                                                                                                                            catch (Exception e) {
                                                                                                                                                                                                // empty catch block
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                    ** try [egrp 4[TRYBLOCK] [18 : 2130->2145)] { 
lbl341:
                                                                                                                                                                                    // 1 sources

                                                                                                                                                                                    if (streamOut != null) {
                                                                                                                                                                                        streamOut.flush();
                                                                                                                                                                                    }
                                                                                                                                                                                    break block188;
lbl344:
                                                                                                                                                                                    // 1 sources

                                                                                                                                                                                    catch (Throwable e) {
                                                                                                                                                                                        if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block188;
                                                                                                                                                                                        OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                                ** try [egrp 5[TRYBLOCK] [19 : 2175->2190)] { 
lbl349:
                                                                                                                                                                                // 1 sources

                                                                                                                                                                                if (streamOut != null) {
                                                                                                                                                                                    streamOut.close();
                                                                                                                                                                                }
                                                                                                                                                                                break block189;
lbl352:
                                                                                                                                                                                // 1 sources

                                                                                                                                                                                catch (Throwable e) {
                                                                                                                                                                                    if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block189;
                                                                                                                                                                                    OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            ** try [egrp 6[TRYBLOCK] [20 : 2220->2233)] { 
lbl357:
                                                                                                                                                                            // 1 sources

                                                                                                                                                                            if (writer != null) {
                                                                                                                                                                                writer.dispose();
                                                                                                                                                                            }
                                                                                                                                                                            break block190;
lbl360:
                                                                                                                                                                            // 1 sources

                                                                                                                                                                            catch (Throwable e) {
                                                                                                                                                                                if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block190;
                                                                                                                                                                                OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                        ** try [egrp 7[TRYBLOCK] [21 : 2263->2276)] { 
lbl365:
                                                                                                                                                                        // 1 sources

                                                                                                                                                                        if (currentImage != null) {
                                                                                                                                                                            currentImage.dispose();
                                                                                                                                                                        }
                                                                                                                                                                        break block191;
lbl368:
                                                                                                                                                                        // 1 sources

                                                                                                                                                                        catch (Throwable e) {
                                                                                                                                                                            if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block191;
                                                                                                                                                                            OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                    if (newImage != null) {
                                                                                                                                                                        newImage.dispose();
                                                                                                                                                                    }
                                                                                                                                                                    ** try [egrp 8[TRYBLOCK] [22 : 2316->2326)] { 
lbl375:
                                                                                                                                                                    // 1 sources

                                                                                                                                                                    stream.close();
lbl377:
                                                                                                                                                                    // 1 sources

                                                                                                                                                                    catch (Throwable e) {
                                                                                                                                                                        if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break;
                                                                                                                                                                        OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                                    }
                                                                                                                                                                    break;
lbl381:
                                                                                                                                                                    // 1 sources

                                                                                                                                                                    var27_26 = null;
                                                                                                                                                                    if (baseTC != null) {
                                                                                                                                                                        ** try [egrp 2[TRYBLOCK] [16 : 2101->2111)] { 
lbl384:
                                                                                                                                                                        // 1 sources

                                                                                                                                                                        baseTC.flush();
                                                                                                                                                                        break block192;
lbl386:
                                                                                                                                                                        // 1 sources

                                                                                                                                                                        catch (Exception e) {
                                                                                                                                                                            // empty catch block
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                                if (scaleTC != null) {
                                                                                                                                                                    ** try [egrp 3[TRYBLOCK] [17 : 2118->2128)] { 
lbl391:
                                                                                                                                                                    // 1 sources

                                                                                                                                                                    scaleTC.flush();
                                                                                                                                                                    break block193;
lbl393:
                                                                                                                                                                    // 1 sources

                                                                                                                                                                    catch (Exception e) {
                                                                                                                                                                        // empty catch block
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            ** try [egrp 4[TRYBLOCK] [18 : 2130->2145)] { 
lbl397:
                                                                                                                                                            // 1 sources

                                                                                                                                                            if (streamOut != null) {
                                                                                                                                                                streamOut.flush();
                                                                                                                                                            }
                                                                                                                                                            break block194;
lbl400:
                                                                                                                                                            // 1 sources

                                                                                                                                                            catch (Throwable e) {
                                                                                                                                                                if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block194;
                                                                                                                                                                OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                        ** try [egrp 5[TRYBLOCK] [19 : 2175->2190)] { 
lbl405:
                                                                                                                                                        // 1 sources

                                                                                                                                                        if (streamOut != null) {
                                                                                                                                                            streamOut.close();
                                                                                                                                                        }
                                                                                                                                                        break block195;
lbl408:
                                                                                                                                                        // 1 sources

                                                                                                                                                        catch (Throwable e) {
                                                                                                                                                            if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block195;
                                                                                                                                                            OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                    ** try [egrp 6[TRYBLOCK] [20 : 2220->2233)] { 
lbl413:
                                                                                                                                                    // 1 sources

                                                                                                                                                    if (writer != null) {
                                                                                                                                                        writer.dispose();
                                                                                                                                                    }
                                                                                                                                                    break block196;
lbl416:
                                                                                                                                                    // 1 sources

                                                                                                                                                    catch (Throwable e) {
                                                                                                                                                        if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block196;
                                                                                                                                                        OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                ** try [egrp 7[TRYBLOCK] [21 : 2263->2276)] { 
lbl421:
                                                                                                                                                // 1 sources

                                                                                                                                                if (currentImage != null) {
                                                                                                                                                    currentImage.dispose();
                                                                                                                                                }
                                                                                                                                                break block197;
lbl424:
                                                                                                                                                // 1 sources

                                                                                                                                                catch (Throwable e) {
                                                                                                                                                    if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block197;
                                                                                                                                                    OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            if (newImage != null) {
                                                                                                                                                newImage.dispose();
                                                                                                                                            }
                                                                                                                                            ** try [egrp 8[TRYBLOCK] [22 : 2316->2326)] { 
lbl431:
                                                                                                                                            // 1 sources

                                                                                                                                            stream.close();
lbl433:
                                                                                                                                            // 1 sources

                                                                                                                                            catch (Throwable e) {
                                                                                                                                                if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break;
                                                                                                                                                OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                            }
                                                                                                                                            break;
lbl437:
                                                                                                                                            // 1 sources

                                                                                                                                            var27_26 = null;
                                                                                                                                            if (baseTC != null) {
                                                                                                                                                ** try [egrp 2[TRYBLOCK] [16 : 2101->2111)] { 
lbl440:
                                                                                                                                                // 1 sources

                                                                                                                                                baseTC.flush();
                                                                                                                                                break block198;
lbl442:
                                                                                                                                                // 1 sources

                                                                                                                                                catch (Exception e) {
                                                                                                                                                    // empty catch block
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                        if (scaleTC != null) {
                                                                                                                                            ** try [egrp 3[TRYBLOCK] [17 : 2118->2128)] { 
lbl447:
                                                                                                                                            // 1 sources

                                                                                                                                            scaleTC.flush();
                                                                                                                                            break block199;
lbl449:
                                                                                                                                            // 1 sources

                                                                                                                                            catch (Exception e) {
                                                                                                                                                // empty catch block
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    ** try [egrp 4[TRYBLOCK] [18 : 2130->2145)] { 
lbl453:
                                                                                                                                    // 1 sources

                                                                                                                                    if (streamOut != null) {
                                                                                                                                        streamOut.flush();
                                                                                                                                    }
                                                                                                                                    break block200;
lbl456:
                                                                                                                                    // 1 sources

                                                                                                                                    catch (Throwable e) {
                                                                                                                                        if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block200;
                                                                                                                                        OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                ** try [egrp 5[TRYBLOCK] [19 : 2175->2190)] { 
lbl461:
                                                                                                                                // 1 sources

                                                                                                                                if (streamOut != null) {
                                                                                                                                    streamOut.close();
                                                                                                                                }
                                                                                                                                break block201;
lbl464:
                                                                                                                                // 1 sources

                                                                                                                                catch (Throwable e) {
                                                                                                                                    if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block201;
                                                                                                                                    OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                                }
                                                                                                                            }
                                                                                                                            ** try [egrp 6[TRYBLOCK] [20 : 2220->2233)] { 
lbl469:
                                                                                                                            // 1 sources

                                                                                                                            if (writer != null) {
                                                                                                                                writer.dispose();
                                                                                                                            }
                                                                                                                            break block202;
lbl472:
                                                                                                                            // 1 sources

                                                                                                                            catch (Throwable e) {
                                                                                                                                if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block202;
                                                                                                                                OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                            }
                                                                                                                        }
                                                                                                                        ** try [egrp 7[TRYBLOCK] [21 : 2263->2276)] { 
lbl477:
                                                                                                                        // 1 sources

                                                                                                                        if (currentImage != null) {
                                                                                                                            currentImage.dispose();
                                                                                                                        }
                                                                                                                        break block203;
lbl480:
                                                                                                                        // 1 sources

                                                                                                                        catch (Throwable e) {
                                                                                                                            if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block203;
                                                                                                                            OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (newImage != null) {
                                                                                                                        newImage.dispose();
                                                                                                                    }
                                                                                                                    try {}
                                                                                                                    catch (Throwable e) {
                                                                                                                        if (OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) {
                                                                                                                            OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                                        }
                                                                                                                    }
                                                                                                                    stream.close();
lbl493:
                                                                                                                    // 1 sources

                                                                                                                    var27_26 = null;
                                                                                                                    if (baseTC != null) {
                                                                                                                        ** try [egrp 2[TRYBLOCK] [16 : 2101->2111)] { 
lbl496:
                                                                                                                        // 1 sources

                                                                                                                        baseTC.flush();
                                                                                                                        break block204;
lbl498:
                                                                                                                        // 1 sources

                                                                                                                        catch (Exception e) {
                                                                                                                            // empty catch block
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                                if (scaleTC != null) {
                                                                                                                    ** try [egrp 3[TRYBLOCK] [17 : 2118->2128)] { 
lbl503:
                                                                                                                    // 1 sources

                                                                                                                    scaleTC.flush();
                                                                                                                    break block205;
lbl505:
                                                                                                                    // 1 sources

                                                                                                                    catch (Exception e) {
                                                                                                                        // empty catch block
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                            ** try [egrp 4[TRYBLOCK] [18 : 2130->2145)] { 
lbl509:
                                                                                                            // 1 sources

                                                                                                            if (streamOut != null) {
                                                                                                                streamOut.flush();
                                                                                                            }
                                                                                                            break block206;
lbl512:
                                                                                                            // 1 sources

                                                                                                            catch (Throwable e) {
                                                                                                                if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block206;
                                                                                                                OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                            }
                                                                                                        }
                                                                                                        ** try [egrp 5[TRYBLOCK] [19 : 2175->2190)] { 
lbl517:
                                                                                                        // 1 sources

                                                                                                        if (streamOut != null) {
                                                                                                            streamOut.close();
                                                                                                        }
                                                                                                        break block207;
lbl520:
                                                                                                        // 1 sources

                                                                                                        catch (Throwable e) {
                                                                                                            if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block207;
                                                                                                            OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                        }
                                                                                                    }
                                                                                                    ** try [egrp 6[TRYBLOCK] [20 : 2220->2233)] { 
lbl525:
                                                                                                    // 1 sources

                                                                                                    if (writer != null) {
                                                                                                        writer.dispose();
                                                                                                    }
                                                                                                    break block208;
lbl528:
                                                                                                    // 1 sources

                                                                                                    catch (Throwable e) {
                                                                                                        if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block208;
                                                                                                        OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                    }
                                                                                                }
                                                                                                ** try [egrp 7[TRYBLOCK] [21 : 2263->2276)] { 
lbl533:
                                                                                                // 1 sources

                                                                                                if (currentImage != null) {
                                                                                                    currentImage.dispose();
                                                                                                }
                                                                                                break block209;
lbl536:
                                                                                                // 1 sources

                                                                                                catch (Throwable e) {
                                                                                                    if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block209;
                                                                                                    OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                                }
                                                                                            }
                                                                                            if (newImage != null) {
                                                                                                newImage.dispose();
                                                                                            }
                                                                                            ** try [egrp 8[TRYBLOCK] [22 : 2316->2326)] { 
lbl543:
                                                                                            // 1 sources

                                                                                            stream.close();
lbl545:
                                                                                            // 1 sources

                                                                                            catch (Throwable e) {
                                                                                                if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break;
                                                                                                OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                            }
                                                                                            break;
lbl549:
                                                                                            // 1 sources

                                                                                            var27_26 = null;
                                                                                            if (baseTC != null) {
                                                                                                ** try [egrp 2[TRYBLOCK] [16 : 2101->2111)] { 
lbl552:
                                                                                                // 1 sources

                                                                                                baseTC.flush();
                                                                                                break block210;
lbl554:
                                                                                                // 1 sources

                                                                                                catch (Exception e) {
                                                                                                    // empty catch block
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        if (scaleTC != null) {
                                                                                            ** try [egrp 3[TRYBLOCK] [17 : 2118->2128)] { 
lbl559:
                                                                                            // 1 sources

                                                                                            scaleTC.flush();
                                                                                            break block211;
lbl561:
                                                                                            // 1 sources

                                                                                            catch (Exception e) {
                                                                                                // empty catch block
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    ** try [egrp 4[TRYBLOCK] [18 : 2130->2145)] { 
lbl565:
                                                                                    // 1 sources

                                                                                    if (streamOut != null) {
                                                                                        streamOut.flush();
                                                                                    }
                                                                                    break block212;
lbl568:
                                                                                    // 1 sources

                                                                                    catch (Throwable e) {
                                                                                        if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block212;
                                                                                        OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                    }
                                                                                }
                                                                                ** try [egrp 5[TRYBLOCK] [19 : 2175->2190)] { 
lbl573:
                                                                                // 1 sources

                                                                                if (streamOut != null) {
                                                                                    streamOut.close();
                                                                                }
                                                                                break block213;
lbl576:
                                                                                // 1 sources

                                                                                catch (Throwable e) {
                                                                                    if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block213;
                                                                                    OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                                }
                                                                            }
                                                                            ** try [egrp 6[TRYBLOCK] [20 : 2220->2233)] { 
lbl581:
                                                                            // 1 sources

                                                                            if (writer != null) {
                                                                                writer.dispose();
                                                                            }
                                                                            break block214;
lbl584:
                                                                            // 1 sources

                                                                            catch (Throwable e) {
                                                                                if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block214;
                                                                                OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                            }
                                                                        }
                                                                        ** try [egrp 7[TRYBLOCK] [21 : 2263->2276)] { 
lbl589:
                                                                        // 1 sources

                                                                        if (currentImage != null) {
                                                                            currentImage.dispose();
                                                                        }
                                                                        break block215;
lbl592:
                                                                        // 1 sources

                                                                        catch (Throwable e) {
                                                                            if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block215;
                                                                            OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                        }
                                                                    }
                                                                    if (newImage != null) {
                                                                        newImage.dispose();
                                                                    }
                                                                    ** try [egrp 8[TRYBLOCK] [22 : 2316->2326)] { 
lbl599:
                                                                    // 1 sources

                                                                    stream.close();
lbl601:
                                                                    // 1 sources

                                                                    catch (Throwable e) {
                                                                        if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break;
                                                                        OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                                    }
                                                                    break;
lbl605:
                                                                    // 1 sources

                                                                    var27_26 = null;
                                                                    if (baseTC != null) {
                                                                        ** try [egrp 2[TRYBLOCK] [16 : 2101->2111)] { 
lbl608:
                                                                        // 1 sources

                                                                        baseTC.flush();
                                                                        break block216;
lbl610:
                                                                        // 1 sources

                                                                        catch (Exception e) {
                                                                            // empty catch block
                                                                        }
                                                                    }
                                                                }
                                                                if (scaleTC != null) {
                                                                    ** try [egrp 3[TRYBLOCK] [17 : 2118->2128)] { 
lbl615:
                                                                    // 1 sources

                                                                    scaleTC.flush();
                                                                    break block217;
lbl617:
                                                                    // 1 sources

                                                                    catch (Exception e) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                            }
                                                            ** try [egrp 4[TRYBLOCK] [18 : 2130->2145)] { 
lbl621:
                                                            // 1 sources

                                                            if (streamOut != null) {
                                                                streamOut.flush();
                                                            }
                                                            break block218;
lbl624:
                                                            // 1 sources

                                                            catch (Throwable e) {
                                                                if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block218;
                                                                OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                            }
                                                        }
                                                        ** try [egrp 5[TRYBLOCK] [19 : 2175->2190)] { 
lbl629:
                                                        // 1 sources

                                                        if (streamOut != null) {
                                                            streamOut.close();
                                                        }
                                                        break block219;
lbl632:
                                                        // 1 sources

                                                        catch (Throwable e) {
                                                            if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block219;
                                                            OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                        }
                                                    }
                                                    ** try [egrp 6[TRYBLOCK] [20 : 2220->2233)] { 
lbl637:
                                                    // 1 sources

                                                    if (writer != null) {
                                                        writer.dispose();
                                                    }
                                                    break block220;
lbl640:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block220;
                                                        OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                    }
                                                }
                                                ** try [egrp 7[TRYBLOCK] [21 : 2263->2276)] { 
lbl645:
                                                // 1 sources

                                                if (currentImage != null) {
                                                    currentImage.dispose();
                                                }
                                                break block221;
lbl648:
                                                // 1 sources

                                                catch (Throwable e) {
                                                    if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block221;
                                                    OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                                }
                                            }
                                            if (newImage != null) {
                                                newImage.dispose();
                                            }
                                            ** try [egrp 8[TRYBLOCK] [22 : 2316->2326)] { 
lbl655:
                                            // 1 sources

                                            stream.close();
lbl657:
                                            // 1 sources

                                            catch (Throwable e) {
                                                if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break;
                                                OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                            }
                                            break;
lbl661:
                                            // 1 sources

                                            var27_26 = null;
                                            if (baseTC != null) {
                                                ** try [egrp 2[TRYBLOCK] [16 : 2101->2111)] { 
lbl664:
                                                // 1 sources

                                                baseTC.flush();
                                                break block222;
lbl666:
                                                // 1 sources

                                                catch (Exception e) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (scaleTC != null) {
                                            ** try [egrp 3[TRYBLOCK] [17 : 2118->2128)] { 
lbl671:
                                            // 1 sources

                                            scaleTC.flush();
                                            break block223;
lbl673:
                                            // 1 sources

                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    ** try [egrp 4[TRYBLOCK] [18 : 2130->2145)] { 
lbl677:
                                    // 1 sources

                                    if (streamOut != null) {
                                        streamOut.flush();
                                    }
                                    break block224;
lbl680:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block224;
                                        OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                    }
                                }
                                ** try [egrp 5[TRYBLOCK] [19 : 2175->2190)] { 
lbl685:
                                // 1 sources

                                if (streamOut != null) {
                                    streamOut.close();
                                }
                                break block225;
lbl688:
                                // 1 sources

                                catch (Throwable e) {
                                    if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block225;
                                    OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                            }
                            ** try [egrp 6[TRYBLOCK] [20 : 2220->2233)] { 
lbl693:
                            // 1 sources

                            if (writer != null) {
                                writer.dispose();
                            }
                            break block226;
lbl696:
                            // 1 sources

                            catch (Throwable e) {
                                if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block226;
                                OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                        }
                        ** try [egrp 7[TRYBLOCK] [21 : 2263->2276)] { 
lbl701:
                        // 1 sources

                        if (currentImage != null) {
                            currentImage.dispose();
                        }
                        break block227;
lbl704:
                        // 1 sources

                        catch (Throwable e) {
                            if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block227;
                            OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                    if (newImage != null) {
                        newImage.dispose();
                    }
                    ** try [egrp 8[TRYBLOCK] [22 : 2316->2326)] { 
lbl711:
                    // 1 sources

                    stream.close();
lbl713:
                    // 1 sources

                    catch (Throwable e) {}
                    if (!OverviewsEmbedder.LOGGER.isLoggable(Level.FINE)) break block180;
                    OverviewsEmbedder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
            ++this.fileBeingProcessed;
        }
        if (OverviewsEmbedder.LOGGER.isLoggable(Level.FINE) == false) return;
        OverviewsEmbedder.LOGGER.fine("Done!!!");
    }

    public void getNotification(ProcessingEvent event) {
        LOGGER.info("Progress is at " + event.getPercentage() + "\n" + "attached message is: " + event.getMessage());
    }

    public void exceptionOccurred(ExceptionEvent event) {
        LOGGER.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    public boolean parseArgs(String[] args) {
        if (!super.parseArgs(args)) {
            return false;
        }
        this.sourcePath = (String)this.getOptionValue(this.locationOpt);
        if (this.hasOption(this.tileDimOpt)) {
            String tileDim = (String)this.getOptionValue(this.tileDimOpt);
            String[] pairs = tileDim.split(",");
            this.tileW = Integer.parseInt(pairs[0]);
            this.tileH = Integer.parseInt(pairs[1]);
        }
        String scaleF = (String)this.getOptionValue(this.scaleFactorOpt);
        this.downsampleStep = Integer.parseInt(scaleF);
        if (this.hasOption(this.wildcardOpt)) {
            this.wildcardString = (String)this.getOptionValue(this.wildcardOpt);
        }
        this.scaleAlgorithm = (String)this.getOptionValue(this.scaleAlgorithmOpt);
        if (this.scaleAlgorithm == null) {
            this.scaleAlgorithm = "nn";
        }
        this.numSteps = Integer.parseInt((String)this.getOptionValue(this.numStepsOpt));
        if (this.hasOption(this.compressionTypeOpt)) {
            this.compressionScheme = (String)this.getOptionValue(this.compressionTypeOpt);
            if (this.compressionScheme == "") {
                this.compressionScheme = null;
            }
        }
        if (this.hasOption(this.compressionRatioOpt)) {
            try {
                this.compressionRatio = Double.parseDouble((String)this.getOptionValue(this.compressionRatioOpt));
            }
            catch (Exception e) {
                this.compressionRatio = Double.NaN;
            }
        }
        return true;
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException, InterruptedException {
        OverviewsEmbedder overviewsEmbedder = new OverviewsEmbedder();
        overviewsEmbedder.addProcessingEventListener(overviewsEmbedder);
        if (overviewsEmbedder.parseArgs(args)) {
            Thread t = new Thread((Runnable)overviewsEmbedder, NAME);
            t.setPriority(overviewsEmbedder.getPriority());
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Unable to parse command line argumentBuilder, exiting...");
        }
    }

    public final void setWildcardString(String wildcardString) {
        this.wildcardString = wildcardString;
    }

    public final double getCompressionRatio() {
        return this.compressionRatio;
    }

    public final String getCompressionScheme() {
        return this.compressionScheme;
    }

    public void setCompressionRatio(double compressionRatio) {
        this.compressionRatio = compressionRatio;
    }

    public void setCompressionScheme(String compressionScheme) {
        this.compressionScheme = compressionScheme;
    }

    public String getScaleAlgorithm() {
        return this.scaleAlgorithm;
    }

    public void setScaleAlgorithm(String scaleAlgorithm) {
        this.scaleAlgorithm = scaleAlgorithm;
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public void setNumSteps(int numSteps) {
        this.numSteps = numSteps;
    }

    public OverviewsEmbedderWriteProgressListener getWriteProgressListener() {
        return this.writeProgressListener;
    }

    public String getWildcardString() {
        return this.wildcardString;
    }

    static class 7 {
        static final /* synthetic */ int[] $SwitchMap$org$geotools$utils$imageoverviews$OverviewsEmbedder$SubsampleAlgorithm;

        static {
            $SwitchMap$org$geotools$utils$imageoverviews$OverviewsEmbedder$SubsampleAlgorithm = new int[SubsampleAlgorithm.values().length];
            try {
                7.$SwitchMap$org$geotools$utils$imageoverviews$OverviewsEmbedder$SubsampleAlgorithm[SubsampleAlgorithm.Average.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                7.$SwitchMap$org$geotools$utils$imageoverviews$OverviewsEmbedder$SubsampleAlgorithm[SubsampleAlgorithm.Filtered.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                7.$SwitchMap$org$geotools$utils$imageoverviews$OverviewsEmbedder$SubsampleAlgorithm[SubsampleAlgorithm.Bilinear.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                7.$SwitchMap$org$geotools$utils$imageoverviews$OverviewsEmbedder$SubsampleAlgorithm[SubsampleAlgorithm.Bicubic.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                7.$SwitchMap$org$geotools$utils$imageoverviews$OverviewsEmbedder$SubsampleAlgorithm[SubsampleAlgorithm.Nearest.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private class OverviewsEmbedderWriteProgressListener
    extends WriteProgressListenerAdapter {
        private OverviewsEmbedderWriteProgressListener() {
        }

        public void imageComplete(ImageWriter source) {
            OverviewsEmbedder.this.fireEvent("Started with writing out overview number " + ((double)OverviewsEmbedder.this.overviewInProcess + 1.0), (double)(OverviewsEmbedder.this.overviewInProcess + 1 / OverviewsEmbedder.this.numSteps) * 100.0);
        }

        public void imageProgress(ImageWriter source, float percentageDone) {
            OverviewsEmbedder.this.fireEvent("Writing out overview " + (OverviewsEmbedder.this.overviewInProcess + 1), (double)((float)(OverviewsEmbedder.this.overviewInProcess / OverviewsEmbedder.this.numSteps) + percentageDone / (float)(100 * OverviewsEmbedder.this.numSteps)) * 100.0);
        }

        public void imageStarted(ImageWriter source, int imageIndex) {
            OverviewsEmbedder.this.fireEvent("Completed writing out overview number " + (OverviewsEmbedder.this.overviewInProcess + 1), (double)(OverviewsEmbedder.this.overviewInProcess / OverviewsEmbedder.this.numSteps) * 100.0);
        }

        public void warningOccurred(ImageWriter source, int imageIndex, String warning) {
            OverviewsEmbedder.this.fireEvent("Warning at overview " + (OverviewsEmbedder.this.overviewInProcess + 1), 0.0);
        }

        public void writeAborted(ImageWriter source) {
            OverviewsEmbedder.this.fireEvent("Aborted writing process.", 100.0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubsampleAlgorithm {
        Nearest,
        Bilinear,
        Bicubic,
        Average,
        Filtered;

    }
}

