/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.commons;

import java.util.Calendar;
import java.util.Date;

final class DurationUtil {
    private static final Calendar CALENDAR = Calendar.getInstance();
    private static final int YEARS = 0;
    private static final int MONTHS = 1;
    private static final int DAYS = 2;
    private static final int HOURS = 0;
    private static final int MINUTES = 1;
    private static final int SECONDS = 2;
    private static int[] DURATION_TIME = new int[3];

    private DurationUtil() {
    }

    private static int[] extractDurationDate(String duration) {
        int endDays;
        int endMonths;
        int endYears;
        int[] durationDate = new int[3];
        int i = 0;
        while (i < durationDate.length) {
            durationDate[i] = -1;
            ++i;
        }
        int cursor = duration.indexOf("P");
        if (cursor == -1) {
            return durationDate;
        }
        if ((endYears = duration.indexOf("Y", ++cursor)) >= 0) {
            int years;
            String strYears = duration.substring(cursor, endYears);
            durationDate[0] = years = Integer.parseInt(strYears);
            cursor = endYears + 1;
        }
        if ((endMonths = duration.indexOf("M", cursor)) >= 0) {
            int months;
            String strMonths = duration.substring(cursor, endMonths);
            durationDate[1] = months = Integer.parseInt(strMonths);
            cursor = endMonths + 1;
        }
        if ((endDays = duration.indexOf("D", cursor)) >= 0) {
            int days;
            String strDays = duration.substring(cursor, endDays);
            durationDate[2] = days = Integer.parseInt(strDays);
        }
        return durationDate;
    }

    private static int[] extractDurationTime(String duration) {
        int endSeconds;
        int endMinutes;
        int endHours;
        int i = 0;
        while (i < DURATION_TIME.length) {
            DurationUtil.DURATION_TIME[i] = -1;
            ++i;
        }
        int cursor = duration.indexOf("T");
        if (cursor == -1) {
            return DURATION_TIME;
        }
        if ((endHours = duration.indexOf("H", ++cursor)) >= 0) {
            int hours;
            String strHours = duration.substring(cursor, endHours);
            DurationUtil.DURATION_TIME[0] = hours = Integer.parseInt(strHours);
            cursor = endHours + 1;
        }
        if ((endMinutes = duration.indexOf("M", cursor)) >= 0) {
            int minutes;
            String strMinutes = duration.substring(cursor, endMinutes);
            DurationUtil.DURATION_TIME[1] = minutes = Integer.parseInt(strMinutes);
            cursor = endMinutes + 1;
        }
        if ((endSeconds = duration.indexOf("S", cursor)) >= 0) {
            int seconds;
            String strSeconds = duration.substring(cursor, endSeconds);
            DurationUtil.DURATION_TIME[2] = seconds = Integer.parseInt(strSeconds);
        }
        return DURATION_TIME;
    }

    public static Date addDurationToDate(Date date, String duration) throws NumberFormatException {
        boolean positive = true;
        Date computedDate = null;
        computedDate = DurationUtil.computeDateFromDurationDate(date, duration, 1);
        computedDate = DurationUtil.computeDateFromDurationTime(computedDate, duration, 1);
        return computedDate;
    }

    private static Date computeDateFromDurationDate(Date date, String duration, int sign) {
        int[] durationDate = new int[3];
        durationDate = DurationUtil.extractDurationDate(duration);
        if (DurationUtil.isNull(durationDate)) {
            return date;
        }
        CALENDAR.setTime(date);
        if (durationDate[0] >= 0) {
            CALENDAR.add(1, sign * durationDate[0]);
        }
        if (durationDate[1] >= 0) {
            CALENDAR.add(2, sign * durationDate[1]);
        }
        if (durationDate[2] >= 0) {
            CALENDAR.add(5, sign * durationDate[2]);
        }
        Date lastDate = CALENDAR.getTime();
        return lastDate;
    }

    private static boolean isNull(int[] durDate) {
        int i = 0;
        while (i < durDate.length) {
            if (durDate[i] >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Date computeDateFromDurationTime(Date date, String duration, int sign) {
        DURATION_TIME = DurationUtil.extractDurationTime(duration);
        if (DurationUtil.isNull(DURATION_TIME)) {
            return date;
        }
        CALENDAR.setTime(date);
        if (DURATION_TIME[0] >= 0) {
            CALENDAR.add(10, sign * DURATION_TIME[0]);
        }
        if (DURATION_TIME[1] >= 0) {
            CALENDAR.add(12, sign * DURATION_TIME[1]);
        }
        if (DURATION_TIME[2] >= 0) {
            CALENDAR.add(13, sign * DURATION_TIME[2]);
        }
        Date lastDate = CALENDAR.getTime();
        return lastDate;
    }

    public static Date subtractDurationToDate(Date date, String duration) {
        int negative = -1;
        Date computedDate = null;
        computedDate = DurationUtil.computeDateFromDurationDate(date, duration, -1);
        computedDate = DurationUtil.computeDateFromDurationTime(computedDate, duration, -1);
        return computedDate;
    }
}

