/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.gen.PreGeneralizedFeatureIterator;
import org.geotools.data.gen.PreGeneralizedSimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreGeneralizedFeatureCollection
implements SimpleFeatureCollection {
    protected SimpleFeatureCollection backendCollection;
    protected SimpleFeatureType featureType;
    protected String geomPropertyName;
    protected String backendGeomPropertyName;
    protected int[] indexMapping;
    List<CollectionListener> listeners = new ArrayList<CollectionListener>();

    public PreGeneralizedFeatureCollection(SimpleFeatureCollection backendCollection, SimpleFeatureType featureType, int[] indexMapping, String geomPropertyName, String backendGeomPropertyName) {
        this.backendCollection = backendCollection;
        this.featureType = featureType;
        this.geomPropertyName = geomPropertyName;
        this.backendGeomPropertyName = backendGeomPropertyName;
        this.indexMapping = indexMapping;
    }

    protected UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Cannot modify a pregeneralized feature collection");
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        Iterator<SimpleFeature> iterator = null;
        if (progress == null) {
            progress = new NullProgressListener();
        }
        try {
            block9: {
                float position;
                float size;
                block8: {
                    size = this.size();
                    position = 0.0f;
                    progress.started();
                    iterator = this.iterator();
                    if (!true) break block8;
                    if (progress.isCanceled()) return;
                    if (!iterator.hasNext()) break block9;
                }
                do {
                    try {
                        SimpleFeature feature = iterator.next();
                        visitor.visit((Feature)feature);
                    }
                    catch (Exception erp) {
                        progress.exceptionOccurred((Throwable)erp);
                    }
                    float f = position;
                    position = f + 1.0f;
                    progress.progress(f / size);
                    if (progress.isCanceled()) return;
                } while (iterator.hasNext());
            }
            return;
        }
        finally {
            progress.complete();
            this.close(iterator);
        }
    }

    public boolean add(SimpleFeature arg0) {
        throw this.unsupported();
    }

    public boolean addAll(Collection arg0) {
        throw this.unsupported();
    }

    public boolean addAll(FeatureCollection arg0) {
        throw this.unsupported();
    }

    public void addListener(CollectionListener listener) throws NullPointerException {
        this.listeners.add(listener);
    }

    public void clear() {
        throw this.unsupported();
    }

    public void close(FeatureIterator<SimpleFeature> it) {
        it.close();
    }

    public void close(Iterator it) {
        if (it == null) {
            return;
        }
        try {
            int mod;
            Method closeMethod = it.getClass().getMethod("close", new Class[0]);
            if (closeMethod != null && Modifier.isPublic(mod = closeMethod.getModifiers()) && !Modifier.isStatic(mod)) {
                closeMethod.invoke((Object)it, new Object[0]);
            }
        }
        catch (SecurityException e) {
            return;
        }
        catch (NoSuchMethodException e) {
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("Error calling close method for " + it.getClass().getName());
        }
    }

    public boolean contains(Object feature) {
        if (feature instanceof PreGeneralizedSimpleFeature) {
            return this.backendCollection.contains((Object)((PreGeneralizedSimpleFeature)feature).feature);
        }
        return this.backendCollection.contains(feature);
    }

    public boolean containsAll(Collection coll) {
        ArrayList<Object> searchColl = new ArrayList<Object>();
        for (Object feature : coll) {
            if (feature instanceof PreGeneralizedSimpleFeature) {
                searchColl.add(((PreGeneralizedSimpleFeature)feature).feature);
                continue;
            }
            searchColl.add(feature);
        }
        return this.backendCollection.containsAll(searchColl);
    }

    public SimpleFeatureIterator features() {
        return new PreGeneralizedFeatureIterator(this.backendCollection.features(), this.featureType, this.indexMapping, this.geomPropertyName, this.backendGeomPropertyName);
    }

    public ReferencedEnvelope getBounds() {
        return this.backendCollection.getBounds();
    }

    public String getID() {
        return "pregeneralizd featurecollection";
    }

    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    public boolean isEmpty() {
        return this.backendCollection.isEmpty();
    }

    public Iterator<SimpleFeature> iterator() {
        final Iterator iterator = this.backendCollection.iterator();
        return new Iterator<SimpleFeature>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public SimpleFeature next() {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                return new PreGeneralizedSimpleFeature(PreGeneralizedFeatureCollection.this.featureType, PreGeneralizedFeatureCollection.this.indexMapping, feature, PreGeneralizedFeatureCollection.this.geomPropertyName, PreGeneralizedFeatureCollection.this.backendGeomPropertyName);
            }

            @Override
            public void remove() {
                throw PreGeneralizedFeatureCollection.this.unsupported();
            }

            public void close() {
                PreGeneralizedFeatureCollection.this.backendCollection.close(iterator);
            }
        };
    }

    public void purge() {
        throw this.unsupported();
    }

    public boolean remove(Object arg0) {
        throw this.unsupported();
    }

    public boolean removeAll(Collection arg0) {
        throw this.unsupported();
    }

    public void removeListener(CollectionListener listener) throws NullPointerException {
        this.listeners.remove(listener);
    }

    public boolean retainAll(Collection arg0) {
        throw this.unsupported();
    }

    public int size() {
        return this.backendCollection.size();
    }

    public SimpleFeatureCollection sort(SortBy sortBy) {
        SimpleFeatureCollection fColl = this.backendCollection.sort(sortBy);
        if (fColl == null) {
            return null;
        }
        return new PreGeneralizedFeatureCollection(fColl, this.featureType, this.indexMapping, this.geomPropertyName, this.backendGeomPropertyName);
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        SimpleFeatureCollection fColl = this.backendCollection.subCollection(filter);
        if (fColl == null) {
            return null;
        }
        return new PreGeneralizedFeatureCollection(fColl, this.featureType, this.indexMapping, this.geomPropertyName, this.backendGeomPropertyName);
    }

    public Object[] toArray() {
        Object[] res = this.backendCollection.toArray();
        int i = 0;
        while (i < res.length) {
            res[i] = new PreGeneralizedSimpleFeature(this.getSchema(), this.indexMapping, (SimpleFeature)res[i], this.geomPropertyName, this.backendGeomPropertyName);
            ++i;
        }
        return res;
    }

    public Object[] toArray(Object[] arg0) {
        Object[] res = this.backendCollection.toArray(arg0);
        int i = 0;
        while (i < res.length) {
            res[i] = new PreGeneralizedSimpleFeature(this.getSchema(), this.indexMapping, (SimpleFeature)res[i], this.geomPropertyName, this.backendGeomPropertyName);
            ++i;
        }
        return res;
    }
}

