/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultResourceInfo;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Repository;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.gen.PreGeneralizedDataStore;
import org.geotools.data.gen.PreGeneralizedFeatureCollection;
import org.geotools.data.gen.PreGeneralizedFeatureReader;
import org.geotools.data.gen.info.Generalization;
import org.geotools.data.gen.info.GeneralizationInfo;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.Hints;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreGeneralizedFeatureSource
implements SimpleFeatureSource {
    protected FeatureListenerManager listenerManager = new FeatureListenerManager();
    protected Repository repository;
    protected GeneralizationInfo info;
    protected PreGeneralizedDataStore dataStore;
    protected Logger log = Logging.getLogger(this.getClass());
    private SimpleFeatureSource baseFeatureSource;
    private Set<RenderingHints.Key> supportedHints;
    private Map<Generalization, SimpleFeatureSource> featureSourceCache;
    private QueryCapabilities queryCapabilities;
    private SimpleFeatureTypeImpl featureTyp;
    private Map<Double, int[]> indexMapping;
    private DefaultResourceInfo ri = null;

    public PreGeneralizedFeatureSource(GeneralizationInfo info, Repository repository, PreGeneralizedDataStore dataStore) {
        this.info = info;
        this.repository = repository;
        this.dataStore = dataStore;
        this.reset();
    }

    private void dsNotFoundException(String wsName, String dsName) throws IOException {
        String msg = "Data store named " + dsName;
        if (wsName != null) {
            msg = String.valueOf(msg) + " in workspace " + wsName;
        }
        msg = String.valueOf(msg) + " not found";
        throw new IOException(msg);
    }

    public void reset() {
        this.baseFeatureSource = null;
        this.featureSourceCache = new HashMap<Generalization, SimpleFeatureSource>();
        this.indexMapping = new HashMap<Double, int[]>();
        this.supportedHints = null;
        this.queryCapabilities = null;
        this.featureTyp = null;
    }

    private SimpleFeatureSource getBaseFeatureSource() throws IOException {
        if (this.baseFeatureSource != null) {
            return this.baseFeatureSource;
        }
        DataStore ds = this.repository.dataStore((Name)new NameImpl(this.info.getDataSourceNameSpace(), this.info.getDataSourceName()));
        if (ds == null) {
            this.dsNotFoundException(this.info.getDataSourceNameSpace(), this.info.getDataSourceName());
        }
        this.baseFeatureSource = ds.getFeatureSource(this.info.getBaseFeatureName());
        int[] mapping = this.calculateIndexMapping((SimpleFeatureType)this.baseFeatureSource.getSchema(), this.info.getGeomPropertyName(), this.info.getGeomPropertyName());
        this.indexMapping.put(0.0, mapping);
        return this.baseFeatureSource;
    }

    private int[] calculateIndexMapping(SimpleFeatureType backendType, String geomProperyName, String backendGeomPropertyName) throws IOException {
        int[] mapping = new int[this.getSchema().getAttributeCount()];
        int i = 0;
        while (i < mapping.length) {
            int j;
            block4: {
                String attrName = ((AttributeDescriptor)this.getSchema().getAttributeDescriptors().get(i)).getLocalName();
                if (attrName.equals(geomProperyName)) {
                    attrName = backendGeomPropertyName;
                }
                j = 0;
                while (j < backendType.getAttributeDescriptors().size()) {
                    if (!((AttributeDescriptor)backendType.getAttributeDescriptors().get(j)).getLocalName().equals(attrName)) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                throw new IOException("No attribute " + attrName + " found in " + backendType.getTypeName());
            }
            mapping[i] = j;
            ++i;
        }
        return mapping;
    }

    public void addFeatureListener(FeatureListener listener) {
        this.listenerManager.addFeatureListener((FeatureSource)this, listener);
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        Query newQuery = this.getProxyObject(query, this.getBaseFeatureSource());
        return this.getBaseFeatureSource().getBounds(newQuery);
    }

    public int getCount(Query query) throws IOException {
        Query newQuery = this.getProxyObject(query, this.getBaseFeatureSource());
        return this.getBaseFeatureSource().getCount(newQuery);
    }

    public DataAccess<SimpleFeatureType, SimpleFeature> getDataStore() {
        return this.dataStore;
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return new PreGeneralizedFeatureCollection(this.getBaseFeatureSource().getFeatures(), this.getSchema(), this.indexMapping.get(0.0), this.info.getGeomPropertyName(), this.info.getGeomPropertyName());
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return new PreGeneralizedFeatureCollection(this.getBaseFeatureSource().getFeatures(filter), this.getSchema(), this.indexMapping.get(0.0), this.info.getGeomPropertyName(), this.info.getGeomPropertyName());
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        SimpleFeatureSource fs = this.getFeatureSourceFor(query);
        Query newQuery = this.getProxyObject(query, fs);
        Generalization di = this.info.getGeneralizationForDistance(this.getRequestedDistance(query));
        if (di != null) {
            this.logDistanceInfo(di);
        }
        return new PreGeneralizedFeatureCollection(fs.getFeatures(newQuery), this.getSchema(), this.indexMapping.get(di == null ? 0.0 : di.getDistance()), this.info.getGeomPropertyName(), this.getBackendGeometryName(fs));
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        SimpleFeatureSource fs = this.getFeatureSourceFor(query);
        Query newQuery = this.getProxyObject(query, fs);
        DataAccess access = fs.getDataStore();
        if (access instanceof DataStore) {
            FeatureReader backendReader = ((DataStore)access).getFeatureReader(newQuery, transaction);
            String backendGeometryPropertyName = this.getBackendGeometryName(fs);
            Generalization di = this.info.getGeneralizationForDistance(this.getRequestedDistance(query));
            if (di != null) {
                this.logDistanceInfo(di);
            }
            return new PreGeneralizedFeatureReader(this.getSchema(), this.indexMapping.get(di == null ? 0.0 : di.getDistance()), (FeatureReader<SimpleFeatureType, SimpleFeature>)backendReader, this.info.getGeomPropertyName(), backendGeometryPropertyName);
        }
        return null;
    }

    public ResourceInfo getInfo() {
        if (this.ri != null) {
            return this.ri;
        }
        try {
            this.ri = new DefaultResourceInfo();
            this.ri.setBounds(this.getBaseFeatureSource().getBounds());
            if (((SimpleFeatureType)this.getBaseFeatureSource().getSchema()).getGeometryDescriptor() != null) {
                this.ri.setCRS(((SimpleFeatureType)this.getBaseFeatureSource().getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem());
            }
            this.ri.setDescription(this.getBaseFeatureSource().getInfo().getDescription());
            this.ri.setTitle(this.getBaseFeatureSource().getInfo().getTitle());
            this.ri.setName(this.getName().getLocalPart());
            TreeSet<String> keyWords = new TreeSet<String>();
            keyWords.addAll(this.getBaseFeatureSource().getInfo().getKeywords());
            keyWords.add("pregeneralized)");
            this.ri.setKeywords(keyWords);
        }
        catch (IOException ex) {
            this.ri = null;
            throw new RuntimeException(ex);
        }
        return this.ri;
    }

    public Name getName() {
        return new NameImpl(this.dataStore.getNamespace() == null ? null : this.dataStore.getNamespace().toString(), this.info.getFeatureName());
    }

    public QueryCapabilities getQueryCapabilities() {
        if (this.queryCapabilities != null) {
            return this.queryCapabilities;
        }
        this.queryCapabilities = new QueryCapabilities(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean isOffsetSupported() {
                try {
                    Generalization di;
                    SimpleFeatureSource fs;
                    if (!PreGeneralizedFeatureSource.this.getBaseFeatureSource().getQueryCapabilities().isOffsetSupported()) {
                        return false;
                    }
                    Iterator iterator = PreGeneralizedFeatureSource.this.info.getGeneralizations().iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return true;
                    } while ((fs = PreGeneralizedFeatureSource.this.getFeatureSourceFor(di = (Generalization)iterator.next())).getQueryCapabilities().isOffsetSupported());
                    return false;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean isReliableFIDSupported() {
                try {
                    Generalization di;
                    SimpleFeatureSource fs;
                    if (!PreGeneralizedFeatureSource.this.getBaseFeatureSource().getQueryCapabilities().isReliableFIDSupported()) {
                        return false;
                    }
                    Iterator iterator = PreGeneralizedFeatureSource.this.info.getGeneralizations().iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return true;
                    } while ((fs = PreGeneralizedFeatureSource.this.getFeatureSourceFor(di = (Generalization)iterator.next())).getQueryCapabilities().isReliableFIDSupported());
                    return false;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean supportsSorting(SortBy[] arg0) {
                try {
                    Generalization di;
                    SimpleFeatureSource fs;
                    if (!PreGeneralizedFeatureSource.this.getBaseFeatureSource().getQueryCapabilities().supportsSorting(arg0)) {
                        return false;
                    }
                    Iterator iterator = PreGeneralizedFeatureSource.this.info.getGeneralizations().iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return true;
                    } while ((fs = PreGeneralizedFeatureSource.this.getFeatureSourceFor(di = (Generalization)iterator.next())).getQueryCapabilities().supportsSorting(arg0));
                    return false;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        return this.queryCapabilities;
    }

    public SimpleFeatureType getSchema() {
        if (this.featureTyp != null) {
            return this.featureTyp;
        }
        try {
            SimpleFeatureType baseType = (SimpleFeatureType)this.getBaseFeatureSource().getSchema();
            ArrayList<AttributeDescriptor> attrDescrs = new ArrayList<AttributeDescriptor>();
            block2: for (AttributeDescriptor descr : baseType.getAttributeDescriptors()) {
                for (Generalization di : this.info.getGeneralizations()) {
                    if (di.getDataSourceName().equals(this.info.getDataSourceName()) && di.getFeatureName().equals(baseType.getName().getLocalPart()) && di.getGeomPropertyName().equals(descr.getName().getLocalPart())) continue block2;
                }
                attrDescrs.add(descr);
            }
            GeometryDescriptor geomDescr = (GeometryDescriptor)baseType.getDescriptor(this.info.getGeomPropertyName());
            this.featureTyp = new SimpleFeatureTypeImpl((Name)new NameImpl(this.dataStore.getNamespace() == null ? null : this.dataStore.getNamespace().toString(), this.info.getFeatureName()), attrDescrs, geomDescr, false, null, null, baseType.getDescription());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.featureTyp;
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        if (this.supportedHints != null) {
            return this.supportedHints;
        }
        HashSet<Hints.Key> hints = new HashSet<Hints.Key>();
        try {
            hints.addAll(this.getBaseFeatureSource().getSupportedHints());
            for (Generalization di : this.info.getGeneralizations()) {
                SimpleFeatureSource fs = this.getFeatureSourceFor(di);
                hints.retainAll(fs.getSupportedHints());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        hints.add(Hints.GEOMETRY_DISTANCE);
        this.supportedHints = Collections.unmodifiableSet(hints);
        return this.supportedHints;
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.listenerManager.removeFeatureListener((FeatureSource)this, listener);
    }

    private SimpleFeatureSource getFeatureSourceFor(Double requestedDistance) throws IOException {
        if (requestedDistance == null || requestedDistance == 0.0) {
            return this.getBaseFeatureSource();
        }
        Generalization di = this.info.getGeneralizationForDistance(requestedDistance);
        return this.getFeatureSourceFor(di);
    }

    private SimpleFeatureSource getFeatureSourceFor(Generalization di) throws IOException {
        if (di == null) {
            return this.getBaseFeatureSource();
        }
        SimpleFeatureSource fs = this.featureSourceCache.get(di);
        if (fs != null) {
            return fs;
        }
        DataStore ds = this.repository.dataStore((Name)new NameImpl(di.getDataSourceNameSpace(), di.getDataSourceName()));
        if (ds == null) {
            this.dsNotFoundException(di.getDataSourceNameSpace(), di.getDataSourceName());
        }
        fs = ds.getFeatureSource(di.getFeatureName());
        this.featureSourceCache.put(di, fs);
        int[] mapping = this.calculateIndexMapping((SimpleFeatureType)fs.getSchema(), this.info.getGeomPropertyName(), di.getGeomPropertyName());
        this.indexMapping.put(di.getDistance(), mapping);
        return fs;
    }

    private Double getRequestedDistance(Query query) {
        Double result = (Double)query.getHints().get((Object)Hints.GEOMETRY_DISTANCE);
        if (result == null) {
            this.log.warning("No hint for geometry distance in query, fallback to base feature");
        } else {
            this.log.info("Hint geometry distance: " + result);
        }
        return result;
    }

    private SimpleFeatureSource getFeatureSourceFor(Query query) throws IOException {
        Double distance = this.getRequestedDistance(query);
        String geomPropertyName = this.info.getGeomPropertyName();
        String[] queryProperyNames = query.getPropertyNames();
        if (queryProperyNames != null) {
            String[] stringArray = queryProperyNames;
            int n = queryProperyNames.length;
            int n2 = 0;
            while (n2 < n) {
                String prop = stringArray[n2];
                if (prop.equals(geomPropertyName)) {
                    return this.getFeatureSourceFor(distance);
                }
                ++n2;
            }
        } else {
            return this.getFeatureSourceFor(distance);
        }
        return this.getBaseFeatureSource();
    }

    private String getBackendGeometryName(SimpleFeatureSource fs) {
        for (Map.Entry<Generalization, SimpleFeatureSource> entry : this.featureSourceCache.entrySet()) {
            if (entry.getValue() != fs) continue;
            return entry.getKey().getGeomPropertyName();
        }
        return this.info.getGeomPropertyName();
    }

    protected Query getProxyObject(Query query, SimpleFeatureSource fs) {
        int i;
        String[] newPropNames;
        String baseGeomPropertyName = this.info.getGeomPropertyName();
        String backendGeomPropertyName = this.getBackendGeometryName(fs);
        String[] originalPropNames = query.getPropertyNames();
        if (originalPropNames == Query.ALL_NAMES) {
            newPropNames = new String[this.getSchema().getAttributeCount()];
            i = 0;
            while (i < newPropNames.length) {
                AttributeDescriptor attrDescr = (AttributeDescriptor)this.getSchema().getAttributeDescriptors().get(i);
                newPropNames[i] = attrDescr.getLocalName().equals(baseGeomPropertyName) ? backendGeomPropertyName : attrDescr.getLocalName();
                ++i;
            }
        } else {
            newPropNames = new String[originalPropNames.length];
            i = 0;
            while (i < newPropNames.length) {
                newPropNames[i] = originalPropNames[i].equals(baseGeomPropertyName) ? backendGeomPropertyName : originalPropNames[i];
                ++i;
            }
        }
        Query newQuery = new Query(query);
        newQuery.setTypeName(fs.getName().getLocalPart());
        newQuery.setPropertyNames(newPropNames);
        return newQuery;
    }

    protected void logDistanceInfo(Generalization di) {
        StringBuffer buff = new StringBuffer("Using generalizsation: ");
        buff.append(di.getDataSourceName()).append(" ");
        buff.append(di.getFeatureName()).append(" ");
        buff.append(di.getGeomPropertyName()).append(" ");
        buff.append(di.getDistance());
        this.log.info(buff.toString());
    }
}

