/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen.tool;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.Transaction;
import org.geotools.data.gen.info.GeneralizationInfosProviderImpl;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class Toolbox {
    static String MissingXMLConfig = "Missing XML config file ";
    static String MissingShapeFile = "Missing shape file ";
    static String MissingTargetDir = "Missing target directory ";
    static String MissingGeneralizations = "Missing generalization distances as comma seperated list ";

    public static void main(String[] args) {
        Toolbox toolBox = new Toolbox();
        boolean retval = false;
        try {
            retval = toolBox.parse(args);
        }
        catch (IOException e) {
            e.printStackTrace();
            retval = false;
        }
        if (retval) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public boolean parse(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Missing cmd validate | generalize");
            return false;
        }
        if ("validate".equalsIgnoreCase(args[0])) {
            if (args.length != 2) {
                System.out.println(MissingXMLConfig);
                return false;
            }
            this.validate(args[1]);
            System.out.println("Validation of " + args[1] + " successfull");
        } else if ("generalize".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                System.out.println(MissingShapeFile);
                return false;
            }
            if (args.length < 3) {
                System.out.println(MissingTargetDir);
                return false;
            }
            if (args.length < 4) {
                System.out.println(MissingGeneralizations);
                return false;
            }
            if (args.length > 4) {
                System.out.println("Too many arguments");
                this.dumpGeneralizeParameters(args);
                return false;
            }
            this.dumpGeneralizeParameters(args);
            this.generalizeShapeFile(args[1], args[2], args[3]);
        } else {
            System.out.println("Unknwon cmd: " + args[0]);
            return false;
        }
        return true;
    }

    protected void validate(String xmlLocation) throws IOException {
        GeneralizationInfosProviderImpl prov = new GeneralizationInfosProviderImpl();
        prov.getGeneralizationInfos(xmlLocation);
    }

    protected void generalizeShapeFile(String shapeFileName, String targetDirName, String generalizations) throws IOException {
        File shapeFile = new File(shapeFileName);
        if (!shapeFile.exists()) {
            throw new IOException("Could not find " + shapeFileName);
        }
        FileDataStore shapeDS = new ShapefileDataStoreFactory().createDataStore(shapeFile.toURI().toURL());
        File targetDir = new File(targetDirName);
        if (!targetDir.exists()) {
            throw new IOException("Could not find " + targetDir);
        }
        String[] distanceStrings = generalizations.split(",");
        Double[] distanceArray = new Double[distanceStrings.length];
        int i = 0;
        while (i < distanceStrings.length) {
            distanceArray[i] = new Double(distanceStrings[i]);
            ++i;
        }
        this.generalizeShapeFile(shapeFile, (DataStore)shapeDS, targetDir, distanceArray);
        shapeDS.dispose();
    }

    protected void generalizeShapeFile(File shapeFile, DataStore shapeDS, File targetDir, Double[] distanceArray) throws IOException {
        String typeName = shapeDS.getTypeNames()[0];
        SimpleFeatureSource fs = shapeDS.getFeatureSource(typeName);
        SimpleFeatureType ftype = (SimpleFeatureType)fs.getSchema();
        DataStore[] dataStores = this.createDataStores(shapeFile, targetDir, ftype, distanceArray);
        SimpleFeatureCollection fcoll = fs.getFeatures();
        SimpleFeatureIterator it = fcoll.features();
        int countTotal = fcoll.size();
        ArrayList<FeatureWriter> writers = new ArrayList<FeatureWriter>();
        int i = 0;
        while (i < dataStores.length) {
            writers.add(dataStores[i].getFeatureWriter(typeName, Transaction.AUTO_COMMIT));
            ++i;
        }
        int counter = 0;
        while (it.hasNext()) {
            SimpleFeature feature = (SimpleFeature)it.next();
            int i2 = 0;
            while (i2 < distanceArray.length) {
                FeatureWriter w = (FeatureWriter)writers.get(i2);
                SimpleFeature genFeature = (SimpleFeature)w.next();
                genFeature.setAttributes(feature.getAttributes());
                Geometry newGeom = TopologyPreservingSimplifier.simplify((Geometry)((Geometry)feature.getDefaultGeometry()), (double)distanceArray[i2]);
                genFeature.setDefaultGeometry((Object)newGeom);
                w.write();
                ++i2;
            }
            this.showProgress(countTotal, ++counter);
        }
        fcoll.close((FeatureIterator)it);
        for (FeatureWriter w : writers) {
            w.close();
        }
        DataStore[] dataStoreArray = dataStores;
        int n = dataStores.length;
        int n2 = 0;
        while (n2 < n) {
            DataStore ds = dataStoreArray[n2];
            ds.dispose();
            ++n2;
        }
    }

    DataStore[] createDataStores(File shapeFile, File targetDir, SimpleFeatureType ft, Double[] distanceArray) throws IOException {
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        String shapeFileName = shapeFile.getAbsolutePath();
        String newShapeFileRelativeName = null;
        int index = shapeFileName.lastIndexOf(File.separator);
        newShapeFileRelativeName = index == -1 ? shapeFileName : shapeFileName.substring(index + 1);
        DataStore[] result = new DataStore[distanceArray.length];
        int i = 0;
        while (i < distanceArray.length) {
            File dir;
            String newShapeFileDirName = targetDir.getAbsolutePath();
            if (!newShapeFileDirName.endsWith(File.separator)) {
                newShapeFileDirName = String.valueOf(newShapeFileDirName) + File.separator;
            }
            if (!(dir = new File(newShapeFileDirName = String.valueOf(newShapeFileDirName) + distanceArray[i] + File.separator)).exists()) {
                dir.mkdir();
            }
            File file = new File(String.valueOf(newShapeFileDirName) + newShapeFileRelativeName);
            HashMap<String, URL> params = new HashMap<String, URL>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            result[i] = factory.createNewDataStore(params);
            result[i].createSchema((FeatureType)ft);
            ((ShapefileDataStore)result[i]).forceSchemaCRS(ft.getCoordinateReferenceSystem());
            ++i;
        }
        return result;
    }

    private void dumpGeneralizeParameters(String[] argv) {
        int i = 1;
        while (i < argv.length) {
            String paramName = null;
            switch (i) {
                case 1: {
                    paramName = "Shape file";
                    break;
                }
                case 2: {
                    paramName = "Target directory";
                    break;
                }
                case 3: {
                    paramName = "Distances";
                    break;
                }
                default: {
                    paramName = "?????";
                }
            }
            System.out.printf("%-20s\t%s\n", paramName, argv[i]);
            ++i;
        }
    }

    private int calculatePercentage(int countTotal, int counter) {
        return counter * 100 / countTotal;
    }

    private void showProgress(int countTotal, int counter) {
        int prevPercentage;
        if (counter == 1) {
            System.out.print("% |");
        }
        int percentage = this.calculatePercentage(countTotal, counter);
        int n = prevPercentage = counter == 1 ? 0 : this.calculatePercentage(countTotal, counter - 1);
        if (percentage != prevPercentage) {
            System.out.print("#");
        }
        if (counter == countTotal) {
            System.out.println("|");
        }
    }
}

