/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.aggregate;

import java.util.Set;
import org.geotools.geometry.iso.root.GeometryImpl;
import org.opengis.geometry.Boundary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.aggregate.Aggregate;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregateImpl
extends GeometryImpl
implements Aggregate {
    protected Set<? extends Geometry> elements = null;

    public AggregateImpl(CoordinateReferenceSystem crs, Set<? extends Geometry> elements) {
        super(crs);
        this.elements = elements;
    }

    public Set<? extends Geometry> getElements() {
        return this.elements;
    }

    @Override
    public GeometryImpl clone() throws CloneNotSupportedException {
        return null;
    }

    @Override
    public Boundary getBoundary() {
        Boundary bounds = null;
        for (Geometry geometry : this.getElements()) {
            Boundary boundary = geometry.getBoundary();
            if (boundary == null) continue;
            if (bounds == null) {
                bounds = boundary;
                continue;
            }
            bounds.union((TransfiniteSet)boundary);
        }
        return bounds;
    }

    @Override
    public int getDimension(DirectPosition point) {
        if (point != null) {
            return point.getDimension();
        }
        int maxD = 0;
        for (Geometry geometry : this.getElements()) {
            maxD = Math.max(maxD, geometry.getDimension(null));
        }
        return maxD;
    }
}

