/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithmND;

public class AlgoPointND {
    public static double getDistanceSquare(double[] p0, double[] p1) {
        double sum = 0.0;
        int n = p0.length;
        for (int i = 0; i < n; ++i) {
            double a = p1[i] - p0[i];
            sum += a * a;
        }
        return sum;
    }

    public static double getDistance(double[] p0, double[] p1) {
        double sum = 0.0;
        int n = p0.length;
        for (int i = 0; i < n; ++i) {
            double a = p1[i] - p0[i];
            sum += a * a;
        }
        return Math.sqrt(sum);
    }

    public static double getDistanceToOrigin(double[] p0) {
        double sum = 0.0;
        int n = p0.length;
        for (int i = 0; i < n; ++i) {
            sum += p0[i] * p0[i];
        }
        return Math.sqrt(sum);
    }

    public static double[] subtract(double[] p0, double[] p1) {
        int n = p0.length;
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            result[i] = p1[i] - p0[i];
        }
        return result;
    }

    public static double[] add(double[] p0, double[] p1) {
        int n = p0.length;
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            result[i] = p0[i] + p1[i];
        }
        return result;
    }

    public static double[] scale(double[] p0, double factor) {
        int n = p0.length;
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            result[i] = p0[i] * factor;
        }
        return result;
    }

    public static double[][] split(double[] c0, double[] c1, double maxSpacingSquare) {
        double distSquare = AlgoPointND.getDistanceSquare(c0, c1);
        if (distSquare > maxSpacingSquare) {
            int n = (int)Math.ceil(Math.sqrt(distSquare / maxSpacingSquare));
            double r = 1.0 / (double)n;
            double[][] result = new double[n - 1][];
            for (int i = 1; i < n; ++i) {
                result[i - 1] = AlgoPointND.evaluate(c0, c1, (double)i * r);
            }
            return result;
        }
        return null;
    }

    public static double[] evaluate(double[] c0, double[] c1, double r) {
        int n = c0.length;
        double[] result = new double[n];
        double s = 1.0 - r;
        for (int i = 0; i < n; ++i) {
            result[i] = s * c0[i] + r * c1[i];
        }
        return result;
    }

    public static double[] normalize(double[] p) {
        double len = AlgoPointND.getDistanceToOrigin(p);
        double[] rCoord = null;
        if (len > 0.0) {
            rCoord = AlgoPointND.scale(p, 1.0 / len);
        } else {
            int n = p.length;
            for (int i = 0; i < n; ++i) {
                p[i] = 0.0;
            }
        }
        return rCoord;
    }
}

