/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.coordinate;

import java.io.Serializable;
import java.util.Arrays;
import org.geotools.geometry.iso.coordinate.DoublePointArray;
import org.geotools.geometry.iso.util.DoubleOperation;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class DoubleDirectPosition
implements DirectPosition,
Serializable {
    private static final long serialVersionUID = 1927101537353796968L;
    int index;
    double[] array;
    CoordinateReferenceSystem crs;

    public DoubleDirectPosition(DoublePointArray context, int index) {
        this(context.getCoordinateReferenceSystem(), context.array, context.start + index);
    }

    public DoubleDirectPosition(CoordinateReferenceSystem crs, double[] array) {
        this(crs, array, 0);
    }

    public DoubleDirectPosition(CoordinateReferenceSystem crs, double[] array, int index) {
        this.index = index;
        this.array = array;
        this.crs = crs;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public double[] getCoordinate() {
        double[] coords = new double[this.crs.getCoordinateSystem().getDimension()];
        System.arraycopy(this.array, this.index, coords, 0, this.crs.getCoordinateSystem().getDimension());
        return coords;
    }

    @Deprecated
    public double[] getCoordinates() {
        return this.getCoordinate();
    }

    public int getDimension() {
        return this.crs.getCoordinateSystem().getDimension();
    }

    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        return this.array[this.index + dimension];
    }

    public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        this.array[this.index + dimension] = value;
    }

    @Deprecated
    public DirectPosition getPosition() {
        return this;
    }

    public DirectPosition getDirectPosition() {
        return this;
    }

    public DirectPosition clone() {
        return new DoubleDirectPosition(this.crs, this.getCoordinates());
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        double[] coord = this.getCoordinates();
        result = 31 * result + Arrays.hashCode(coord);
        result = 31 * result + (this.crs == null ? 0 : this.crs.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof DirectPosition) {
            return this.equals((DirectPosition)o, 0.0);
        }
        if (o instanceof Position) {
            return ((Position)o).equals(this);
        }
        return false;
    }

    public boolean equals(DirectPosition position, double tol) {
        int D = position.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
        if (D != this.crs.getCoordinateSystem().getDimension()) {
            return false;
        }
        if (!CRS.equalsIgnoreMetadata((Object)this.getCoordinateReferenceSystem(), (Object)position.getCoordinateReferenceSystem())) {
            return false;
        }
        int i = 0;
        while (i < D) {
            if (!(Double.isNaN(position.getOrdinate(i)) && Double.isNaN(this.array[this.index + i]) || !(Math.abs(DoubleOperation.subtract(position.getOrdinate(i), this.array[this.index + i])) > tol))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        double[] coord = this.getCoordinates();
        int D = this.crs.getCoordinateSystem().getDimension();
        String str = "(" + this.array[this.index];
        int i = 1;
        while (i < coord.length) {
            str = String.valueOf(str) + " " + this.array[this.index + i];
            ++i;
        }
        return String.valueOf(str) + ")";
    }
}

