/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.coordinate;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.DoubleDirectPosition;
import org.geotools.geometry.iso.util.DoubleOperation;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoublePointArray
extends AbstractList<Position>
implements PointArray,
Serializable {
    private static final long serialVersionUID = 1250362674574138318L;
    double[] array;
    int start;
    int end;
    CoordinateReferenceSystem crs;

    public DoublePointArray(CoordinateReferenceSystem crs, double[] array) {
        this(crs, array, 0, array.length);
    }

    public DoublePointArray(CoordinateReferenceSystem crs, double[] array, int start, int end) {
        this.crs = crs;
        this.array = array;
        this.start = start;
        this.end = end;
    }

    @Override
    public List<Position> subList(int fromIndex, int toIndex) {
        int subStart = this.start + fromIndex * this.getDimension();
        int subEnd = this.start + toIndex * this.getDimension();
        return new DoublePointArray(this.crs, this.array, subStart, subEnd);
    }

    @Override
    public DirectPosition get(int index) {
        int D = this.getDimension();
        return new DoubleDirectPosition(this.crs, this.array, this.start + index * D);
    }

    @Override
    public Position set(int index, Position element) {
        int D = this.getDimension();
        return new DoubleDirectPosition(this.crs, this.array, this.start + index * D);
    }

    @Override
    public int size() {
        return this.end - this.start / this.crs.getCoordinateSystem().getDimension();
    }

    public DirectPosition getPosition(int index, DirectPosition position) throws IndexOutOfBoundsException {
        int D = this.getDimension();
        if (position == null) {
            double[] copy = new double[D];
            System.arraycopy(this.array, this.start + index * D, copy, 0, D);
            return new DoubleDirectPosition(this.crs, copy);
        }
        int i = 0;
        while (i < D) {
            position.setOrdinate(i, this.array[this.start + index * D + i]);
            ++i;
        }
        return position;
    }

    public void setPosition(int index, DirectPosition position) throws IndexOutOfBoundsException, UnsupportedOperationException {
        int D = this.getDimension();
        int i = 0;
        while (i < D) {
            this.array[this.start + index * D + i] = position.getOrdinate(i);
            ++i;
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public int getDimension() {
        return this.crs.getCoordinateSystem().getDimension();
    }

    public int length() {
        return (this.array.length - this.start) / this.getDimension();
    }

    public List<Position> positions() {
        return this;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.array);
        result = 31 * result + (this.crs == null ? 0 : this.crs.hashCode());
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DoublePointArray) {
            return this.equals((DoublePointArray)obj, 0.0);
        }
        return false;
    }

    public boolean equals(DoublePointArray dpArray, double tol) {
        int D = dpArray.getDimension();
        if (D != this.getDimension()) {
            return false;
        }
        if (dpArray.length() != this.length()) {
            return false;
        }
        int x = 0;
        while (x < dpArray.length()) {
            DirectPosition ddPos = dpArray.get(x);
            DirectPosition thisddPos = this.get(x);
            int i = 0;
            while (i < D) {
                if (Math.abs(DoubleOperation.subtract(ddPos.getOrdinate(i), thisddPos.getOrdinate(i))) > tol) {
                    return false;
                }
                ++i;
            }
            ++x;
        }
        return true;
    }

    public DirectPosition getDirectPosition(int index, DirectPosition dest) throws IndexOutOfBoundsException {
        if (dest == null) {
            dest = new DirectPositionImpl(this.get(index));
        } else {
            assert (dest.getCoordinateReferenceSystem().equals(this.crs));
            DirectPositionImpl dp = new DirectPositionImpl(this.get(index));
            int i = 0;
            while (i < dp.getCoordinates().length) {
                dest.setOrdinate(i, dp.getOrdinate(i));
                ++i;
            }
        }
        return dest;
    }

    public void setDirectPosition(int index, DirectPosition position) throws IndexOutOfBoundsException, UnsupportedOperationException {
        this.setPosition(index, position);
    }
}

