/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.LineStringImpl;
import org.geotools.geometry.iso.coordinate.PointArrayImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Merger {
    CoordinateReferenceSystem crs;

    public Merger(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public CurveImpl merge(List<CurveImpl> curves) {
        int i = 0;
        while (i < curves.size() - 1) {
            if (!curves.get(i).getEndPoint().equals((Object)curves.get(i + 1).getStartPoint())) {
                throw new IllegalArgumentException("Curves are not continuous");
            }
            ++i;
        }
        return null;
    }

    public CurveImpl merge(Set<CurveImpl> curves) {
        return null;
    }

    public CurveImpl merge(CurveImpl curve1, CurveImpl curve2) {
        CurveImpl firstCurve = null;
        CurveImpl secondCurve = null;
        if (curve1.getStartPoint().equals((Object)curve2.getEndPoint())) {
            firstCurve = curve2;
            secondCurve = curve1;
        } else if (curve1.getEndPoint().equals((Object)curve2.getStartPoint())) {
            firstCurve = curve1;
            secondCurve = curve2;
        } else {
            throw new IllegalArgumentException("Curves do not share a start and end point ");
        }
        ArrayList<CurveImpl> curves = new ArrayList<CurveImpl>();
        curves.add(firstCurve);
        curves.add(secondCurve);
        return this.mergeContinuousCurves(curves);
    }

    private CurveImpl mergeContinuousCurves(List<CurveImpl> curves) {
        ArrayList<Position> positionList = new ArrayList<Position>();
        int i = 0;
        int j = 0;
        i = 0;
        while (i < curves.size()) {
            List<DirectPosition> dPList = curves.get(i).asDirectPositions();
            j = 0;
            while (j < dPList.size() - 1) {
                positionList.add((Position)new DirectPositionImpl(dPList.get(j)));
                ++j;
            }
            ++i;
        }
        positionList.add((Position)curves.get(curves.size() - 1).getEndPoint());
        LineStringImpl lineString = new LineStringImpl(new PointArrayImpl((List<Position>)positionList), 0.0);
        ArrayList<LineStringImpl> segments = new ArrayList<LineStringImpl>();
        segments.add(lineString);
        if (segments == null) {
            // empty if block
        }
        return new CurveImpl(this.crs, segments);
    }
}

