/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.primitive;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.iso.io.GeometryToString;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.PrimitiveBoundaryImpl;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceBoundaryImpl
extends PrimitiveBoundaryImpl
implements SurfaceBoundary {
    private static final long serialVersionUID = -1357747117053853492L;
    private Ring exterior = null;
    private List<Ring> interior = null;

    public SurfaceBoundaryImpl(CoordinateReferenceSystem crs, Ring exterior, List<Ring> interior) {
        super(crs);
        this.exterior = exterior;
        this.interior = interior;
    }

    @Override
    public SurfaceBoundaryImpl clone() throws CloneNotSupportedException {
        Ring newExterior = (Ring)this.getExterior().clone();
        ArrayList<Ring> newInteriors = new ArrayList<Ring>();
        Iterator<Ring> interiors = this.getInteriors().iterator();
        while (interiors.hasNext()) {
            newInteriors.add((Ring)interiors.next().clone());
        }
        return new SurfaceBoundaryImpl(this.getCoordinateReferenceSystem(), newExterior, newInteriors);
    }

    public Ring getExterior() {
        return this.exterior;
    }

    public List<Ring> getInteriors() {
        return this.interior;
    }

    @Override
    public Envelope getEnvelope() {
        return this.exterior.getEnvelope();
    }

    @Override
    public Set<Complex> createBoundary() {
        return null;
    }

    public boolean isSimple() {
        return false;
    }

    @Override
    public int getDimension(DirectPosition point) {
        return 1;
    }

    @Override
    public DirectPosition getRepresentativePoint() {
        return ((CurveImpl)this.getExterior().getGenerators().iterator().next()).getStartPoint();
    }

    public String toString() {
        return GeometryToString.getString(this);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.exterior == null ? 0 : this.exterior.hashCode());
        result = 31 * result + (this.interior == null ? 0 : this.interior.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SurfaceBoundaryImpl other = (SurfaceBoundaryImpl)obj;
        if (this.exterior == null ? other.exterior != null : !this.exterior.equals((TransfiniteSet)other.exterior)) {
            return false;
        }
        return !(this.interior == null ? other.interior != null : !this.interior.equals(other.interior));
    }
}

